
X.Dom._useBuilder = true;

/* --------------------------------------
 *  通常のwebページに対して使用する場合、dom ready で dom tree を写し取るために使う．
 *  完全にワンページアプリで<body/>が空な場合、このコードはビルドに含める必要はない
 */
X.Dom.listenOnce( X.Dom.Event.DOM_PRE_INIT,
	X.Dom.DOM_W3C ?
(function(){
	var r    = Node.root,
		body = r._rawNode,
		i, n = 0,
		elmProgress;
	// TODO
	// textarea の内容を控えて、消す。xnode tree 構築後に復帰。でないと、html パースでこける
	
	// cleanup tree	
	(function/*cleanUpTree*/( elm, skip, head ){
		var moveToHead = 'style,bgsound,area,base,meta'.split( ',' ),
			remove     = 'script,noscript,noframes,comment,!,noembed,nolayer'.split( ',' ),
			noncleanup = 'pre,textarea,code,kbd,samp,xmp,plaintext,listing'.split( ',' ),
			nodes      = X.copyArray( elm.childNodes ),
			i          = 0,
			l          = nodes.length,
			node, tag, textNode, content;
		for( ; i < l; ++i ){
			node = nodes[ i ];
			switch( node.nodeType ){
				case 1 :
					tag = node.tagName.toLowerCase();
					if( moveToHead.indexOf( tag ) !== -1 ){
						head = head || document.getElementsByTagName( 'head' )[ 0 ];
						head.appendChild( node );
						continue;
					} else
					if( remove.indexOf( tag ) !== -1 ){
						elm.removeChild( node );
						continue;
					} else {
						// pre タグ以下はスペースの置換は行わない
						node.childNodes && node.childNodes.length && /*cleanUpTree*/arguments.callee( node, skip || noncleanup.indexOf( tag ) !== -1, head );
					};
					textNode = null;
					break;
				case 3 :
					content = skip ? node.data : X.Dom.cleanupWhiteSpace( node.data );
					//console.log( 'Delete space ' + node.data.length + ' => ' + content.length );
					if( !textNode && content !== ' ' && content.length ){
						node.data = content;
						textNode  = node;
						break;
					} else
					if( textNode ){
						textNode.data += content; // 直前が TextNode の場合 一本化して削除
					};
					// ブロック要素直下のスペースだけは削除？？
				default :
					//console.log( 'Remove type: ' + node.nodeType + ' value: ' + node.nodeValue );
					elm.removeChild( node );
					//++count;
			};
		};
	})( body );
	
	// body の属性値の取得

	body.appendChild( elmProgress = document.createElement( 'div' ) );
	elmProgress.style.cssText = 'position:absolute;top:0;left:0;z-index:9999;width:0;height:0.5em;background:#00f;overflow:hidden;';
	
	X.Dom.asyncParse( body.innerHTML, true )
		.listen( X.Event.PROGRESS,
			function(e){
				elmProgress.style.width = ( e.progress * 100 | 0 ) + '%';
			}
		)
		.listenOnce( X.Event.SUCCESS, function( e ){
			var xnodes = Node.root._xnodes = [], t;
			xnodes.push.apply( xnodes, e.xnodes );
			
			X.Dom._asyncCreateTree( Node.root, body.childNodes, elmProgress );
		} );

}) :
X.Dom.DOM_IE4 ?
(function(){
	var r    = Node.root,
		body = r._rawNode,
		i, n = 0, elmProgress = '_xdom_builder_progress';

	/*
	 * http://support.microsoft.com/kb/812417/ja
	 * PRB: outerHTML の HTML 要素のプロパティは、既定の属性は表示されません。
	 * 
	 * body.innerHTML でなく、 body.outerHTML にはできなかった、、、
	 */
	body.insertAdjacentHTML( 'BeforeEnd', '<div id="' + elmProgress + '" style="position:absolute;top:0;left:0;z-index:9999;width:0;height:0.5em;background:#00f;overflow:hidden;"></div>' );
	elmProgress = document.all[ elmProgress ];
	
	X.Dom.asyncParse( body.innerHTML, true )
		.listen( X.Event.PROGRESS,
			function(e){
				elmProgress.style.width = ( e.progress * 100 | 0 ) + '%';
			}
		)
		.listenOnce( X.Event.SUCCESS,
			function( e ){
				var xnodes = Node.root._xnodes = [], t;
				xnodes.push.apply( xnodes, e.xnodes );
				
				X.Dom._asyncCreateTree( Node.root, body.childNodes || body.children, elmProgress );
			}
		);
}) :
(function(){
	
}) );

X.Dom._asyncCreateTree = function ( parent, elems, elmProgress, async ){
	var xnodes      = async ? 0           : X.copyArray( parent._xnodes ),
		l           = async ? 0           : xnodes.length,
		stack       = async ? async.stack : [],
		done        = async ? async.done  : 0,
		startTime   = X.getTime(),		
		current     = async ? async.current : {
			me     : parent,
			xnodes : xnodes,
			l      : l,
			i      : 0,
			elems  : X.copyArray( elems ),
			j      : 0,
			xtext  : null,
			flag   : 0
		},
		xnode, i, dive;
	while( current || ( current = stack.pop() ) ){
		i = current.i;
		l = current.l;
		if( i < l ){
			parent = current.me;
			xnodes = current.xnodes;
			while( xnode = xnodes[ i ] ){			
				//
				dive = X.Dom._bindElementToXnode( parent, xnode, current );
				
				++i;
				++done;
				if( dive ){
					current.i = i;
					stack[ stack.length ] = current;
					
					current = dive;
					i       = 0;
					l       = dive.l;
					parent  = xnode;
					xnodes  = dive.xnodes;
					continue;
				};
				
				if( startTime + 16 <= X.getTime() ){
					current.i = i;
					if( async ){
						async.current = i < l && current;
						async.done    = done;
					};
					X.Timer.once( 0, X.Dom._asyncCreateTree, [ null, null, elmProgress, async || { stack : stack, current : i < l && current, done : done } ] );
					// progress
					elmProgress.style.width = ( ( 1 - done / Node._chashe.length ) * 100 | 0 ) + '%';
					return;
				};
			};			
		};
		current = null;
	};
	// complete
	X.Dom.asyncDispatch( 0, { type : X.Dom.Event.DOM_BUILDER_COMPLETE } );
	elmProgress.parentNode ? elmProgress.parentNode.removeChild( elmProgress ) : ( elmProgress.outerHTML = '' );
	delete X.Dom._asyncCreateTree;
	delete X.Dom._bindElementToXnode;
};

X.Dom._bindElementToXnode =
	X.Dom.DOM_W3C ?
		(function( parent, xnode, current ){
			var elems = current.elems,
				//j     = current.j,
				m     = elems.length,
				xtext = current.xtext,
				skipCleanup = current.skipCleanup,
				inPreTag    = current.inPreTag,
				elm, tag, text;
		
			xnode.parent = parent;
		
			for( ; current.j < m; ++current.j ){
				elm = elems[ current.j ];
				tag = elm.tagName;
				if( ( elm.nodeType !== 1 && elm.nodeType !== 3 ) || tag === '!' || ( tag && tag.charAt( 0 ) === '/' ) ){
					elm.parentNode.removeChild( elm );
					continue;
				};
		
				if( xnode._xnodeType === 1 ){
					if( elm.nodeType === 3 ){
						//if( !( text = elm.data ) || ( text = X.Dom.cleanupWhiteSpace( text ) ) === ' ' ){
						//	elm.parentNode.removeChild( elm );
						//	continue;
						//};
						alert( '[' +parent._tag + '>' +xnode._tag + '] !== ' + elm.nodeType + '\n' + elm.data );
					} else
					if( xnode._tag.toUpperCase() !== tag ){
						alert( '[' +parent._tag + '>' +xnode._tag + ' ' + (xnode._xnodes ? xnode._xnodes.length : '' ) + '] !== ' + tag + ' ' + (elm.childNodes ? elm.childNodes.length : '' ) + '\n' + elm.outerHTML );
					} else {
						xnode._rawNode = elm;
						//if( ( doc = elm.ownerDocument || elm.document ) && ( doc.createElement( 'p' ).tagName === doc.createElement( 'P' ).tagName ) ){
							if( tag.charAt( 0 ) === '/' ) tag = tag.slice( 1 );
							xnode._tag = tag; // .toUpperCase()
						//};
						xnode._root = parent._root;
						elm.UID     = xnode._uid;
						
						if( tag === 'TEXTAREA' ){
							xnode.attr( 'value', xnode.html() ).empty();
							current.xtext = null;
						} else
						if( !xnode.hasClass( 'skip-cleanup' ) && ( X.Dom.cleanupTagNames[ tag.toLowerCase() ] || tag === 'SCRIPT' || xnode.hasClass( 'cleanup-target' ) ) ){ // ie で body 内の script が2度よばれるのに対処
							//alert( '[' +parent._tag + '>' + xnode._tag + '] remove ... ' );
							xnode.destroy();
						} else
						if( elm.childNodes && elm.childNodes.length ){
							//alert( '[' +parent._tag + '>' + xnode._tag + ' ' + (xnode._xnodes ? xnode._xnodes.length : '' ) + '] === ' + tag + ' ' + (elm.childNodes ? elm.childNodes.length : '' ) + ' Hit\n' + elm.outerHTML );
							current.xtext = null;
							++current.j;
							
							return {
								me     : xnode,
								xnodes : X.copyArray( xnode._xnodes ),
								xtext  : null,
								flag   : 0,
								i      : 0,
								l      : xnode._xnodes.length,
								elems  : X.copyArray( elm.childNodes ),
								j      : 0,
								skipCleanup : skipCleanup || 0 <= X.Dom.skipCleanupTagNames.indexOf( tag.toLowerCase() )
							};
						};
					};
					++current.j;
					break;
				};
				
				if( elm.nodeType !== 3 ){
					if( !( text = xnode._text ) || ( text = X.Dom.cleanupWhiteSpace( text ) ) === ' ' ){
						console.log( '[' +parent._tag + '>' + xnode._uid + '] destroy ... ' );
						xnode.destroy();
						break;
					};
					alert(  parent._tag + '>' + '"' + xnode._text + '" !== ' + tag + '\n' + elm.outerHTML );
					break;
				};
				
				++current.j;
				xnode._rawNode = elm;
				xnode._root    = parent._root;
				if( !skipCleanup ){
					if( !( text = xnode._text ) || ( text = X.Dom.cleanupWhiteSpace( text ) ) === ' ' ){
						console.log( '[' +parent._tag + '>' + xnode._uid + '] destroy ... ' );
						xnode.destroy();
					};
					if( xtext ){
						xtext.text( xtext._text + text );
						console.log( '[' +parent._tag + '>' + xnode._uid + '] xtext,destroy ... ' );
						xnode.destroy();
					} else {
						//alert( parent._tag + '>' + '"' + text + '"\n' + elm.data );
						xnode.text( text );
					};
				} else
				if( xtext ){
					xtext.text( xtext._text + xnode._text );
					console.log( '[' +parent._tag + '>' + xnode._uid + '] xtext,destroy ... ' );
					xnode.destroy();
				};
				current.xtext = xtext || xnode;
				break;
			};
		}) :
		(function ( parent, xnode, current ){
			var elems = current.elems,
				j     = current.j,
				m     = elems.length,
				xtext = current.xtext,
				skipCleanup = current.skipCleanup,
				elm, tag, text;
		
			xnode.parent = parent;
			
			if( xnode._xnodeType === 3 ){
				//alert( X.Dom.cleanupWhiteSpace( xnode._text ) );
				if( !skipCleanup ){
					if( !( text = xnode._text ) || ( text = X.Dom.cleanupWhiteSpace( text ) ) === ' ' ){
						xnode.destroy();
					} else
					if( xtext ){
						//alert( 'xtext ' + text.charCodeAt( 0 ) + ' : ' + text.length );
						xtext.text( xtext._text + text );
						xnode.destroy();
					} else {
						//alert( 'xnode ' + text.charCodeAt( 0 ) + ' : ' + text.length );
						xnode.text( text );
					};
				} else
				if( xtext ){
					//alert( 'skip ' + text.charCodeAt( 0 ) + ' : ' + text.length );
					xtext.text( xtext._text + xnode._text );
					xnode.destroy();
				};
				current.flag |= 4;
				current.xtext = xtext || xnode;
				return;
			};
			
			if( xnode._xnodeType !== 1 ){
				//alert( xnode._xnodeType )
				return;
			};
			
			for( ; j < m; ++j, ++current.j ){
				elm = elems[ j ];
				tag = elm.tagName;
				/*
				 * 未知のタグについては、閉じタグも含めてタグ名扱いになる
				 */
				if( tag === '!' || tag.charAt( 0 ) === '/' ){
					//alert( '## ' + tag );
					continue;
				} else
				if( xnode._tag !== tag ){
					alert( xnode._tag + ' ' + ' !== ' + tag + '\nxnode.html():' + xnode.attr('cite') + '\nelm.outerHTML:' +  elm.outerHTML );
				} else {
					++current.j;
					
					xnode._rawNode = elm;
					xnode._root    = parent._root;
					//xnode._tag     = X.Dom.DTD.TAG_FIX[ tag ] || tag;
					if( !xnode.hasClass( 'skip-cleanup' ) && ( X.Dom.cleanupTagNames[ tag.toLowerCase() ] || tag === 'SCRIPT' || xnode.hasClass( 'cleanup-target' ) ) ){
						xnode.destroy();
						break;
					};
					
					!xnode._id && elm.setAttribute( 'id', 'ie4uid' + xnode._uid );
					elm.setAttribute( 'UID', xnode._uid );
					
					tag === 'INPUT' && (
						!xnode._attrs ?
							( xnode._attrs = { type : 'text' } ) :
							!xnode._attrs.type || ( xnode._attrs.type = 'text' )
					);
					current.flag |= 3;
					current.xtext = null;
					
					if( tag === 'TEXTAREA' ){
						xnode.attr( 'value', xnode.html() ).empty();
					} else
					if( xnode._xnodes && xnode._xnodes.length ){
						return {
							me     : xnode,
							xnodes : X.copyArray( xnode._xnodes ),
							xtext  : null,
							flag   : 0,
							i      : 0,
							l      : xnode._xnodes.length,
							elems  : X.copyArray( elm.children ),
							j      : 0,
							skipCleanup : skipCleanup || 0 <= X.Dom.skipCleanupTagNames.indexOf( tag.toLowerCase() )
						};
					};
					break;
				};
			};
			// for
			if( !xnode._rawNode ){
				alert( xnode._tag + ' ' + xnode._id + ' !== none...' );
			};
		
			// textNode がある
			( current.flag & 6 ) && ( parent._dirty |= X.Dom.Dirty.IE4_TEXTNODE_FIX );
		});
