/*
 * Vector Speach Balloon Test
 * 
 *   main.js
 * 
 *   version 0.1.0
 *              __________
 *             /          \
 *            /            \
 *            |,startX,Y    |
 * tailX,Y - <              |
 *            |'endX,Y      |
 *            \            /
 * 	           \__________/
 * 
 * 
 */

var test = (function(){
	var	PARAM = document.forms[ 0],
		WIDTH = PARAM[ 'width'],
		HEIGHT = PARAM[ 'height'],
		ANGLE = PARAM[ 'angle'],
		SVG_WRAP = document.getElementById( 'svg_wrap'),
		SVG_PATH = document.getElementById( 'path'),
		SVG_SRC = document.getElementById( 'svg_src'),
		SVG_SIZE = document.getElementById( 'svg_size');
		VML_PATH = document.getElementById( 'vml_preview'),
		VML_SRC = document.getElementById( 'vml_src'),
		VML_SIZE = document.getElementById( 'vml_size');
		TAIL_WIDTH = 6,
		TAIL_HEIGHT = 10,
		PADDING_TOP = TAIL_HEIGHT,
		PADDING_LEFT = TAIL_HEIGHT,
		ACCURACY = 1; // 有効少数桁
	
	function draw(){
		var	w = parseFloat( WIDTH.value),
			h = parseFloat( HEIGHT.value),
			a = parseFloat( ANGLE.value);
			
		if( !w || !h || w < 1 || h < 1){
			return;
		}
		WIDTH.value = ''+w;
		HEIGHT.value = ''+h;
		
		var	rx = w /2,
			ry = h /2,
			deg0 = a -355 +355,
			deg1, deg2,
			rad0 = deg0 * Math.PI / 180,
			rad1,rad2,
			startX, startY, endX, endY,
			_startX, _startY, _endX, _endY,
			d, _d, l,
			tailX = rx +( rx +TAIL_HEIGHT) * Math.cos( rad0),
			tailY = ry +( ry +TAIL_HEIGHT) * Math.sin( rad0);
	
	/*
	 * tailの太さをTAIL_WIDTHに一致させるため、0.1づつ角度を変えて太さを計算
	 */
		for( var i=0;;i+=0.1){
			deg1 = a -355 +355 +i;
			deg2 = a -355 +355 -i;
			rad1 = deg1 * Math.PI / 180;
			rad2 = deg2 * Math.PI / 180;
			
			_startX = rx +Math.cos( rad1) *rx;
			_startY = ry +Math.sin( rad1) *ry,
			_endX = rx +Math.cos( rad2) *rx,
			_endY = ry +Math.sin( rad2) *ry,	//円弧上のY位置＝円中心Y＋sin(角度×PI÷180)×円半径
				
			l = Math.abs(
					Math.sqrt(
						Math.pow( ( _startX -_endX), 2) + Math.pow( ( _startY -_endY), 2)
					)
				);
			_d = Math.abs( l -TAIL_WIDTH);
			if( i !== 0 && d < _d){
				/*
				 * TAIL_WIDTHとの差が増分になった段階でループの終了
				 */
				break;
			}
			d = _d;
			startX = _startX;
			startY = _startY;
			endX = _endX;
			endY = _endY;
		}			
		drawSVG( tailX, tailY, startX, startY, rx, ry, endX, endY);
		
		drawVML(
			tailX *10, tailY *10,
			endX *10, endY *10,
			rx *10, ry *10,
			startX *10, startY *10,
			w *10, h *10
		);
	}
	
	function drawSVG( tailX, tailY, startX, startY, rx, ry, endX, endY){
		var l = ',',
			draw = [
			'M' +cround( tailX + PADDING_LEFT) +l +cround( tailY +PADDING_TOP),
			'L' + cround( startX +PADDING_LEFT) + l + cround( startY +PADDING_TOP),
			'A' + rx + l + ry,
			'0 1 1',			// flag
			cround( endX +PADDING_LEFT) + l + cround( endY +PADDING_TOP),
			'z'
		].join( ' ');
			
		SVG_PATH.setAttribute( "d", draw);
		SVG_SRC.innerHTML = draw;
		SVG_SIZE.innerHTML = SVG_WRAP.offsetHeight || SVG_WRAP.height;
	}
	
	function drawVML( tailX, tailY, startX, startY, rx, ry, endX, endY, w, h){
		var l = ',',
			round = Math.round,
			path = [
			'<v:shape style="width:', w /10, 'px;height:', h /10, 'px;" ',
			'coordsize="', w, l, h,
			'" coordorigin="0,0" path="',
			' ar ', 0, l, 0, l, w, l, h, l,
			round( startX), l, round( startY), l,
			round( endX), l, round( endY),
			' l ', round( tailX), l, round( tailY),
			' x e" strokecolor="black" fillcolor="white" strokeweight="1.3" />'
		].join( '');
		
		VML_PATH.innerHTML = path;
		VML_PATH.style.marginTop =  ( ( tailY < 0) ? Math.floor( ( 60 +tailY) /10) : 10) +'px';
		VML_PATH.style.marginLeft = ( ( tailX < 0) ? Math.floor( ( 60 +tailX) /10) : 10) +'px';
		
		VML_SRC.value = path;
		VML_SIZE.innerHTML = VML_PATH.offsetHeight || VML_PATH.height;
	}
	
	function cround( v, r){
		r = r || ACCURACY;
		return Math.round(v*Math.pow(10.0,r))/Math.pow(10.0,r);
	}
	
	return {
		redraw: function(){
			draw();
			return false;
		}
	}
})();

window.onload = test.redraw;
