<?php
require_once('SmtpWorker.php');

class SendDaemon
{
	// シグナルキューの長さ
	const MAX_SIG_QUEUE_LEN = 3;
	// メイン処理のインターバル
	const SLEEP_SECS = 2;
	// シグナルを保持するキュー
	private $sigQueue = array();
	
	// smtp サーバ
	private $smtpServers  = array(
        "xxx.xxx.xxx.xxx",	
        "xxx.xxx.xxx.xxx"
        );
        
	/**
	 * シグナルをキューに格納する。
	 * @param $signo
	 * @return unknown_type
	 */
	function sigEnqueue($signo = NULL)
	{
		$this->sigQueue[] = $signo;
	}
	
	/**
	 * シグナルをキューから読み出す。
	 * @return unknown_type
	 */
	function sigDequeue()
	{
	    return array_shift($this->sigQueue);
	}
	
	/**
	 * シグナル受信時に、それをキューに格納する。
	 * @param $signo
	 * @return unknown_type
	 */
	function sigHandler($signo = NULL)
	{
		// シグナルを保存する。 
	    // キューがあふれたら、無視
		if ( count($this->sigQueue) >= self::MAX_SIG_QUEUE_LEN ) {
	    	return NULL;
	    }
	    $this->sigEnqueue($signo);    
	    return;
	}
	
	/**
	 * シグナル処理を行う。
	 * @param $signo　シグナル
	 * @return unknown_type
	 */
	function sigCheck($signo)
	{
		$ret = true;
	    switch ($signo)
	    {
		    case SIGTERM:   // 終了シグナル
		        $ret = FALSE; // 終了
		        print "SIGTERM\n";
		        break;
		    case SIGHUP:    // HUPシグナル
		        // デーモン再起動処理
		        print "SIGHUP\n";
		        break;
		    case SIGCHLD:   // 子プロセスが終了した場合
		        // 子プロセスのリソースの回収
		        pcntl_waitpid(-1, $status, WNOHANG);
		        print "SIGCHLD\n";
		        break;
		    default:
	            print "NULL\n";
	            break;
	    }
	    return $ret;
	}
	
	private function getNextMailDelivery()
	{
		return true;
	}

	private function waitChildProcess($childPid)
	{
	    foreach ($childPid as $pid) {
            pcntl_waitpid($pid, $status);
            print "child done : $pid. \n";  
	    }
        print "all children done. \n";	
	}
	
	/**
	 * 初期化処理
	 * @return unknown_type
	 */
	private function init()
	{
		// DB接続処理
		
		// logger準備
		
		// シグナルハンドラを登録
		pcntl_signal(SIGTERM, array($this, "sigHandler"));
	}
	
	/**
	 * のメイン処理
	 * @return unknown_type
	 */
	private function main() 
	{
		// メール配信情報をチェックし、未処理のものがあれば
		// 子プロセスに配信を依頼する。
		$cnt = 0;
		$alive = true;
		while($alive) {
            // デバッグ用
            if (++$cnt > 1) {
                break; 
            }
			// 未処理の配信情報を1件取得
			print "request check. \n";
			$nextMd = $this->getNextMailDelivery();
			if (empty($nextMd)) {
				break;
			}
			// 配信先件数を取得
			$allMailNum = 101;
            $smtpNum = count($this->smtpServers);
            // 1smtpサーバあたりの配信件数を計算
            $mailNumPerProcess = floor($allMailNum / $smtpNum);
            
            $childPid = array();
            for ($i=0; $i<$smtpNum; $i++) {
                if (($pid = pcntl_fork()) == 0 ) {
                    // 子プロセスの生成
                	$worker = new SmtpWorker();
                	$worker->run($i, $mailNumPerProcess);
                    exit(0);
                }
                $childPid[] = $pid;
            }
            // 子プロセスの終了処理
            $this->waitChildProcess($childPid);
			
            //　処理が1件終了したら、シグナルを処理する。
            $alive = $this->sigCheck($this->sigDequeue());
		}		
		print "main \n";
	}

	/**
	 * デーモン本体の処理
	 * @return unknown_type
	 */
	function run()
	{
		// pcntl_signalのコールバック関数を処理するために、
		// ticksの設定が必要。
		declare(ticks = 1);
		
		try {
		    $this->init();
		    // デーモンのメイン処理
		    $cnt = 0;
		    $alive = true;
		    while($alive)
		    {
                // デバッグ用
                if (++$cnt > 1) {
                    break; 
                }
		    	// メイン処理を行う。
                print "main loop : $cnt \n";
		    	$this->main();
		        if ($alive) {
		            // 処理の合間にスリープする。
		            sleep(self::SLEEP_SECS);
		        }
		    }
		} catch (Exception $e) {
		    print "Error! \n";
		}	
	}
}
?>
