CREATE TABLE System(
	@Id INTEGER IDENTITY PRIMARY KEY,
	@File VARCHAR NOT NULL,
	@Mode INTEGER NOT NULL DEFAULT 0, -- Daily:0 Weekly:1
	UNIQUE(@File, @Mode)
);

CREATE TABLE SystemLog(
	@SystemId INTEGER NOT NULL REFERENCES System(@Id),
	@BrandId INTEGER NOT NULL,
	@Date DATETIME NOT NULL,
	@Price INTEGER NOT NULL,
	@Number INTEGER NOT NULL,
	@Order INTEGER NOT NULL -- Buy:0 Sell:1
);

CREATE INDEX IndexSystemLog ON SystemLog(@SystemId, @BrandId);

CREATE TABLE BrandList(
	@Id INTEGER IDENTITY PRIMARY KEY,
	@Name VARCHAR NOT NULL
);

CREATE TABLE BrandList_Brand(
	@BrandListId INTEGER NOT NULL REFERENCES BrandList(@Id),
	@BrandId INTEGER NOT NULL,
	PRIMARY KEY(@BrandListId, @BrandId)
);
