// Copyright(C) 2003, 2005 Daisuke Arai <darai@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: PrimaryNode.cs,v 1.3 2007-12-27 08:34:39 panacoran Exp $

using System;

namespace Protra.Lib.Lang
{
	/// <summary>
	/// ꎟq̃m[h\NXłB
	/// </summary>
	public class PrimaryNode : Node
	{
		/// <summary>
		/// m[h
		/// </summary>
		private Node node;

		/// <summary>
		/// ͂܂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.ParseException">
		/// ɃG[ꍇthrow܂B
		/// </exception>
		/// <param name="context">ReLXg</param>
		public override void Parse(Context context)
		{
			this.ContextToken = (ContextToken)context.Current;

			ContextToken ct = (ContextToken)context.Current;
			if(ct.IsVariableName)
			{
				node = new VariableNode();
				node.Parse(context);
				return;
			}
			if(ct.IsLiteral)
			{
				node = new LiteralNode();
				node.Parse(context);
				return;
			}
			if(ct.IsFunctionName)
			{
				node = new FunctionNode();
				node.Parse(context);
				return;
			}

			string token = ct.ToString();
			switch(token)
			{
				case "[":
					node = new ArrayNode();
					node.Parse(context);
					return;
				case "(":
					context.MoveNext();
					node = new ExpressionNode();
					node.Parse(context);
					ct = (ContextToken)context.Current;
					token = ct.ToString();
					if(token != ")")
						throw new ParseException("')' expected", this.ContextToken);
					context.MoveNext();
					return;
			}

			throw new ParseException("syntax error", this.ContextToken);
		}

		/// <summary>
		/// \؂ȗ܂B
		/// </summary>
		/// <returns>ȗꂽm[h</returns>
		public override Node Simplify()
		{
			return node.Simplify();
		}

		/// <summary>
		/// vOs܂B
		/// </summary>
		/// <exception cref="Protra.Lib.Lang.RuntimeException">
		/// vOsɃG[ꍇthrow܂B
		/// </exception>
		/// <param name="resource">\[X</param>
		/// <param name="at">@pf̒l</param>
		/// <returns>s</returns>
		public override Value Execute(Resource resource, int at)
		{
			return node.Execute(resource, at);
		}
	}
}
