// Copyright (C) 2003 Daisuke Arai <darai@users.sourceforge.jp>
// 
// This program is part of Protra.
//
// Protra is free software: you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, see <http://www.gnu.org/licenses/>.
// 
// $Id: VariableTable.cs,v 1.2 2007-12-27 08:34:39 panacoran Exp $

using System;
using System.Collections;

namespace Protra.Lib.Lang
{
	/// <summary>
	/// ϐi[邽߂̃e[ułB
	/// ϐL[ƂValuei[ReiƂȂ܂B
	/// </summary>
	[Serializable]
	public class VariableTable
	{
		/// <summary>
		/// lێnbV
		/// </summary>
		Hashtable hash = new Hashtable();

		/// <summary>
		/// RXgN^
		/// </summary>
		public VariableTable() {}

		/// <summary>
		/// w肳ꂽO̕ϐ邩ǂf܂B
		/// </summary>
		/// <param name="name">ϐ</param>
		/// <returns>ϐ݂邩ǂ_lłB</returns>
		public bool ContainsName(string name)
		{
			return hash.ContainsKey(name);
		}

		/// <summary>
		/// ׂĂ̗vf폜܂B
		/// </summary>
		public void Clear()
		{
			hash.Clear();
		}

		/// <summary>
		/// OL[ƂĒl擾܂͐ݒ肵܂B
		/// </summary>
		public Value this[string name]
		{
			get { return (Value)hash[name]; }
			set { hash[name] = value; }
		}
	}
}
