using System;
using System.IO;
using System.Text;
using Protra.Lib.Db;

namespace ImportSplitData
{
	/// <summary>
	/// OmegaChartindex.txt番l荞ށB
	/// </summary>
	class ImportSplitData
	{
		/// <summary>
		/// AvP[ṼC Gg |CgłB
		/// </summary>
		[STAThread]
		static void Main(string[] args)
		{
			if (args.Length != 1)
				Environment.Exit(1);
			StreamReader reader = new StreamReader(args[0], Encoding.GetEncoding("Shift_JIS"));
			string line;
			while ((line = reader.ReadLine()) != null)
			{
				int code = 0;
				Brand[] brands = null;
				foreach (string entry in line.Split(','))
				{
					if (code == 0)
					{
						try
						{
							code = int.Parse(entry);
							brands = BrandTable.GetRecords(code);
						}
						catch
						{
							break;
						}
						continue;
					}
					if (!entry.StartsWith("S:"))
						continue;
					int y = int.Parse(entry.Substring(2, 4));
					int m = int.Parse(entry.Substring(6, 2));
					int d = int.Parse(entry.Substring(8, 2));
					DateTime date = new DateTime(y, m, d);
					double adjust = 1 / double.Parse(entry.Substring(11));
					if (date < new DateTime(2000, 1, 1))
						continue;
					foreach (Brand b in brands)
						if (SplitTable.Add(b.Id, date, adjust) != null)
							Console.WriteLine("{0}.{1}: {2:d} {3}",
								new Object[] {b.Code, b.MarketId, date, adjust});
				}
			}
		}
	}
}
