# -*- coding: utf-8 -*-

#	Copyright © 2014 dyknon
#
#	This file is part of Pylib-nicovideo.
#
#	Pylib-nicovideo is free software: you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation, either version 3 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program.  If not, see <http://www.gnu.org/licenses/>.

class Err(Exception):
	"""nicovideoで発生したエラーは全部これ。"""

#class InetErr(Err):
#	"""ネット接続で問題が発生した時"""
#	def __init__(self, message):
#		self.message = message
#
#	def __str__(self):
#		return "接続エラー: {}".format(self.message)

class HttpErr(Err):
	"""HTTPサーバーから帰ってきたステータスコードが200じゃない時"""
	def __init__(self, code, message):
		self.code = code
		self.message = message

	def __str__(self):
		return "HTTPエラーコード:{}:{}".format(self.code, self.message)

class InterpretErr(Err):
	"""構文解析で発生したエラー"""
	def __init__(self, what, where="", why=""):
		self.what = what
		self.where = where
		self.why = why

	def __str__(self):
		return "{}:構文解析エラー in {}:{}". \
			format(self.what, self.where, self.why)

class NotFound(Err):
	"""動画がなかった時などのエラー"""
	def __init__(self, nid, code="unknown"):
		self.id = nid
		self.code = code

	def __str__(self):
		return "id:{}は無いみたいです。code:{}". \
			format(self.id, self.code)

class ApiUpdated(Err):
	"""APIの返す値が想定外だった場合(迷ったらこれ)"""
	def __init__(self, reason):
		self.reason = reason

	def __str__(self):
		return "ニコニコからの返答が想定外です:{}".format(self.reason)
