/*!
 * Win32/WinCËႢbv摜NX
 */
#pragma once

#ifdef _WIN32_WCE
#include <imaging.h>
#else
#include <atlimage.h>
#endif

class Cq2chwmImage
{
private:
	CSize m_sizeBitmap;
	HBITMAP m_hBitmap;
#ifdef _WIN32_WCE
#else
	CImage *m_pImage;
#endif

private:
	CSize getAdjustSize(const CSize sizeImage, const CSize sizeHint);

public:
	Cq2chwmImage(void);
	~Cq2chwmImage(void);

	HBITMAP GetBitmap(){ return m_hBitmap; }
	HRESULT Create(CString cstr_filename, HDC hCompatibleDC = NULL);
	HRESULT Create(CString cstr_filename, int in_width, int in_height, HDC hCompatibleDC = NULL);
	void Destroy();
	int GetWidth();
	int GetHeight();
	CSize GetSize(){ return m_sizeBitmap; }
	static HRESULT GetSize(CString cstr_filename, CSize &size);
};
