#include "YoString.h"

//! 2chfXbhXgp[XNX
/*!
 * subject.txt1sp[XNX
 * SĂ̌fXbhXgp[XNX̊NXƂȂĂ
 */
class Cq2chwmBbsSubject
{
private:
	const char *m_chp_aid;
	const char *m_chp_aname;
	const char *m_chp_count;
	const char *m_chp_bname;
	const char *m_chp_burl;
	CYoString m_str_bid;

protected:
	virtual void SetArticleId(const char *chp_aid){ m_chp_aid = chp_aid; }
	virtual void SetArticleName(const char *chp_aname){ m_chp_aname = chp_aname; }
	virtual void SetCount(const char *chp_count){ m_chp_count = chp_count; }
	virtual void SetBoardName(const char *chp_bname){ m_chp_bname = chp_bname; }
	virtual void SetBoardUrl(const char *chp_burl){ m_chp_burl = chp_burl; }
	virtual void SetBoardId(const char *chp_bid){ m_str_bid = chp_bid; }

public:
	Cq2chwmBbsSubject();
	virtual ~Cq2chwmBbsSubject();

	virtual BOOL Parse(char *chp_line);
	virtual const char *GetArticleName(){ return m_chp_aname; }
	virtual const char *GetArticleId(){ return m_chp_aid; }
	virtual const char *GetCount(){ return m_chp_count; }
	virtual const char *GetBoardName(){ return m_chp_bname; }
	virtual const char *GetBoardUrl(){ return m_chp_burl; }
	virtual const char *GetBoardId(){ return m_str_bid; }
};

class Cq2chwmBbsSubjectMachi : public Cq2chwmBbsSubject
{
public:
	virtual BOOL Parse(char *chp_line);
};

class Cq2chwmBbsSubjectLivedoor : public Cq2chwmBbsSubject
{
private:
	CYoString m_str_aname;

public:
	virtual BOOL Parse(char *chp_line);
};

class Cq2chwmBbsSubjectManager
{
private:
	Cq2chwmBbsSubject *m_pBbsSubject;

public:
	Cq2chwmBbsSubjectManager(const char *chp_url);
	virtual ~Cq2chwmBbsSubjectManager();
	Cq2chwmBbsSubject *GetBbsSubject(){ return m_pBbsSubject; }
};
