// q2chwmTabCtrl.cpp : t@C
//

#include "stdafx.h"
#include "q2chwm.h"
#include "q2chwmTabCtrl.h"
#include "q2chwmConfig.h"

// Cq2chwmTabCtrl

IMPLEMENT_DYNAMIC(Cq2chwmTabCtrl, CTabCtrl)

Cq2chwmTabCtrl::Cq2chwmTabCtrl()
{
	m_bo_send_keydown = TRUE;
}

Cq2chwmTabCtrl::Cq2chwmTabCtrl(
	BOOL bo_send_keydown)
{
	m_bo_send_keydown = bo_send_keydown;
}

Cq2chwmTabCtrl::~Cq2chwmTabCtrl()
{
}


BEGIN_MESSAGE_MAP(Cq2chwmTabCtrl, CTabCtrl)
	ON_NOTIFY_REFLECT(TCN_SELCHANGE, &Cq2chwmTabCtrl::OnTcnSelchange)
	ON_WM_KEYDOWN()
END_MESSAGE_MAP()



// Cq2chwmTabCtrl bZ[W nh



void Cq2chwmTabCtrl::OnTcnSelchange(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	GetParent()->SendMessage(WM_USER_TABCLICKED);
	*pResult = 0;
}

void Cq2chwmTabCtrl::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	if (m_bo_send_keydown == TRUE) {
		GetParent()->SendMessage(WM_KEYDOWN, nChar, nRepCnt);
	} else {
		switch (nChar) {
		case VK_LEFT:
			{
				int in_cur = GetCurSel() - 1;
				if (in_cur < 0) {
					in_cur = GetItemCount() - 1;
				}
				SetCurSel(in_cur);
				GetParent()->SendMessage(WM_USER_TABCLICKED);
				::InvalidateRect(m_hWnd, NULL, TRUE);
			}
			break;
		case VK_RIGHT:
			{
				int in_cur = GetCurSel() + 1;
				if (in_cur == GetItemCount()) {
					in_cur = 0;
				}
				SetCurSel(in_cur);
				GetParent()->SendMessage(WM_USER_TABCLICKED);
				::InvalidateRect(m_hWnd, NULL, TRUE);
			}
			break;
		default:
			CTabCtrl::OnKeyDown(nChar, nRepCnt, nFlags);
		}
	}
}

BOOL Cq2chwmTabCtrl::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	cs.style |= TCS_OWNERDRAWFIXED;
	return CTabCtrl::PreCreateWindow(cs);
}

void Cq2chwmTabCtrl::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct)
{

	// TODO:  w肳ꂽڂ`悷邽߂̃R[hǉĂB
	TC_ITEM tci;
	CDC* pDC = CDC::FromHandle(lpDrawItemStruct->hDC);
	CRect rect(lpDrawItemStruct->rcItem);
	_TCHAR szTabText[MAX_PATH + 1];
	memset(szTabText,'\0',sizeof(szTabText));

	tci.mask = TCIF_TEXT;
	tci.pszText = szTabText;
	tci.cchTextMax = MAX_PATH;
	GetItem(lpDrawItemStruct->itemID, &tci);

	if (lpDrawItemStruct->itemAction & ODA_DRAWENTIRE) {
		CBrush cBrush(GetSysColor(COLOR_BTNFACE));
		pDC->FillRect(rect, &cBrush);
		pDC->SetBkColor(GetSysColor(COLOR_BTNFACE));
		pDC->SetTextColor(GetSysColor(COLOR_WINDOWTEXT));
		pDC->DrawText(tci.pszText, -1, rect, DT_LEFT|DT_NOPREFIX);
	}

	if ((lpDrawItemStruct->itemState & ODS_SELECTED) && 
	 (lpDrawItemStruct->itemAction & (ODA_SELECT | ODA_DRAWENTIRE)))
	{
		//Make the color of text of the selected tab to be BLUE.
		CBrush cBrush(GetSysColor(COLOR_MENU));
		pDC->FillRect(rect, &cBrush);
		pDC->SetBkColor(GetSysColor(COLOR_MENU));
		pDC->SetTextColor(Cq2chwmConfig::GetInstance()->GetColorActive());
		pDC->DrawText(tci.pszText, -1, rect, DT_LEFT|DT_NOPREFIX);
	}
}
