#pragma once

#include "YoPtrArray.h"
#include "q2chwmCommon.h"
#include "q2chwmBookmarkBoardItem.h"

class Cq2chwmBookmarkBoardFile : public CYoPtrArray
{
public:
	enum {
		IDX_INDEX = 0,
		IDX_BNAME,
		IDX_BID,
		IDX_SEARCH
	};

private:
	static int compAsc(const void *vop_user, const void *a, const void *b);
	static int compDesc(const void *vop_user, const void *a, const void *b);
	BOOL addItem(int in_index, const char *chp_bname, const char *chp_bid, const char *chp_burl);

public:
	Cq2chwmBookmarkBoardFile();
	~Cq2chwmBookmarkBoardFile();

	Cq2chwmBookmarkBoardItem *GetItem(int in_index){ return (Cq2chwmBookmarkBoardItem*)Get(in_index); }

	int Create();
	void RemoveAll();
	void Sort(int in_col, BOOL bo_asc);
	void RemoveItem(int in_index);
	int SearchItem(const char *chp_filename);
	BOOL AddItem(const char *chp_bname, const char *chp_bid, const char *chp_burl);
	void Remove(int in_pos);
	BOOL Write();
};
