#pragma once

#include "YoString.h"
#include "q2chwmCommon.h"

/*
class Cq2chwmMessage_
{
private:
	int m_in_msg;
	int m_in_type;
public:
	Cq2chwmMessage(int in_type);
	virtual ~Cq2chwmMessage();
	virtual int GetMessage(){ return m_in_msg; }
	virtual int GetType(){ return m_in_type; }

};
*/

class Cq2chwmMessage// : public Cq2chwmMessage_
{
private:
	int m_in_msg;
	int m_in_type;
	CYoString m_str_aid;
	CYoString m_str_burl;
	CYoString m_str_filename;

public:
	enum {
		TYPE_WRITEFILE = 0,
		TYPE_OPENFILE,
		TYPE_CLOSEFILE,
		TYPE_RELOADFILE,
		TYPE_CLOSETAB,
		TYPE_READURL,
	};

	Cq2chwmMessage(int in_type, const char *chp_aid, const char *chp_burl, const char *chp_filename);
	virtual ~Cq2chwmMessage();
	inline int GetType(){ return m_in_type; }
	inline int GetMessage(){ return m_in_msg; }
	inline const char *GetArticleId(){ return m_str_aid; }
	inline const char *GetBoardUrl(){ return m_str_burl; }
	inline const char *GetFileName(){ return m_str_filename; }
};

class Cq2chwmWriteFileMessage : public Cq2chwmMessage
{
private:
	CYoString m_str_data;

public:
	Cq2chwmWriteFileMessage(const char *chp_id, const char *chp_url, const char *chp_file, const char *chp_data);
	virtual ~Cq2chwmWriteFileMessage();
	const char *GetData(){ return m_str_data; }
};

class Cq2chwmReadUrlMessage : public Cq2chwmMessage
{
private:
	int m_in_recv;
	int m_in_recv_all;

public:
	Cq2chwmReadUrlMessage(const char *chp_id, const char *chp_url, const char *chp_file, int in_recv, int in_recv_all);
	virtual ~Cq2chwmReadUrlMessage();
	int GetRecvSize(){ return m_in_recv; }
	int GetRecvMaxSize(){ return m_in_recv_all; }
};

class Cq2chwmOpenFileMessage : public Cq2chwmMessage
{
private:
	BOOL m_bo_create;

public:
	Cq2chwmOpenFileMessage(const char *chp_id, const char *chp_url, const char *chp_file, BOOL bo_create);
	virtual ~Cq2chwmOpenFileMessage();
	BOOL GetCreate(){ return m_bo_create; }
};

class Cq2chwmCloseFileMessage : public Cq2chwmMessage
{
private:
	int m_in_write;

public:
	Cq2chwmCloseFileMessage(const char *chp_id, const char *chp_url, const char *chp_file, int in_write);
	virtual ~Cq2chwmCloseFileMessage();
	int GetWriteSize(){ return m_in_write; }
};

class Cq2chwmReloadFileMessage : public Cq2chwmMessage
{
public:
	Cq2chwmReloadFileMessage(const char *chp_id, const char *chp_url, const char *chp_file);
	virtual ~Cq2chwmReloadFileMessage();
};

class Cq2chwmCloseTabMessage : public Cq2chwmMessage
{
private:

public:
	Cq2chwmCloseTabMessage(const char *chp_id, const char *chp_url, const char *chp_file);
	virtual ~Cq2chwmCloseTabMessage();
};
