// MainFrm.cpp : CMainFrame NX̎
//

#include "stdafx.h"
#include "YoTime.h"
#include "q2chwm.h"
#include "MainFrm.h"
#include "q2chwmConfig.h"
#include "q2chwmMessageDialog.h"
#include "YoWinSock.h"
#include "q2chwmImageViewUrlReplace.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#define CURRENTMODE	((int)m_cModeArray.Get(m_cModeArray.Count() - 1))
#if defined(WIN32_PLATFORM_PSPC) || defined(WIN32_PLATFORM_WFSP)
#define TOOLBAR_HEIGHT 24
#endif // WIN32_PLATFORM_PSPC

const DWORD dwAdornmentFlags = 0; // [I] {^

// CMainFrame

IMPLEMENT_DYNCREATE(CMainFrame, CFrameWnd)

BEGIN_MESSAGE_MAP(CMainFrame, CFrameWnd)
	ON_WM_CREATE()
	ON_WM_SIZE()

	ON_MESSAGE(WM_USER_OPENURL, OnOpenUrl)
	ON_MESSAGE(WM_USER_BOARDCLICKED, OnBoardClicked)
	ON_MESSAGE(WM_USER_SUBJECTCLICKED, OnSubjectClicked)
	ON_MESSAGE(WM_USER_BOOKMARKCLICKED, OnBookmarkClicked)
	ON_MESSAGE(WM_USER_CACHECLICKED, OnCacheClicked)
	ON_MESSAGE(WM_USER_CACHEIMAGECLICKED, OnCacheImageClicked)
	ON_MESSAGE(WM_USER_CANCEL, OnCancel)
	ON_MESSAGE(WM_USER_OPENBOOKMARK, OnOpenBookmark)
	ON_MESSAGE(WM_USER_OPENFIND2CH, OnOpenFind2ch)
	ON_MESSAGE(WM_USER_OPENCACHE, OnOpenCache)
	ON_MESSAGE(WM_USER_ADDBOOKMARK, OnAddBookmark)
	ON_MESSAGE(WM_USER_CUSTOM, OnCustomMessage)
	ON_MESSAGE(WM_USER_SHOWSTATUSBAR, OnShowStatusBar)
	ON_MESSAGE(WM_USER_SHOWSEARCHBAR, OnShowSearchBar)
	ON_MESSAGE(WM_USER_SHOWFIND2CHBAR, OnShowFind2chBar)
	ON_MESSAGE(WM_USER_EXECSEARCH, OnExecSearch)
	ON_MESSAGE(WM_USER_EXECFIND2CH, OnExecFind2ch)
	ON_MESSAGE(WM_USER_POPUPMENU, OnPopupMenu)
	ON_MESSAGE(WM_USER_UPDATEBOOKMARK, OnUpdateBookmark)
	ON_MESSAGE(WM_USER_NEXTARTICLE, OnNextArticle)
	ON_MESSAGE(WM_USER_SETPROGRESS, OnSetProgress)
	ON_MESSAGE(WM_USER_VIEWBACK, OnViewBack)
	ON_MESSAGE(WM_USER_VIEWFORWARD, OnViewForward)
	ON_MESSAGE(WM_USER_DELETEDATFILE, OnDeleteDatFile)
	ON_MESSAGE(WM_USER_EXECJUMP, OnExecJump)
	ON_MESSAGE(WM_USER_SHOWJUMPBAR, OnShowJumpBar)
	ON_MESSAGE(WM_USER_DELETEIMAGEFILE, OnDeleteImageFile)
	ON_MESSAGE(WM_USER_ADDBOOKMARKBOARD, OnAddBookmarkBoard)
	ON_MESSAGE(WM_USER_GETIMAGE, OnGetImage)
	ON_WM_KEYDOWN()
	ON_COMMAND(ID_CANCEL, &CMainFrame::OnCancel)
	ON_COMMAND(ID_SEARCH, &CMainFrame::OnSearch)
	ON_COMMAND(ID_FIND2CH, &CMainFrame::OnFind2ch)
	ON_COMMAND(ID_EXIT, &CMainFrame::OnExit)
	ON_COMMAND(ID_CONNECT, &CMainFrame::OnConnect)
	ON_COMMAND(ID_DISCONNECT, &CMainFrame::OnDisconnect)
	ON_COMMAND(ID_COPYINFO, &CMainFrame::OnCopyInformation)
	ON_COMMAND(ID_VIEWBACK, &CMainFrame::OnViewBack)
	ON_COMMAND(ID_VIEWFORWARD, &CMainFrame::OnViewForward)
	ON_UPDATE_COMMAND_UI(ID_VIEWBACK, &CMainFrame::OnUpdateViewBack)
	ON_UPDATE_COMMAND_UI(ID_VIEWFORWARD, &CMainFrame::OnUpdateViewForward)
	ON_UPDATE_COMMAND_UI(ID_CANCEL, &CMainFrame::OnUpdateCancel)
	ON_COMMAND(ID_JUMP, &CMainFrame::OnJump)
END_MESSAGE_MAP()


// CMainFrame RXgNV/fXgNV

CMainFrame::CMainFrame()
{
	// TODO: oR[hɒǉĂB
	m_bo_canceled = FALSE;
	m_dw_threadid = ::GetCurrentThreadId();
}

CMainFrame::~CMainFrame()
{
}

int CMainFrame::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1)
		return -1;

	// Xe[^Xo[ǂ
	m_cStatus.Create(IDD_DIALOG_STATUS, this);
	m_cSearch.Create(IDD_DIALOG_SEARCH, this);
	m_cFind2ch.Create(IDD_DIALOG_FIND2CH, this);
	m_cJump.Create(IDD_DIALOG_JUMP, this);
	ShowStatusBar(FALSE);
	ShowSearchBar(FALSE);
	ShowFind2chBar(FALSE);
	ShowJumpBar(FALSE);

#if defined(WIN32_PLATFORM_PSPC) || defined(WIN32_PLATFORM_WFSP)
	if (!m_wndCommandBar.Create(this) ||
	    !m_wndCommandBar.InsertMenuBar(IDR_MAINFRAME) ||
	    !m_wndCommandBar.AddAdornments(dwAdornmentFlags)/* ||
	    !m_wndCommandBar.LoadToolBar(IDR_MAINFRAME)*/)
	{
		TRACE0("CommandBar ̍쐬Ɏs܂\n");
		return -1;      // 쐬ł܂łB
	}

	m_wndCommandBar.SetBarStyle(m_wndCommandBar.GetBarStyle() | CBRS_SIZE_FIXED);

	// WM6 Stdp
	{
		CWnd* pWnd = CWnd::FromHandlePermanent(m_wndCommandBar.m_hWnd);
		RECT rect, rectDesktop;
		pWnd->GetWindowRect(&rect);
		pWnd->GetDesktopWindow()->GetWindowRect(&rectDesktop);

		int cx = rectDesktop.right - rectDesktop.left;
		int cy = (rectDesktop.bottom - rectDesktop.top) - (rect.bottom - rect.top);
		this->SetWindowPos(NULL, 0, 0, cx, cy, SWP_NOMOVE | SWP_NOZORDER);
	}
#endif // WIN32_PLATFORM_PSPC

	// NMODE_BOARD
	AddHistory(MODE_BOARD);

	return 0;
}

BOOL CMainFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if (!CFrameWnd::PreCreateWindow(cs))
		return FALSE;
	// TODO: ̈ʒu CREATESTRUCT cs C Window NX܂̓X^C
	//  CĂB
	// EBhENX̕ύX
	{
		WNDCLASS wc = {0};
		wc.hIcon = AfxGetApp()->LoadIcon(AFX_IDI_STD_FRAME);
		wc.hCursor = AfxGetApp()->LoadStandardCursor(MAKEINTRESOURCE(IDC_ARROW));
		wc.style = CS_DBLCLKS|CS_HREDRAW|CS_VREDRAW;
		wc.lpszClassName = _T(APP_NAME);
		wc.lpfnWndProc = AfxWndProc;

		// EBhENXo^
		AfxRegisterClass(&wc);
		cs.lpszClass = _T(APP_NAME);
	}

#if defined(WIN32_PLATFORM_PSPC) || defined(WIN32_PLATFORM_WFSP)
	cs.style &= ~FWS_ADDTOTITLE;
	cs.style &= ~FWS_PREFIXTITLE;
#else
	cs.cx = 320;
	cs.cy = 240;
	cs.cx = 480;
	cs.cy = 640;
#endif
	return TRUE;
}

// CMainFrame ff

#ifdef _DEBUG
void CMainFrame::AssertValid() const
{
	CFrameWnd::AssertValid();
}
#endif //_DEBUG

#define BAR_HEIGHT	(46)
// CMainFrame bZ[W nh
void CMainFrame::OnSize(UINT nType, int cx, int cy)
{
	CFrameWnd::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B
	CView *pView = GetActiveView();
	if (m_cStatus.m_hWnd != NULL && m_cStatus.IsWindowVisible() == TRUE) {
		m_cStatus.MoveWindow(0, cy - BAR_HEIGHT, cx, BAR_HEIGHT);
		if (pView != NULL) {
			pView->MoveWindow(0, 0, cx, cy - BAR_HEIGHT);
		}
	} else if (m_cSearch.m_hWnd != NULL && m_cSearch.IsWindowVisible() == TRUE) {
		m_cSearch.MoveWindow(0, cy - BAR_HEIGHT, cx, BAR_HEIGHT);
		if (pView != NULL) {
			pView->MoveWindow(0, 0, cx, cy - BAR_HEIGHT);
		}
	} else if (m_cFind2ch.m_hWnd != NULL && m_cFind2ch.IsWindowVisible() == TRUE) {
		m_cFind2ch.MoveWindow(0, cy - BAR_HEIGHT, cx, BAR_HEIGHT);
		if (pView != NULL) {
			pView->MoveWindow(0, 0, cx, cy - BAR_HEIGHT);
		}
	} else if (m_cJump.m_hWnd != NULL && m_cJump.IsWindowVisible() == TRUE) {
		m_cJump.MoveWindow(0, cy - BAR_HEIGHT, cx, BAR_HEIGHT);
		if (pView != NULL) {
			pView->MoveWindow(0, 0, cx, cy - BAR_HEIGHT);
		}
	} else {
		if (pView != NULL) {
			pView->MoveWindow(0, 0, cx, cy + 2);
		}
	}
}

BOOL CMainFrame::CallbackCanceledProc(
	void *vop_user)
{
	return ((CMainFrame*)vop_user)->Canceled();
}

void CMainFrame::SetCancel(
	BOOL bo_cancel)
{
	if (bo_cancel == TRUE &&
		(
			((Cq2chwmApp*)AfxGetApp())->GetImageView()->IsRunning() == TRUE ||
			((Cq2chwmApp*)AfxGetApp())->GetBoardView()->IsRunning() == TRUE ||
			((Cq2chwmApp*)AfxGetApp())->GetSubjectView()->IsRunning() == TRUE ||
			((Cq2chwmApp*)AfxGetApp())->GetDatView()->IsRunning() == TRUE ||
			((Cq2chwmApp*)AfxGetApp())->GetBookmarkView()->IsRunning() == TRUE
		))
	{
		::WSACleanup();
		CYoWinSock::InitSocket(2, 2);
	}
	m_bo_canceled = bo_cancel;
}

BOOL CMainFrame::CallbackProc(
	CYoSocketMessage &cMsg,
	void *vop_user)
{
	CMainFrame *pMainWnd = (CMainFrame*)vop_user;
	if (pMainWnd->Canceled() == TRUE) {
		cMsg.SetCancel(TRUE);
	} else {
		if (cMsg.GetMessage() == CYoSocketMessage::CONNECT_BEFORE) {
			// ڑ
			static CYoMutex cMutex;
			cMutex.Lock();
			if (pMainWnd->Canceled() == TRUE) {
				cMsg.SetCancel(TRUE);
			} else {
				int in_index = -1;
				if (Cq2chwmConfig::GetInstance()->GetWriteChange() == TRUE && Cq2chwmMessageDialog::GetRunning() == TRUE) {
					// ݒ
					in_index = Cq2chwmConfig::GetInstance()->GetWriteConnection();
				} else {
					in_index = Cq2chwmConfig::GetInstance()->GetConnection();
				}
				if (pMainWnd->m_cConnectionManager.IsConnected(in_index) == FALSE) {
					// ڑȂ̂Őڑ
					pMainWnd->m_cConnectionManager.Disconnect();
					if (pMainWnd->Canceled() == TRUE || pMainWnd->m_cConnectionManager.Connect(in_index, CMainFrame::CallbackCanceledProc, pMainWnd) == FALSE) {
						cMsg.SetCancel(TRUE);
					}
				}
			}
			cMutex.Unlock();
		}

		if (pMainWnd->Canceled() == TRUE) {
			cMsg.SetCancel(TRUE);
		}

		if (pMainWnd->m_dw_threadid == ::GetCurrentThreadId()) {
			MessageLoop();
		}

		if (pMainWnd->Canceled() == TRUE) {
			cMsg.SetCancel(TRUE);
		}
	}

	return TRUE;
}

void CMainFrame::ShowStatusBar(
	BOOL bo_flg)
{
	if (bo_flg == TRUE) {
		// ɕ\Ăꍇ͉Ȃ
		if (m_cStatus.m_hWnd != NULL && m_cStatus.IsWindowVisible() == TRUE) return;
	} else {
		// ɕ\ĂȂꍇ͉Ȃ
		if (m_cStatus.m_hWnd != NULL && m_cStatus.IsWindowVisible() == FALSE) return;
	}
	m_cStatus.SetMessage("");
	m_cStatus.SetProgress(0, 0);
	m_cStatus.ShowWindow(bo_flg == TRUE ? SW_SHOW : SW_HIDE);
	RECT r;
	GetClientRect(&r);
	OnSize(SIZE_RESTORED, r.right - r.left, r.bottom - r.top);
	if (bo_flg == TRUE) SetCancel(FALSE);
}

void CMainFrame::ShowFind2chBar(
	BOOL bo_flg)
{
	m_cFind2ch.ShowWindow(bo_flg == TRUE ? SW_SHOW : SW_HIDE);
	if (bo_flg == TRUE) {
		m_cFind2ch.SetFocus();
	} else if (GetActiveView() != NULL) {
		GetActiveView()->SetFocus();
	}
	RECT r;
	GetClientRect(&r);
	OnSize(SIZE_RESTORED, r.right - r.left, r.bottom - r.top);
}

void CMainFrame::ShowSearchBar(
	BOOL bo_flg)
{
	switch (CURRENTMODE) {
	case MODE_SUBJECT:
	case MODE_BOOKMARK:
	case MODE_CACHE:
		m_cSearch.SetUpDownButton(FALSE);
		break;
	default:
		m_cSearch.SetUpDownButton(TRUE);
	}

	m_cSearch.ShowWindow(bo_flg == TRUE ? SW_SHOW : SW_HIDE);
	if (bo_flg == TRUE) {
		m_cSearch.SetFocus();
	} else if (GetActiveView() != NULL) {
		GetActiveView()->SetFocus();
	}
	RECT r;
	GetClientRect(&r);
	OnSize(SIZE_RESTORED, r.right - r.left, r.bottom - r.top);
}

void CMainFrame::ShowJumpBar(
	BOOL bo_flg)
{
	m_cJump.ShowWindow(bo_flg == TRUE ? SW_SHOW : SW_HIDE);
	if (bo_flg == TRUE) {
		m_cJump.SetFocus();
	} else if (GetActiveView() != NULL) {
		GetActiveView()->SetFocus();
	}
	RECT r;
	GetClientRect(&r);
	OnSize(SIZE_RESTORED, r.right - r.left, r.bottom - r.top);
}

long CMainFrame::OnSetProgress(
	WPARAM wParam,
	LPARAM lParam)
{
	if (m_cStatus.m_hWnd != NULL && m_cStatus.IsWindowVisible() == FALSE) {
		ShowStatusBar(TRUE);
	}
	SetProgress(NULL, wParam, lParam);
	return 0;
}

void CMainFrame::SetProgress(
	const char *chp_message,
	int in_recv,
	int in_recv_all)
{
	if (chp_message == NULL || *chp_message == 0x00) {
		CYoString str_message;
		str_message.Format("%d/%d", in_recv, in_recv_all);
		m_cStatus.SetMessage(str_message);
		TRACE(_T("%s\n"), W(str_message));
	} else {
		m_cStatus.SetMessage(chp_message);
	}
	m_cStatus.SetProgress(in_recv, in_recv_all);
}

long CMainFrame::OnBoardClicked(
	WPARAM wParam,
	LPARAM lParam)
{
	AddHistory(MODE_SUBJECT);
	((Cq2chwmApp*)AfxGetApp())->GetSubjectView()->ResetSearchState();
	// `񐔂炷߂ɃJEgZbg
	((Cq2chwmApp*)AfxGetApp())->GetSubjectView()->GetListCtrl().SetItemCountEx(0);
	((Cq2chwmApp*)AfxGetApp())->ShowSubjectView();
	Cq2chwmBoardItem *pItem = (Cq2chwmBoardItem*)lParam;
	((Cq2chwmApp*)AfxGetApp())->GetSubjectView()->CreateFromFile(pItem->GetBoardName(), pItem->GetBoardUrl(), pItem->GetBoardId());
	return 0;
}

long CMainFrame::OnSubjectClicked(
	WPARAM wParam,
	LPARAM lParam)
{
	AddHistory(MODE_DAT);
	((Cq2chwmApp*)AfxGetApp())->ShowDatView();
	Cq2chwmListItem *pItem = (Cq2chwmListItem*)lParam;
	((Cq2chwmApp*)AfxGetApp())->GetDatView()->CreateFromFile(pItem->GetArticleName(), pItem->GetArticleId(),
		pItem->GetBoardName(), pItem->GetBoardUrl(), pItem->GetBoardId());
	return 0;
}

long CMainFrame::OnBookmarkClicked(
	WPARAM wParam,
	LPARAM lParam)
{
	AddHistory(MODE_DAT);
	((Cq2chwmApp*)AfxGetApp())->ShowDatView();
	Cq2chwmBookmarkItem *pItem = (Cq2chwmBookmarkItem*)lParam;
	((Cq2chwmApp*)AfxGetApp())->GetDatView()->CreateFromFile(pItem->GetArticleName(), pItem->GetArticleId(),
		pItem->GetBoardName(), pItem->GetBoardUrl(), pItem->GetBoardId());
	return 0;
}

long CMainFrame::OnCacheClicked(
	WPARAM wParam,
	LPARAM lParam)
{
	AddHistory(MODE_DAT);
	((Cq2chwmApp*)AfxGetApp())->ShowDatView();
	Cq2chwmCacheItem *pItem = (Cq2chwmCacheItem*)lParam;
	((Cq2chwmApp*)AfxGetApp())->GetDatView()->CreateFromFile(pItem->GetArticleName(), pItem->GetArticleId(),
		pItem->GetBoardName(), pItem->GetBoardUrl(), pItem->GetBoardId());
	return 0;
}

long CMainFrame::OnCacheImageClicked(
	WPARAM wParam,
	LPARAM lParam)
{
	Cq2chwmCacheImageItem *pItem = (Cq2chwmCacheImageItem*)lParam;
	CYoString str_url = pItem->GetUrl();
	OnOpenUrl(0, (LPARAM)(const char*)str_url);
	return 0;
}

long CMainFrame::OnNextArticle(
	WPARAM wParam,
	LPARAM lParam)
{
	if ((int)m_cModeArray.Get(m_cModeArray.Count() - 2) == MODE_BOOKMARK) {
		// ̐VubN}[NJ
		Cq2chwmBookmarkItem *pItem = ((Cq2chwmApp*)AfxGetApp())->GetBookmarkView()->GetNextItem((const char*)lParam);
		if (pItem != NULL) {
			if (::MessageBox(m_hWnd, _T("̐VubN}[NJ܂H"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_YESNO|MB_ICONQUESTION) == IDYES) {
				OnBookmarkClicked(0, (LPARAM)pItem);
			}
		}
	}
	return 0;
}

long CMainFrame::OnViewBack(
	WPARAM wParam,
	LPARAM lParam)
{
	// ʑJ
	if (m_cModeArray.Count() > 1) {
		m_cModeForwardArray.Add(CURRENTMODE);
		m_cModeArray.Remove(m_cModeArray.Count() - 1);
		switch (CURRENTMODE) {
			case MODE_BOARD:
				((Cq2chwmApp*)AfxGetApp())->ShowBoardView();
				break;
			case MODE_SUBJECT:
				((Cq2chwmApp*)AfxGetApp())->ShowSubjectView();
				break;
			case MODE_DAT:
				((Cq2chwmApp*)AfxGetApp())->ShowDatView();
				((Cq2chwmApp*)AfxGetApp())->GetDatView()->SetWindowText();
				break;
			case MODE_BOOKMARK:
				((Cq2chwmApp*)AfxGetApp())->ShowBookmarkView();
				break;
			case MODE_CACHE:
				((Cq2chwmApp*)AfxGetApp())->ShowCacheView();
				break;
		};
	}

	return 0;
}

long CMainFrame::OnViewForward(
	WPARAM wParam,
	LPARAM lParam)
{
	// ʑJ
	if (m_cModeForwardArray.Count() > 0) {
		switch ((int)m_cModeForwardArray.Get(m_cModeForwardArray.Count() - 1)) {
			case MODE_BOARD:
				m_cModeArray.Add(MODE_BOARD);
				((Cq2chwmApp*)AfxGetApp())->ShowBoardView();
				break;
			case MODE_SUBJECT:
				m_cModeArray.Add(MODE_SUBJECT);
				((Cq2chwmApp*)AfxGetApp())->ShowSubjectView();
				break;
			case MODE_DAT:
				m_cModeArray.Add(MODE_DAT);
				((Cq2chwmApp*)AfxGetApp())->ShowDatView();
				((Cq2chwmApp*)AfxGetApp())->GetDatView()->SetWindowText();
				break;
			case MODE_BOOKMARK:
				m_cModeArray.Add(MODE_BOOKMARK);
				((Cq2chwmApp*)AfxGetApp())->ShowBookmarkView();
				break;
			case MODE_CACHE:
				m_cModeArray.Add(MODE_CACHE);
				((Cq2chwmApp*)AfxGetApp())->ShowCacheView();
				break;
		};
		m_cModeForwardArray.Remove(m_cModeForwardArray.Count() - 1);
	}

	return 0;
}

long CMainFrame::OnCancel(
	WPARAM wParam,
	LPARAM lParam)
{
	// LZ`FbN
	if (((Cq2chwmApp*)AfxGetApp())->GetImageView()->IsRunning() == TRUE) {
		if (::MessageBox(m_hWnd, _T("LZ܂H"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_YESNO|MB_ICONQUESTION) == IDYES) {
			SetCancel(TRUE);
		}
	} else {
		switch (CURRENTMODE) {
			case MODE_BOARD:
				if (((Cq2chwmApp*)AfxGetApp())->GetBoardView()->IsRunning() == FALSE) {
					break;
				} else if (::MessageBox(m_hWnd, _T("LZ܂H"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_YESNO|MB_ICONQUESTION) == IDYES) {
					SetCancel(TRUE);
				}
				break;
			case MODE_SUBJECT:
				if (((Cq2chwmApp*)AfxGetApp())->GetSubjectView()->IsRunning() == FALSE) {
					break;
				} else if (::MessageBox(m_hWnd, _T("LZ܂H"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_YESNO|MB_ICONQUESTION) == IDYES) {
					SetCancel(TRUE);
				}
				break;
			case MODE_DAT:
				if (((Cq2chwmApp*)AfxGetApp())->GetDatView()->IsRunning() == FALSE) {
					break;
				} else if (::MessageBox(m_hWnd, _T("LZ܂H"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_YESNO|MB_ICONQUESTION) == IDYES) {
					SetCancel(TRUE);
				}
				break;
			case MODE_BOOKMARK:
				if (((Cq2chwmApp*)AfxGetApp())->GetBookmarkView()->IsRunning() == FALSE) {
					break;
				} else if (::MessageBox(m_hWnd, _T("LZ܂H"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_YESNO|MB_ICONQUESTION) == IDYES) {
					SetCancel(TRUE);
				}
				break;
		};
	}

	return 0;
}

long CMainFrame::OnOpenBookmark(
	WPARAM wParam,
	LPARAM lParam)
{
	((Cq2chwmApp*)AfxGetApp())->GetBookmarkView()->ResetSearchState();
	((Cq2chwmApp*)AfxGetApp())->GetBookmarkBoardView()->ResetSearchState();
	((Cq2chwmApp*)AfxGetApp())->ShowBookmarkView();
	((Cq2chwmApp*)AfxGetApp())->GetBookmarkView()->CreateFromFile();
	AddHistory(MODE_BOOKMARK);
	return 0;
}

long CMainFrame::OnOpenFind2ch(
	WPARAM wParam,
	LPARAM lParam)
{
	((Cq2chwmApp*)AfxGetApp())->ShowSubjectView();
	AddHistory(MODE_SUBJECT);
	((Cq2chwmApp*)AfxGetApp())->GetSubjectView()->CreateFromFile("Q˂錟", "http://.tmp/find.2ch.net/", "find.2ch.net");
	return 0;
}

long CMainFrame::OnOpenCache(
	WPARAM wParam,
	LPARAM lParam)
{
	((Cq2chwmApp*)AfxGetApp())->GetCacheView()->ResetSearchState();
	((Cq2chwmApp*)AfxGetApp())->GetCacheImageView()->ResetSearchState();
	((Cq2chwmApp*)AfxGetApp())->ShowCacheView();
	AddHistory(MODE_CACHE);
	// LbVCq2chwmApp::ShowCacheViewō쐬
	//((Cq2chwmApp*)AfxGetApp())->GetCacheView()->CreateList();
	return 0;
}

long CMainFrame::OnAddBookmark(
	WPARAM wParam,
	LPARAM lParam)
{
	Cq2chwmBookmarkItem *pItem = (Cq2chwmBookmarkItem*)lParam;
	((Cq2chwmApp*)AfxGetApp())->GetBookmarkView()->AddBookmark(pItem->GetArticleName(), pItem->GetArticleId(),
		pItem->GetBoardName(), pItem->GetBoardId(), pItem->GetBoardUrl());
	return 0;
}

long CMainFrame::OnAddBookmarkBoard(
	WPARAM wParam,
	LPARAM lParam)
{
	Cq2chwmBoardItem *pItem = (Cq2chwmBoardItem*)lParam;
	((Cq2chwmApp*)AfxGetApp())->GetBookmarkBoardView()->AddItem(pItem->GetBoardName(), pItem->GetBoardId(), pItem->GetBoardUrl());
	return 0;
}

long CMainFrame::OnGetImage(
	WPARAM wParam,
	LPARAM lParam)
{
	Cq2chwmGetImageInfo *pInfo = (Cq2chwmGetImageInfo*)lParam;
	int in_ret = pInfo->GetCode();
	const char *chp_url = pInfo->GetOriginalUrl();
	const char *chp_message = pInfo->GetMessage();
	if (*chp_message != 0x00) {
		// G[bZ[WZbgA摜r[\
		((Cq2chwmApp*)AfxGetApp())->GetImageView()->SetErrorMessage(chp_message);
		((Cq2chwmApp*)AfxGetApp())->OnViewImage();
	} else if (in_ret != ERR_NONE) {
		// G[bZ[W{bNX\
		ErrorMessageBox(in_ret);
		return 0;
	}

	// 摜LbVr[ɒǉ
	CYoString str_filename = UrlToImagePath(chp_url);
	((Cq2chwmApp*)AfxGetApp())->GetCacheImageView()->AddItem(str_filename);

	if (Cq2chwmConfig::GetInstance()->GetViewAfterDownload() == FALSE) {
		// 摜_E[hA摜r[\Ȃ
		((Cq2chwmApp*)AfxGetApp())->GetDatView()->InvalidateRect(NULL, FALSE);
	} else if (CURRENTMODE == MODE_DAT) {
		if (((Cq2chwmApp*)AfxGetApp())->GetImageView()->CreateImage(chp_url) == TRUE) {
			((Cq2chwmApp*)AfxGetApp())->OnViewImage();
		}
	}
	return 0;
}

void CMainFrame::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	TRACE(_T("CMainFrame::OnKeyDown\n"));
	CFrameWnd::OnKeyDown(nChar, nRepCnt, nFlags);
}

long CMainFrame::OnCustomMessage(
	WPARAM wParam,
	LPARAM lParam)
{
	((Cq2chwmApp*)AfxGetApp())->GetDatView()->OnCustomMessage(wParam, lParam);
	((Cq2chwmApp*)AfxGetApp())->GetBookmarkView()->OnCustomMessage(wParam, lParam);
	((Cq2chwmApp*)AfxGetApp())->GetCacheView()->OnCustomMessage(wParam, lParam);
	Cq2chwmMessage *pMessage= (Cq2chwmMessage*)lParam;
	delete pMessage;
	return 0;
}

void CMainFrame::OnCancel()
{
	// TODO: ɃR}h nh R[hǉ܂B
	OnCancel(0, 0);
}

void CMainFrame::OnViewBack()
{
	// TODO: ɃR}h nh R[hǉ܂B
	OnViewBack(0, 0);
}

void CMainFrame::OnViewForward()
{
	// TODO: ɃR}h nh R[hǉ܂B
	OnViewForward(0, 0);
}

long CMainFrame::OnShowStatusBar(
	WPARAM wParam,
	LPARAM lParam)
{
	ShowStatusBar((BOOL)lParam);
	return 0;
}

long CMainFrame::OnShowSearchBar(
	WPARAM wParam,
	LPARAM lParam)
{
	ShowSearchBar((BOOL)lParam);
	return 0;
}

long CMainFrame::OnShowFind2chBar(
	WPARAM wParam,
	LPARAM lParam)
{
	ShowFind2chBar((BOOL)lParam);
	return 0;
}

long CMainFrame::OnShowJumpBar(
	WPARAM wParam,
	LPARAM lParam)
{
	ShowJumpBar((BOOL)lParam);
	return 0;
}

long CMainFrame::OnExecFind2ch(
	WPARAM wParam,
	LPARAM lParam)
{
	CYoString str_url = (const char*)wParam;
	CYoString str_word = (const char*)lParam;
	Cq2chwmConfig::GetInstance()->AddHistorySearchWord(str_word);
	m_cSearch.ReloadHistory();
	m_cFind2ch.ReloadHistory();

	// Board[h
	AddHistory(MODE_SUBJECT);
	((Cq2chwmApp*)AfxGetApp())->ShowSubjectView();
	ShowFind2chBar(FALSE);
	ShowStatusBar(TRUE);
	((Cq2chwmApp*)AfxGetApp())->GetSubjectView()->CreateFromFindUrl(str_url);
	ShowStatusBar(FALSE);

	return 0;
}

long CMainFrame::OnPopupMenu(
	WPARAM wParam,
	LPARAM lParam)
{
	RECT rect;
	GetWindowRect(&rect);
	CMenu cMenu;
	cMenu.LoadMenuW(IDR_MAINFRAME);
	ReplaceMenu(&cMenu,Cq2chwmConfig::GetInstance()->GetMenuNumber());
	cMenu.GetSubMenu(0)->TrackPopupMenu(TPM_LEFTALIGN, rect.left, rect.top, this);
//	GetMenu()->GetSubMenu(0)->TrackPopupMenu(TPM_LEFTALIGN, rect.left, rect.top, this);
	return 0;
}

long CMainFrame::OnUpdateBookmark(
	WPARAM wParam,
	LPARAM lParam)
{
	((Cq2chwmApp*)AfxGetApp())->GetBookmarkView()->UpdateItem((const char*)lParam);
	return 0;
}

long CMainFrame::OnExecSearch(
	WPARAM wParam,
	LPARAM lParam)
{
	CYoString str_word = (const char*)lParam;
	Cq2chwmConfig::GetInstance()->AddHistorySearchWord(str_word);
	m_cSearch.ReloadHistory();
	m_cFind2ch.ReloadHistory();

	// ݃ANeBuȃr[Ɍ
	switch (CURRENTMODE) {
		case MODE_BOARD:
			if (wParam == FALSE) {
				((Cq2chwmApp*)AfxGetApp())->GetBoardView()->SearchNext(str_word);
			} else {
				((Cq2chwmApp*)AfxGetApp())->GetBoardView()->SearchPrev(str_word);
			}
			m_cSearch.SetFocus();
			break;
		case MODE_SUBJECT:
			((Cq2chwmApp*)AfxGetApp())->GetSubjectView()->Search(str_word);
			ShowSearchBar(FALSE);
			((Cq2chwmApp*)AfxGetApp())->GetSubjectView()->SetFocus();
			break;
		case MODE_DAT:
			if (wParam == FALSE) {
				((Cq2chwmApp*)AfxGetApp())->GetDatView()->SearchNext(str_word);
			} else {
				((Cq2chwmApp*)AfxGetApp())->GetDatView()->SearchPrev(str_word);
			}
			m_cSearch.SetFocus();
			break;
		case MODE_BOOKMARK:
			if (((Cq2chwmApp*)AfxGetApp())->GetBookmarkTabView()->GetCurrentSel() == 0) {
				// ubN}[Nr[Ō
				((Cq2chwmApp*)AfxGetApp())->GetBookmarkView()->Search(str_word);
				((Cq2chwmApp*)AfxGetApp())->GetBookmarkView()->SetFocus();
			} else {
				// ubN}[Nr[Ō
				((Cq2chwmApp*)AfxGetApp())->GetBookmarkBoardView()->Search(str_word);
				((Cq2chwmApp*)AfxGetApp())->GetBookmarkBoardView()->SetFocus();
			}
			ShowSearchBar(FALSE);
			break;
		case MODE_CACHE:
			if (((Cq2chwmApp*)AfxGetApp())->GetCacheTabView()->GetCurrentSel() == 0) {
				// LbVr[Ō
				((Cq2chwmApp*)AfxGetApp())->GetCacheView()->Search(str_word);
				((Cq2chwmApp*)AfxGetApp())->GetCacheView()->SetFocus();
			} else {
				// 摜LbVr[Ō
				((Cq2chwmApp*)AfxGetApp())->GetCacheImageView()->Search(str_word);
				((Cq2chwmApp*)AfxGetApp())->GetCacheImageView()->SetFocus();
			}
			ShowSearchBar(FALSE);
			break;
	};
	return 0;
}

void CMainFrame::OnSearch()
{
	// TODO: ɃR}h nh R[hǉ܂B
	ShowJumpBar(FALSE);
	ShowFind2chBar(FALSE);
	ShowSearchBar(TRUE);
}

void CMainFrame::OnFind2ch()
{
	// TODO: ɃR}h nh R[hǉ܂B
	ShowJumpBar(FALSE);
	ShowSearchBar(FALSE);
	ShowFind2chBar(TRUE);
}

void CMainFrame::OnExit()
{
	// TODO: ɃR}h nh R[hǉ܂B
	PostMessage(WM_CLOSE);
}

void CMainFrame::OnConnect()
{
	// TODO: ɃR}h nh R[hǉ܂B
	if (m_cConnectionManager.IsConnected(Cq2chwmConfig::GetInstance()->GetConnection()) == FALSE) {
		m_cConnectionManager.Connect(Cq2chwmConfig::GetInstance()->GetConnection(), CMainFrame::CallbackCanceledProc, this);
	}
}

void CMainFrame::OnDisconnect()
{
	// TODO: ɃR}h nh R[hǉ܂B
	if (m_cConnectionManager.IsConnected(Cq2chwmConfig::GetInstance()->GetConnection()) == TRUE) {
		m_cConnectionManager.Disconnect();
	}
}

void CMainFrame::OnCopyInformation()
{
	// ݃ANeBuȃr[ɔC
	switch (CURRENTMODE) {
		case MODE_BOARD:
			((Cq2chwmApp*)AfxGetApp())->GetBoardView()->CopyInformation();
			break;
		case MODE_SUBJECT:
			((Cq2chwmApp*)AfxGetApp())->GetSubjectView()->CopyInformation();
			break;
		case MODE_DAT:
			((Cq2chwmApp*)AfxGetApp())->GetDatView()->CopyInformation();
			break;
		case MODE_BOOKMARK:
			if (((Cq2chwmApp*)AfxGetApp())->GetBookmarkTabView()->GetCurrentSel() == 0) {
				((Cq2chwmApp*)AfxGetApp())->GetBookmarkView()->CopyInformation();
			} else {
				((Cq2chwmApp*)AfxGetApp())->GetBookmarkBoardView()->CopyInformation();
			}
			break;
		case MODE_CACHE:
			if (((Cq2chwmApp*)AfxGetApp())->GetCacheTabView()->GetCurrentSel() == 0) {
				((Cq2chwmApp*)AfxGetApp())->GetCacheView()->CopyInformation();
			} else {
				((Cq2chwmApp*)AfxGetApp())->GetCacheImageView()->CopyInformation();
			}
			break;
	};
}

void CMainFrame::AddHistory(
	MODE mode)
{
	if (m_cModeArray.Count() == 0 || CURRENTMODE != (int)mode) {
		for (int i = 0; i < m_cModeArray.Count(); i++) {
			if ((int)m_cModeArray.Get(i) == (int)mode) {
				m_cModeArray.Remove(i);
				break;
			}
		}
		m_cModeArray.Add((int)mode);
	}
	m_cModeForwardArray.RemoveAll();
}

BOOL CMainFrame::PreTranslateMessage(MSG* pMsg)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	if (pMsg->message == WM_KEYDOWN) {
		// r[ɈˑȂL[oCh
		TRACE(_T("CMainFrame::PreTranslateMessage: WM_KEYDOWN(%d)\n"), pMsg->wParam);
		if (Cq2chwmConfig::GetInstance()->IsKeyFind2ch(pMsg->wParam)) {
			SendMessage(WM_COMMAND, ID_FIND2CH, 0);
			return TRUE;
		} else if (Cq2chwmConfig::GetInstance()->IsKeyMenu(pMsg->wParam)) {
			SendMessage(WM_USER_POPUPMENU);
			return TRUE;
		} else if (Cq2chwmConfig::GetInstance()->IsKeySearch(pMsg->wParam)) {
			SendMessage(WM_USER_SHOWSEARCHBAR, 0, (LPARAM)TRUE);
			return TRUE;
		} else if (Cq2chwmConfig::GetInstance()->IsKeyOnline(pMsg->wParam)) {
			Cq2chwmConfig::GetInstance()->SetOnline(!Cq2chwmConfig::GetInstance()->GetOnline());
			return TRUE;
		} else if (Cq2chwmConfig::GetInstance()->IsKeyOpenBookmark(pMsg->wParam)) {
			SendMessage(WM_USER_OPENBOOKMARK, 0, 0);
			return TRUE;
		} else if (Cq2chwmConfig::GetInstance()->IsKeyJump(pMsg->wParam)) {
			SendMessage(WM_USER_SHOWJUMPBAR, 0, (LPARAM)TRUE);
			return TRUE;
		}
	}
	return CFrameWnd::PreTranslateMessage(pMsg);
}

void CMainFrame::OpenBrowser(
	const wchar_t *lpszUrl)
{
	CYoString str_url = A(lpszUrl);
	str_url = GetCompleteUrl(str_url);
	CString cstr_url;
	cstr_url = str_url;
	CString cstr_image;
	cstr_image = Cq2chwmConfig::GetInstance()->GetBrowser();
	if (Execute(cstr_image, cstr_url) == FALSE) {
		::MessageBox(m_hWnd, _T("uEŰNɎs܂"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_OK|MB_ICONSTOP);
	}
}

BOOL CMainFrame::Execute(
	const wchar_t *lpszImage,
	const wchar_t *lpszArg)
{
	PROCESS_INFORMATION pi;
	CString cstr_image;
	cstr_image = lpszImage;
	BOOL bo_ret;
#if defined(WIN32_PLATFORM_PSPC) || defined(WIN32_PLATFORM_WFSP)
	bo_ret = ::CreateProcess(lpszImage, lpszArg, NULL, NULL, FALSE, 0, NULL, NULL, NULL, &pi);
#else
	STARTUPINFO si;
	ZeroMemory(&si, sizeof(si));
	si.cb = sizeof(si);
	if (*lpszArg != 0x00) cstr_image.AppendFormat(_T(" \"%s\""), lpszArg);
	LPWSTR wchp_image = cstr_image.GetBuffer(cstr_image.GetLength() + 1);
	bo_ret = ::CreateProcess(NULL, wchp_image, NULL, NULL, FALSE, 0, NULL, NULL, &si, &pi);
	cstr_image.ReleaseBuffer();
#endif
	return bo_ret;
}

long CMainFrame::OnOpenUrl(
	WPARAM wParam,		// gp
	LPARAM lParam)		// URL(const char*)
{
	const char *chp_url = (const char*)lParam;
	CYoRegex cRegexSubject("([^./]+\\.(2ch\\.net|bbspink\\.com|jikkyo\\.org)/([^./]+))");
	CYoRegex cRegex("^[[h]*t]*tp://([^./]+\\.[^./]+\\.[^./]+)/test/read\\.cgi/([a-zA-Z0-9]+)/([0-9]+)[/]*([0-9]*)");
	CYoRegex cRegexKako("^[[h]*t]*tp://([^./]+\\.[^./]+\\.[^./]+)/([a-zA-Z0-9]+)/kako/[0-9]+/[0-9]+/([0-9]+)\\.(html|dat.gz)");
	CYoRegex cRegexMachiBbs("^[[h]*t]*tp://([^./]+\\.[^./]+\\.[^./]+)/bbs/read\\.(pl|cgi)\\?BBS=([a-zA-Z0-9]+)&KEY=([0-9]+)");
	CYoRegex cRegexJBbs("^[[h]*t]*tp://([^./]+\\.[^./]+\\.[^./]+/[^./]+)/bbs/read\\.(pl|cgi)\\?BBS=([a-zA-Z0-9]+)&KEY=([0-9]+)");
	CYoRegex cRegexJBbs2("^[[h]*t]*tp://([^./]+\\.[^./]+\\.[^./]+)/bbs/read\\.(pl|cgi)\\/([a-zA-Z0-9]+)/([0-9]+)/([0-9]+)[/]?([0-9]*)");
	CYoRegex cRegexJBbs3("^[[h]*t]*tp://([^./]+\\.[^./]+\\.[^./]+)/test/read\\.(pl|cgi)\\?bbs=([a-zA-Z0-9]+)&key=([0-9]+)");
	CYoRegex cRegexLiveSoccer("^[[h]*t]*tp://([^./]+\\.[^./]+\\.[^./]+)/test/read\\.(pl|cgi)\\?bbs=([a-zA-Z0-9]+)&key=([0-9]+)");
	CYoRegex cRegexLiveSoccerExt1("^[[h]*t]*tp://([^./]+\\.[^./]+\\.[^./]+\\.[^./]+/[^./]+/)test/read\\.(pl|cgi)\\?bbs=([a-zA-Z0-9]+)&key=([0-9]+)");
	CYoRegex cRegexLiveSoccerExt2("^[[h]*t]*tp://([^./]+\\.[^./]+\\.[^./]+\\.[^./]+/[^./]+/)test/read\\.(pl|cgi)/([a-zA-Z0-9]+)/([0-9]+)");
	CYoRegex cRegexYoutube("^[[h]*t]*tp://([!-~]+)\\.youtube\\.com/watch\\?.*v=([^&]+).*$", TRUE);

	// 摜`FbN
	BOOL bo_image = FALSE;
	if (Cq2chwmConfig::GetInstance()->GetUseImageView() == TRUE) {
		HANDLE hFind = Cq2chwmImageViewUrlReplace::GetInstance()->FindOpen();
		if (Cq2chwmImageViewUrlReplace::GetInstance()->Find(hFind, chp_url) >= 0) {
			bo_image = TRUE;
		}
		Cq2chwmImageViewUrlReplace::GetInstance()->FindClose(hFind);
	}

	if (bo_image == TRUE) {
		// 摜
		// http://www.2ch.net/logo.gif̂悤URLlɉ摜ŗD悷
		CYoString str_url = GetCompleteUrl(chp_url);
		CYoString str_filename = UrlToImagePath(str_url);
		if (Cq2chwmCacheImageFile::GetInstance()->ExistsItem(str_filename) == TRUE) {
			((Cq2chwmApp*)AfxGetApp())->GetImageView()->CreateImage(chp_url);
			((Cq2chwmApp*)AfxGetApp())->OnViewImage();
		} else {
			Cq2chwmImageViewUrlReplaceMatch cMatch;
			if (Cq2chwmImageViewUrlReplace::GetInstance()->Match(str_url, cMatch) == -1) {
				::MessageBox(m_hWnd, _T("URL܂"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_OK|MB_ICONSTOP);
				ShowStatusBar(FALSE);
				return FALSE;
			}
			if (((Cq2chwmApp*)AfxGetApp())->GetImageView()->HttpGet(str_url, cMatch.GetUrl(), cMatch.GetReferer(), cMatch.GetCookie()) == FALSE) {
				return FALSE;
			}
			((Cq2chwmApp*)AfxGetApp())->GetDatView()->InvalidateRect(NULL, FALSE);
		}
	} else if (cRegex.Match(chp_url) >= 0) {
		// Q˂
		CYoString str_host = cRegex.Get(1);
		CYoString str_bid = cRegex.Get(2);
		CYoString str_aid = cRegex.Get(3);
		CYoString str_no = cRegex.Get(4);
		CYoString str_burl;
		str_burl.Format("http://%s/%s/", (const char*)str_host, (const char*)str_bid);
		((Cq2chwmApp*)AfxGetApp())->OnViewArticle();
		if (((Cq2chwmApp*)AfxGetApp())->GetDatView()->CreateFromFile("", str_aid, "", str_burl, str_bid, str_no.Atoi()) == FALSE) {
			return FALSE;
		}
	} else if(cRegexKako.Match(chp_url) >= 0) {
		// Q˂(ߋ)
		CYoString str_host = cRegexKako.Get(1);
		CYoString str_bid = cRegexKako.Get(2);
		CYoString str_aid = cRegexKako.Get(3);
		CYoString str_burl;
		str_burl.Format("http://%s/%s/", (const char*)str_host, (const char*)str_bid);
		((Cq2chwmApp*)AfxGetApp())->OnViewArticle();
		if (((Cq2chwmApp*)AfxGetApp())->GetDatView()->CreateFromFile("", str_aid, "", str_burl, str_bid) == FALSE) {
			return FALSE;
		}
	} else if(cRegexMachiBbs.Match(chp_url) >= 0) {
		// ܂BBS
		CYoString str_host = cRegexMachiBbs.Get(1);
		CYoString str_bid = cRegexMachiBbs.Get(3);
		CYoString str_aid = cRegexMachiBbs.Get(4);
		CYoString str_no;
		CYoRegex cRegexStart("START=([0-9]+)");
		if (cRegexStart.Match(chp_url) >= 0) {
			str_no = cRegexStart.Get(1);
		}
		CYoString str_burl;
		str_burl.Format("http://%s/%s/", (const char*)str_host, (const char*)str_bid);
		((Cq2chwmApp*)AfxGetApp())->OnViewArticle();
		if (((Cq2chwmApp*)AfxGetApp())->GetDatView()->CreateFromFile("", str_aid, "", str_burl, str_bid, str_no.Atoi()) == FALSE) {
			return FALSE;
		}
	} else if (cRegexJBbs.Match(chp_url) >= 0) {
		// JBBS
		CYoString str_host = cRegexJBbs.Get(1);
		CYoString str_bid = cRegexJBbs.Get(3);
		CYoString str_aid = cRegexJBbs.Get(4);
		CYoString str_no;
		CYoRegex cRegexStart("START=([0-9]+)");
		if (cRegexStart.Match(chp_url) >= 0) {
			str_no = cRegexStart.Get(1);
		}
		CYoString str_burl;
		str_burl.Format("http://%s/%s/", (const char*)str_host, (const char*)str_bid);
		((Cq2chwmApp*)AfxGetApp())->OnViewArticle();
		if (((Cq2chwmApp*)AfxGetApp())->GetDatView()->CreateFromFile("", str_aid, "", str_burl, str_bid, str_no.Atoi()) == FALSE) {
			return FALSE;
		}
	} else if(cRegexJBbs2.Match(chp_url) >= 0) {
		// JBBS(PATH_INFO)
		CYoString str_host = cRegexJBbs2.Get(1);
		CYoString str_cat = cRegexJBbs2.Get(3); //̃JeS[
		CYoString str_bid = cRegexJBbs2.Get(4);
		CYoString str_aid = cRegexJBbs2.Get(5);
		CYoString str_no = cRegexJBbs2.Get(6);
		str_no = str_no.Atoi();
		CYoString str_burl;
		str_burl.Format("http://%s/%s/%s/", (const char*)str_host, (const char *)str_cat, (const char*)str_bid);
		((Cq2chwmApp*)AfxGetApp())->OnViewArticle();
		if (((Cq2chwmApp*)AfxGetApp())->GetDatView()->CreateFromFile("", str_aid, "", str_burl, str_bid, str_no.Atoi()) == FALSE) {
			return FALSE;
		}
	} else if(cRegexJBbs3.Match(chp_url) >= 0) {
		// JBBS
		CYoString str_host = cRegexJBbs3.Get(1);
		CYoString str_bid = cRegexJBbs3.Get(3);
		CYoString str_aid = cRegexJBbs3.Get(4);
		CYoString str_no;
		CYoRegex cRegexStart("START=([0-9]+)");
		if (cRegexStart.Match(chp_url) >= 0) {
			str_no = cRegexStart.Get(1);
		}
		CYoString str_burl;
		str_burl.Format("http://%s/%s/", (const char*)str_host, (const char*)str_bid);
		((Cq2chwmApp*)AfxGetApp())->OnViewArticle();
		if (((Cq2chwmApp*)AfxGetApp())->GetDatView()->CreateFromFile("", str_aid, "", str_burl, str_bid, str_no.Atoi()) == FALSE) {
			return FALSE;
		}
	} else if (cRegexLiveSoccer.Match( chp_url ) >= 0) {
		// TbJ[
		CYoString str_host = cRegexLiveSoccer.Get(1);
		CYoString str_bid = cRegexLiveSoccer.Get(3);
		CYoString str_aid = cRegexLiveSoccer.Get(4);
		CYoString str_no;
		CYoRegex cRegexStart("START=([0-9]+)");
		if (cRegexStart.Match(chp_url) >= 0) {
			str_no = cRegexStart.Get(1);
		}
		CYoString str_burl;
		str_burl.Format("http://%s/%s/", (const char*)str_host, (const char*)str_bid);
		((Cq2chwmApp*)AfxGetApp())->OnViewArticle();
		if (((Cq2chwmApp*)AfxGetApp())->GetDatView()->CreateFromFile("", str_aid, "", str_burl, str_bid, str_no.Atoi()) == FALSE) {
			return FALSE;
		}
	} else if (cRegexLiveSoccerExt1.Match( chp_url ) >= 0) {
		// TbJ[ URLp^[1
		CYoString str_host = cRegexLiveSoccerExt1.Get(1);
		CYoString str_bid = cRegexLiveSoccerExt1.Get(3);
		CYoString str_aid = cRegexLiveSoccerExt1.Get(4);
		CYoString str_no;
		CYoRegex cRegexStart( "START=([0-9]+)" );
		if( cRegexStart.Match(chp_url) >= 0 ){
			str_no = cRegexStart.Get(1);
		}
		CYoString str_burl;
		str_burl.Format( "http://%s/%s/", (const char*)str_host, (const char*)str_bid );
		((Cq2chwmApp*)AfxGetApp())->OnViewArticle();
		if (((Cq2chwmApp*)AfxGetApp())->GetDatView()->CreateFromFile("", str_aid, "", str_burl, str_bid, str_no.Atoi()) == FALSE) {
			return FALSE;
		}
	} else if (cRegexLiveSoccerExt2.Match( chp_url ) >= 0) {
		// TbJ[ URLp^[2
		CYoString str_host = cRegexLiveSoccerExt2.Get(1);
		CYoString str_bid = cRegexLiveSoccerExt2.Get(3);
		CYoString str_aid = cRegexLiveSoccerExt2.Get(4);
		CYoString str_no;
		CYoRegex cRegexStart("START=([0-9]+)");
		if (cRegexStart.Match(chp_url) >= 0) {
			str_no = cRegexStart.Get(1);
		}
		CYoString str_burl;
		str_burl.Format("http://%s/%s/", (const char*)str_host, (const char*)str_bid);
		((Cq2chwmApp*)AfxGetApp())->OnViewArticle();
		if (((Cq2chwmApp*)AfxGetApp())->GetDatView()->CreateFromFile("", str_aid, "", str_burl, str_bid, str_no.Atoi()) == FALSE) {
			return FALSE;
		}
	} else if (cRegexSubject.Match(chp_url) >= 0) {
		// Subject[h (ex. http://wwwww.2ch.net/news4vip/)
		CYoString str_burl;
		str_burl.Format("http://%s/", cRegexSubject.Get(1));
		CYoString str_bid = cRegexSubject.Get(3);
		CYoString str_bname;
		int in_index = ((Cq2chwmApp*)AfxGetApp())->GetBoardView()->SearchFromId(str_bid);
		if (in_index >= 0) {
			str_bname = ((Cq2chwmApp*)AfxGetApp())->GetBoardView()->GetBoardName(in_index);
		}
		((Cq2chwmApp*)AfxGetApp())->OnViewSubject();
		if (((Cq2chwmApp*)AfxGetApp())->GetSubjectView()->CreateFromFile(str_bname, str_burl, str_bid) == FALSE) {
			return FALSE;
		}
	} else if (Cq2chwmConfig::GetInstance()->GetUseYoutube() == TRUE && cRegexYoutube.Match(chp_url) >= 0) {
		if (strlen(Cq2chwmConfig::GetInstance()->GetYoutubeBrowser()) == 0) {
 			ErrorMessageBox(ERR_CONF_BROWSER);
		}
 		CString cstr_url;
		cstr_url = cRegexYoutube.Get(2);
		cstr_url = _T("youtube://") + cstr_url;
		CString cstr_image;
		cstr_image = Cq2chwmConfig::GetInstance()->GetYoutubeBrowser();
		if (Execute(cstr_image, cstr_url) == FALSE) {
			::MessageBox(m_hWnd, _T("YoutubeuEŰNɎs܂"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_OK|MB_ICONSTOP);
		}
	} else {
		if (strlen(Cq2chwmConfig::GetInstance()->GetBrowser()) == 0) {
			ErrorMessageBox(ERR_CONF_BROWSER);
			return 0;
		}
		CString cstr_url;
		cstr_url = chp_url;
		OpenBrowser(cstr_url);
	}
	return TRUE;
}

void CMainFrame::OnUpdateViewBack(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->Enable(m_cModeArray.Count() > 1);
}

void CMainFrame::OnUpdateViewForward(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->Enable(m_cModeForwardArray.Count() > 0);
}

void CMainFrame::OnUpdateCancel(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	if (((Cq2chwmApp*)AfxGetApp())->GetImageView()->IsRunning() == TRUE) {
		pCmdUI->Enable(TRUE);
	} else {
		switch (CURRENTMODE) {
			case MODE_BOARD:
				pCmdUI->Enable(((Cq2chwmApp*)AfxGetApp())->GetBoardView()->IsRunning());
				break;
			case MODE_SUBJECT:
				pCmdUI->Enable(((Cq2chwmApp*)AfxGetApp())->GetSubjectView()->IsRunning());
				break;
			case MODE_DAT:
				pCmdUI->Enable(((Cq2chwmApp*)AfxGetApp())->GetDatView()->IsRunning());
				break;
			case MODE_BOOKMARK:
				pCmdUI->Enable(((Cq2chwmApp*)AfxGetApp())->GetBookmarkView()->IsRunning());
				break;
			default:
				pCmdUI->Enable(FALSE);
				break;
		};
	}
}

long CMainFrame::OnDeleteDatFile(
	WPARAM wParam,
	LPARAM lParam)
{
	// DATt@C폜ꂽubN}[Nɒm点Ă
	((Cq2chwmApp*)AfxGetApp())->GetBookmarkView()->UpdateItem((const char*)lParam);
	((Cq2chwmApp*)AfxGetApp())->GetCacheView()->UpdateItem((const char*)lParam);
	return 0;
}

long CMainFrame::OnDeleteImageFile(
	WPARAM wParam,
	LPARAM lParam)
{
	// 摜t@C폜ꂽ摜LbVr[ɒm点Ă
	((Cq2chwmApp*)AfxGetApp())->GetCacheImageView()->UpdateItem((const char*)lParam);
	return 0;
}

void CMainFrame::OnJump()
{
	// TODO: ɃR}h nh R[hǉ܂B
	ShowSearchBar(FALSE);
	ShowFind2chBar(FALSE);
	ShowJumpBar(TRUE);
}

long CMainFrame::OnExecJump(
	WPARAM wParam,
	LPARAM lParam)
{
	CYoString str_jump = (const char*)lParam;

	if (str_jump.Find("://") >= 0) {
		// ://܂܂ĂURLƂăXbhJ
		ShowJumpBar(FALSE);
		OnOpenUrl(0, lParam);
		Cq2chwmConfig::GetInstance()->AddHistoryJump(str_jump);
		m_cJump.ReloadHistory();
		return 0;
	} else {
		int in_find = ((Cq2chwmApp*)AfxGetApp())->GetBoardView()->SearchFromId(str_jump);
		if (in_find >= 0) {
			// IDɃ}b`̂ŔJ
			Cq2chwmBoardItem cItem(((Cq2chwmApp*)AfxGetApp())->GetBoardView()->GetBoardName(in_find),
				((Cq2chwmApp*)AfxGetApp())->GetBoardView()->GetBoardUrl(in_find),
				((Cq2chwmApp*)AfxGetApp())->GetBoardView()->GetBoardId(in_find));
			ShowJumpBar(FALSE);
			OnBoardClicked(0, (LPARAM)&cItem);
			Cq2chwmConfig::GetInstance()->AddHistoryJump(str_jump);
			m_cJump.ReloadHistory();
			return 0;
		} else {
			// Ȃ烌XWv
			CYoRegex cRegex("^[0-9|O-X]+$", CYoRegex::SJIS);
			if (cRegex.Match(str_jump) >= 0 && CURRENTMODE == MODE_DAT) {
				// Xbhr[ŐȂ烌XԍWv
				((Cq2chwmApp*)AfxGetApp())->GetDatView()->JumpNumber(Atoi(str_jump));
				ShowJumpBar(FALSE);
				return 0;
			}
		}
	}

	::MessageBox(NULL, _T("ړ͂ɂURL/ID/Xԍ̂ݓ͉\ł"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_OK|MB_ICONSTOP);
	m_cJump.SetFocus();

	return 0;
}

#if defined(WIN32_PLATFORM_PSPC) || defined(WIN32_PLATFORM_WFSP)
HMENU CMainFrame::GetMenu(
	int in_menu_number)
{
	TBBUTTONINFO tbbi = {0};
	tbbi.cbSize = sizeof(tbbi);
	tbbi.dwMask = TBIF_LPARAM|TBIF_BYINDEX;
	m_wndCommandBar.SendMessage(TB_GETBUTTONINFO, in_menu_number, (LPARAM)&tbbi);
	return (HMENU)tbbi.lParam;
}
#endif
