#include "StdAfx.h"
#include "YoRegex.h"
#include "q2chwm.h"
#include "q2chwmBoardView.h"
#include "q2chwmDatFile.h"
#include "q2chwmCacheImageFile.h"
#include "q2chwmConfig.h"
#include "q2chwmCommon.h"

Cq2chwmCacheImageFile *Cq2chwmCacheImageFile::m_pInstance = NULL;
Cq2chwmCacheImageFile *Cq2chwmCacheImageFile::GetInstance()
{
	if (m_pInstance == NULL) {
		m_pInstance = new Cq2chwmCacheImageFile();
		m_pInstance->Create();
		atexit(Cq2chwmCacheImageFile::Delete);
	}

	return m_pInstance;
}

void Cq2chwmCacheImageFile::Delete()
{
	delete m_pInstance;
}

Cq2chwmCacheImageFile::Cq2chwmCacheImageFile(void)
{
}

Cq2chwmCacheImageFile::~Cq2chwmCacheImageFile(void)
{
	RemoveAll();
}

void Cq2chwmCacheImageFile::RemoveAll()
{
	for (int i = 0; i < Count(); i++) {
		Cq2chwmCacheImageItem *pItem = (Cq2chwmCacheImageItem*)Get(i);
		delete pItem;
	}
	CYoPtrArray::RemoveAll();
}

int Cq2chwmCacheImageFile::Create()
{
	int in_index = 1;
	CYoString str_dir = Cq2chwmConfig::GetInstance()->GetRootDirectory();
	str_dir += "\\.img";
	readDirectory(str_dir, in_index);
	return TRUE;
}

BOOL Cq2chwmCacheImageFile::readDirectory(
	const char *chp_dir,
	int& in_index)
{
	CString cstr_find;		// \MyDocuments\.navi2ch\*.*
	WIN32_FIND_DATA st_find;
	FILETIME st_filetime;
	SYSTEMTIME st_systemtime;
	HANDLE hFind;

	cstr_find = chp_dir;
	cstr_find += "\\*.*";
	hFind = ::FindFirstFile(cstr_find, &st_find);
	if (hFind == INVALID_HANDLE_VALUE) {
		// t@CȂ
		return FALSE;
	}

	do {
		if (wcscmp(st_find.cFileName, _T(".")) == 0 || wcscmp(st_find.cFileName, _T("..")) == 0) continue;
		if (st_find.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) {
//			TRACE(_T("fBNg: %s\n"), st_find.cFileName);
			CYoString str_dir = chp_dir;
			str_dir += "\\";
			str_dir += A(st_find.cFileName);
			readDirectory(str_dir, in_index);
		} else  {
			// XVԎ擾
			FileTimeToLocalFileTime(&st_find.ftLastWriteTime, &st_filetime);
			FileTimeToSystemTime(&st_filetime, &st_systemtime);

			CString cstr_filename;
			cstr_filename = chp_dir;
			cstr_filename += _T("\\");
			cstr_filename += st_find.cFileName;

			CString cstr_date;
			cstr_date.Format(_T("%04d/%02d/%02d %02d:%02d:%02d"),
				st_systemtime.wYear, st_systemtime.wMonth, st_systemtime.wDay, st_systemtime.wHour, st_systemtime.wMinute, st_systemtime.wSecond);

			CYoString str_filename = A(cstr_filename);
			CYoString str_date = A(cstr_date);
			if (addItem(in_index, str_filename, str_date) == TRUE) in_index++;
		}
	} while (FindNextFile(hFind, &st_find));
	::FindClose(hFind);

	return ERR_NONE;
}

BOOL Cq2chwmCacheImageFile::addItem(
	int in_index,
	const char *chp_filename,
	const char *chp_date)
{
	// ǉACeȍ~NoCNg
	for (int i = 0; i < Count(); i++) {
		Cq2chwmCacheImageItem *pItem = GetItem(i);
		if (pItem->GetIndex() >= in_index) {
			pItem->SetIndex(pItem->GetIndex() + 1);
		}
	}

	// ACeǉ
	Cq2chwmCacheImageItem *pItem = new Cq2chwmCacheImageItem(in_index, chp_filename, chp_date);
	Insert(in_index - 1, pItem);

	// nbV}bvɒǉ
	CString cstr_filename;
	cstr_filename = chp_filename;
	m_cMap.SetAt(cstr_filename, (void*)0);

	return TRUE;
}

void Cq2chwmCacheImageFile::Sort(
	int in_col,
	BOOL bo_asc)
{
	if (bo_asc == TRUE) {
		CYoPtrArray::Sort(Cq2chwmCacheImageFile::compAsc, (const void*)in_col);
	} else {
		CYoPtrArray::Sort(Cq2chwmCacheImageFile::compDesc, (const void*)in_col);
	}
}

int Cq2chwmCacheImageFile::compAsc(
	const void *vop_user,
	const void *a,
	const void *b)
{
	int in_col = (int)vop_user;
	Cq2chwmCacheImageItem *aa;
	Cq2chwmCacheImageItem *bb;
	memcpy(&aa, (const void*)a, sizeof(Cq2chwmCacheImageItem*));
	memcpy(&bb, (const void*)b, sizeof(Cq2chwmCacheImageItem*));
	switch (in_col) {
	case IDX_INDEX:
		return aa->GetIndex() > bb->GetIndex() ? 1 : -1;
	case IDX_NAME:
		return strcmp(aa->GetName(), bb->GetName());
	case IDX_DATE:
		return strcmp(aa->GetDate(), bb->GetDate());
	case IDX_SEARCH:
		// tO, NoŃ\[g
		return MAKESORTINT(bb->GetSearch(), -bb->GetIndex(), 0) >
			MAKESORTINT(aa->GetSearch(), -aa->GetIndex(), 0) ? 1 : -1;
	}
	return 0;
}

int Cq2chwmCacheImageFile::compDesc(
	const void *vop_user,
	const void *a,
	const void *b)
{
	int in_col = (int)vop_user;
	Cq2chwmCacheImageItem *aa;
	Cq2chwmCacheImageItem *bb;
	memcpy(&aa, (const void*)a, sizeof(Cq2chwmCacheImageItem*));
	memcpy(&bb, (const void*)b, sizeof(Cq2chwmCacheImageItem*));
	switch (in_col) {
	case IDX_INDEX:
		return aa->GetIndex() < bb->GetIndex() ? 1 : -1;
	case IDX_NAME:
		return strcmp(bb->GetName(), aa->GetName());
	case IDX_DATE:
		return strcmp(bb->GetDate(), aa->GetDate());
	}
	return 0;
}

void Cq2chwmCacheImageFile::RemoveItem(
	int in_pos)
{
	Cq2chwmCacheImageItem *pItem = (Cq2chwmCacheImageItem*)Get(in_pos);
	if (pItem == NULL) return;
	CString cstr_filename;
	cstr_filename = pItem->GetFileName();
	int in_index = pItem->GetIndex();
	delete pItem;
	CYoPtrArray::Remove(in_pos);

	// CfbNX̍Đݒ
	for (int i = 0; i < Count(); i++) {
		Cq2chwmCacheImageItem *pItem = GetItem(i);
		if (in_index < pItem->GetIndex()) {
			pItem->SetIndex(pItem->GetIndex() - 1);
		}
	}

	// nbV}bv폜
	m_cMap.RemoveKey(cstr_filename);
}

BOOL Cq2chwmCacheImageFile::ExistsItem(
	const char *chp_filename)
{
	// nbV}bv猟
	void *vop_value = NULL;
	CString cstr_filename;
	cstr_filename = chp_filename;
	return m_cMap.Lookup(cstr_filename, vop_value);
}

BOOL Cq2chwmCacheImageFile::ExistsItem(
	CString cstr_filename)
{
	// nbV}bv猟
	void *vop_value = NULL;
	return m_cMap.Lookup(cstr_filename, vop_value);
}

int Cq2chwmCacheImageFile::SearchItem(
	const char *chp_filename)
{
	for (int i = 0; i < Count(); i++) {
		Cq2chwmCacheImageItem *pItem = GetItem(i);
		if (strcmp(pItem->GetFileName(), chp_filename) == 0) {
			return i;
		}
	}
	return -1;
}

BOOL Cq2chwmCacheImageFile::UpdateItem(
	int in_row)
{
	Cq2chwmCacheImageItem *pItem = GetItem(in_row);
	if (pItem == NULL) return FALSE;
	WIN32_FIND_DATA st_find;
	HANDLE hFind;

	CString cstr_find;;
	cstr_find = pItem->GetFileName();
	hFind = ::FindFirstFile(cstr_find, &st_find);
	if (hFind == INVALID_HANDLE_VALUE) {
		// t@C폜ꂽ
		RemoveItem(in_row);
	} else {
		// XVԎ擾
		FILETIME st_filetime;
		SYSTEMTIME st_systemtime;
		FileTimeToLocalFileTime(&st_find.ftLastWriteTime, &st_filetime);
		FileTimeToSystemTime(&st_filetime, &st_systemtime);

		CYoString str_date;
		str_date.Format("%04d/%02d/%02d %02d:%02d:%02d",
			st_systemtime.wYear, st_systemtime.wMonth, st_systemtime.wDay, st_systemtime.wHour, st_systemtime.wMinute, st_systemtime.wSecond);
		pItem->SetDate(str_date);
		::FindClose(hFind);
	}
	return TRUE;
}

BOOL Cq2chwmCacheImageFile::AddItem(
	const char *chp_filename)
{
	WIN32_FIND_DATA st_find;
	HANDLE hFind;

	CString cstr_find;;
	cstr_find = chp_filename;
	hFind = ::FindFirstFile(cstr_find, &st_find);
	if (hFind == INVALID_HANDLE_VALUE) {
		return FALSE;
	} else {
		// XVԎ擾
		FILETIME st_filetime;
		SYSTEMTIME st_systemtime;
		FileTimeToLocalFileTime(&st_find.ftLastWriteTime, &st_filetime);
		FileTimeToSystemTime(&st_filetime, &st_systemtime);

		CYoString str_date;
		str_date.Format("%04d/%02d/%02d %02d:%02d:%02d",
			st_systemtime.wYear, st_systemtime.wMonth, st_systemtime.wDay, st_systemtime.wHour, st_systemtime.wMinute, st_systemtime.wSecond);
		addItem(1, chp_filename, str_date);
		::FindClose(hFind);
	}
	return TRUE;
}
