// q2chwmColorSelectorButton.cpp : t@C
//

#include "stdafx.h"
#include "q2chwm.h"
#include "q2chwmColorSelectorButton.h"
#include "q2chwmCommon.h"

// Cq2chwmColorSelectorButton

IMPLEMENT_DYNAMIC(Cq2chwmColorSelectorButton, CButton)

Cq2chwmColorSelectorButton::Cq2chwmColorSelectorButton()
{
	m_color = 0;
}

Cq2chwmColorSelectorButton::~Cq2chwmColorSelectorButton()
{
}


BEGIN_MESSAGE_MAP(Cq2chwmColorSelectorButton, CButton)
END_MESSAGE_MAP()



// Cq2chwmColorSelectorButton bZ[W nh



void Cq2chwmColorSelectorButton::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct)
{

	// TODO:  w肳ꂽڂ`悷邽߂̃R[hǉĂB
	CRect rect = lpDrawItemStruct->rcItem;

	// foCXReLXg擾
	CDC* pDC = CDC::FromHandle(lpDrawItemStruct->hDC);

	// hԂpuVƘgp̃y
	CBrush cBrush(m_color);
	CPen cPen;
	if (lpDrawItemStruct->itemState & ODS_FOCUS) {
		// tH[JXȂgŕ`
		COLORREF color_frame;
		if (BRIGHTNESS(GetRValue(m_color), GetGValue(m_color), GetBValue(m_color)) < 128) {
			color_frame = RGB(255, 255, 255);
		} else {
			color_frame = RGB(0, 0, 0);
		}
		cPen.CreatePen(PS_SOLID, 6, color_frame);
	} else {
		cPen.CreatePen(PS_SOLID, 6, m_color);
	}
	CBrush *pOldBrush = pDC->SelectObject(&cBrush);
	CPen* pOldPen = pDC->SelectObject(&cPen);
	pDC->Rectangle(rect);
	pDC->SelectObject(pOldBrush);
	pDC->SelectObject(pOldPen);

	// Ƀ{^ꂽԂŕ`
	pDC->Draw3dRect(rect, RGB(0, 0, 0), RGB(255, 255, 255));
}

BOOL Cq2chwmColorSelectorButton::Create(
	COLORREF color,
	const RECT &rect,
	CWnd *pParent,
	UINT nID)
{
	m_color = color;
	return CButton::Create(_T(""), BS_PUSHBUTTON|BS_OWNERDRAW, rect, pParent, nID);
}
