// q2chwmListCtrl.cpp : t@C
//

#include "stdafx.h"
#include "q2chwm.h"
#include "q2chwmListCtrl.h"
#include "q2chwmConfig.h"

// Cq2chwmListCtrl

IMPLEMENT_DYNAMIC(Cq2chwmListCtrl, CListCtrl)

Cq2chwmListCtrl::Cq2chwmListCtrl()
{
	m_pImage = new CImageList();
	m_pImage->Create(16, 16, ILC_COLOR8, 0, 4);
//	m_pImage->Create(IDB_BITMAP_LISTVIEW, 32, 0, RGB(0, 255, 0));
	/*
	m_pImage->Create(16, 16, ILC_COLOR8 | ILC_MASK, 1, 1);
	CBitmap *bmp = new CBitmap;
	bmp->LoadBitmap(IDB_BITMAP_LISTVIEW);
	m_pImage->Add(bmp, RGB(0, 255, 0));
	*/
	m_pImage->Add(AfxGetApp()->LoadIcon(IDI_NORMAL));
	m_pImage->Add(AfxGetApp()->LoadIcon(IDI_NETWORK));
}

Cq2chwmListCtrl::~Cq2chwmListCtrl()
{
}


BEGIN_MESSAGE_MAP(Cq2chwmListCtrl, CListCtrl)
	ON_NOTIFY_REFLECT(NM_CUSTOMDRAW, OnCustomDraw)
	ON_NOTIFY_REFLECT(NM_RETURN, &Cq2chwmListCtrl::OnNMReturn)
	ON_NOTIFY_REFLECT(NM_CLICK, &Cq2chwmListCtrl::OnNMClick)
	ON_NOTIFY_REFLECT(LVN_COLUMNCLICK, &Cq2chwmListCtrl::OnLvnColumnclick)
END_MESSAGE_MAP()



// Cq2chwmListCtrl bZ[W nh
BOOL Cq2chwmListCtrl::Create(
	DWORD dwStyle,
	const RECT& rect,
	CWnd* pParentWnd,
	UINT nID)
{
	if (CListCtrl::Create(dwStyle, rect, pParentWnd, nID) == FALSE) {
		return FALSE;
	}
	SetImageList(m_pImage, LVSIL_SMALL);
	return TRUE;
}

void Cq2chwmListCtrl::OnCustomDraw(NMHDR* pNMHDR, LRESULT* pResult)
{
	LPNMLVCUSTOMDRAW pNMCD = (LPNMLVCUSTOMDRAW)pNMHDR;
	int in_col = pNMCD->iSubItem;
	int in_row = pNMCD->nmcd.dwItemSpec;

	TRACE(_T("ROW(%d) COL(%d) STATE(%d)\n"), pNMCD->nmcd.dwItemSpec, pNMCD->iSubItem, pNMCD->nmcd.dwDrawStage);
	switch (pNMCD->nmcd.dwDrawStage) {
	case CDDS_PREPAINT:
		*pResult = CDRF_NOTIFYSUBITEMDRAW;          // TuACeʒmݒ
		break;
	case CDDS_ITEMPREPAINT:
		*pResult = CDRF_NOTIFYSUBITEMDRAW;          // TuACeʒmݒ
		break;
	case CDDS_ITEMPREPAINT|CDDS_SUBITEM: 
	{
		int in_state = ListView_GetItemState(m_hWnd, in_row, LVIS_CUT|LVIS_SELECTED|LVIS_FOCUSED);
		Cq2chwmListItem *pItem = (Cq2chwmListItem*)pNMCD->nmcd.lItemlParam;

		// wi
		if (pItem->GetCache() == TRUE) {
			pNMCD->clrTextBk = Cq2chwmConfig::GetInstance()->GetColorCache();//RGB(100, 100, 100);
		} else if (pItem->GetNew() == TRUE) {
			pNMCD->clrTextBk = Cq2chwmConfig::GetInstance()->GetColorNew();
		} else if (pItem->GetError() == TRUE) {
			pNMCD->clrTextBk = Cq2chwmConfig::GetInstance()->GetColorError();
		} else if (pItem->GetSearch() == TRUE) {
			pNMCD->clrTextBk = Cq2chwmConfig::GetInstance()->GetColorSearch();
		} else {
			pNMCD->clrTextBk = RGB(255, 255, 255);
		}

		// Oi
		if (in_state & LVIS_SELECTED || in_state & LVIS_FOCUSED) {
			pNMCD->clrText = Cq2chwmConfig::GetInstance()->GetColorActive();
		} else {
			pNMCD->clrText = RGB(0, 0, 0);
		}

/*
		int iCol = lplvcd->iSubItem;				// TuACeindex
		int iRow = lplvcd->nmcd.dwItemSpec;		// sindex
		int lparam=lplvcd->nmcd.lItemlParam;

		if (iRow == 6)	{
			lplvcd->clrTextBk = RGB(0,128,255);
			lplvcd->clrText = RGB(255,255,255);
			*pResult = CDRF_NEWFONT;
		} else if (iCol == m_col) {
			for (int i=0;i<10;i++)	{
				if (m_Param[i]==lparam)	{
					lplvcd->clrTextBk = m_BkColor[i];
					lplvcd->clrText = m_TxtColor[i];
				}
			}
			*pResult = CDRF_NEWFONT;
		} else {
			lplvcd->clrTextBk = GetSysColor(COLOR_WINDOW);
			lplvcd->clrText = GetSysColor(COLOR_WINDOWTEXT);
			*pResult = CDRF_NEWFONT;
		}
		*/
		*pResult = CDRF_NEWFONT;//CDRF_SKIPDEFAULT;//CDRF_NOTIFYPOSTPAINT;
		break;
	}
	default:
		*pResult = CDRF_DODEFAULT;
	}
}

void Cq2chwmListCtrl::OnNMReturn(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	GetParent()->SendMessage(WM_USER_LISTCLICKED);
	*pResult = 0;
}

void Cq2chwmListCtrl::OnNMClick(NMHDR *pNMHDR, LRESULT *pResult)
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	GetParent()->SendMessage(WM_USER_LISTCLICKED);
	*pResult = 0;
}

void Cq2chwmListCtrl::SetNetworkIcon(
	int in_row,
	BOOL bo_flg)
{
	if (bo_flg == TRUE) {
		SetItem(in_row, 0, LVIF_IMAGE, NULL, 1, 0, 0, 0);
	} else {
		SetItem(in_row, 0, LVIF_IMAGE, NULL, 0, 0, 0, 0);
	}
}

void Cq2chwmListCtrl::OnLvnColumnclick(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMLISTVIEW pNMLV = reinterpret_cast<LPNMLISTVIEW>(pNMHDR);
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	GetParent()->SetActiveWindow();

	*pResult = 1;
}
