// q2chwmPageGesture.cpp : t@C
//

#include "stdafx.h"
#include "q2chwm.h"
#include "q2chwmPageGesture.h"
#include "q2chwmLayoutManager.h"
#include "q2chwmConfig.h"

// Cq2chwmPageGesture _CAO

IMPLEMENT_DYNAMIC(Cq2chwmPageGesture, CDialog)

Cq2chwmPageGesture::Cq2chwmPageGesture(CWnd* pParent /*=NULL*/)
	: Cq2chwmConfigPage(Cq2chwmPageGesture::IDD, pParent)
	, m_inertia_down(0)
{
	m_inertia_down = Cq2chwmConfig::GetInstance()->GetInertiaDown();
}

Cq2chwmPageGesture::~Cq2chwmPageGesture()
{
}

void Cq2chwmPageGesture::DoDataExchange(CDataExchange* pDX)
{
	DDX_Text(pDX, IDC_COMBO_INERTIA_DOWN, m_inertia_down);
	Cq2chwmConfigPage::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(Cq2chwmPageGesture, CDialog)
	ON_WM_SIZE()
END_MESSAGE_MAP()


// Cq2chwmPageGesture bZ[W nh

void Cq2chwmPageGesture::Write()
{
	UpdateData(TRUE);

	BOOL gesture = TRUE;
	BOOL inertia = TRUE;
	double down = 0.2;

	// WFX`[h
	{
		CButton *pButton = (CButton*)GetDlgItem(IDC_CHECK_GESTURE_MODE);
		gesture = pButton->GetCheck();
		Cq2chwmConfig::GetInstance()->SetGestureMode(gesture);
	}
	// XN[
	{
		CButton *pButton = (CButton*)GetDlgItem(IDC_CHECK_INERTIA_MODE);
		inertia = pButton->GetCheck();
		Cq2chwmConfig::GetInstance()->SetInertiaMode(inertia);
	}
	// 
	{
		int inertia_down = m_inertia_down;
		if (inertia_down < 1)	inertia_down = 1;
		if (inertia_down > 100)	inertia_down = 100;
		Cq2chwmConfig::GetInstance()->SetInertiaDown(inertia_down);
		down = (double)inertia_down / 100;
	}
	// [hݒ
	((Cq2chwmApp*)AfxGetApp())->GetDatView()->SetGestureMode(gesture, inertia, down);
	((Cq2chwmApp*)AfxGetApp())->GetBoardView()->SetGestureMode(gesture, inertia, down);
	((Cq2chwmApp*)AfxGetApp())->GetImageView()->SetGestureMode(gesture, inertia, down);
}


BOOL Cq2chwmPageGesture::OnInitDialog()
{
	Cq2chwmConfigPage::OnInitDialog();

	// TODO:  ɏǉĂ
	// WFX`[h
	{
		CButton *pButton = (CButton*)GetDlgItem(IDC_CHECK_GESTURE_MODE);
		pButton->SetCheck(Cq2chwmConfig::GetInstance()->GetGestureMode());
	}
	// XN[
	{
		CButton *pButton = (CButton*)GetDlgItem(IDC_CHECK_INERTIA_MODE);
		pButton->SetCheck(Cq2chwmConfig::GetInstance()->GetInertiaMode());
	}

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

void Cq2chwmPageGesture::OnSize(UINT nType, int cx, int cy)
{
	Cq2chwmConfigPage::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B
	Cq2chwmLayoutManager cLayout(
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_MESSAGE), 1),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_CHECK_GESTURE_MODE), 1),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_CHECK_INERTIA_MODE), 1),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_INERTIA_DOWN), 1, GetDlgItem(IDC_COMBO_INERTIA_DOWN), 1)
	);
	cLayout.Layout(cx, cy);
}
