#include "stdafx.h"
#include "MainFrm.h"
#include "q2chwmBbs.h"
#include "q2chwmDoLib.h"
#include "q2chwmInfoFile.h"

//! 2chBbsNX̃RXgN^
/*!
 * Describe Cq2chwmBbs
 * ʏ2chfdat擾B
 * ܂ABBS̊NXɂȂĂB
 * NXŉLoϐB
 * m_str_dir: DATt@CfBNg̃tpXBGetDir()Ŏ擾\
 * m_str_id: fIDBGetId()Ŏ擾\
 * m_str_url: x[XURLBGetBaseUrl()Ŏ擾\
 * m_str_path: DATt@C̃tpXBGetDatPath()Ŏ擾\
 * \param pParent CEBhẼ|C^
 * \param chp_id fID ex. 1147306677
 * \param chp_url x[XURL ex. http://pc10.2ch.net/mobile/
 */
Cq2chwmBbs::Cq2chwmBbs(
	CWnd *pParent,
	const char *chp_aid,
	const char *chp_burl)
{
	m_pParent = pParent;
	m_str_dir = UrlToPath(chp_burl);
	m_str_aid = chp_aid;
	m_str_burl = chp_burl;
	m_str_path = m_str_dir + "\\" + m_str_aid + ".dat";
	m_in_recv = 0;
	m_in_http_result_code = 0;
//	m_bo_lock = FALSE;
}

//! fXgN^
/*!
 * 
 */
Cq2chwmBbs::~Cq2chwmBbs()
{
}

//! DATt@CI[v
/*!
 * Rg[Ă΂BGetDatPath()Ŏ擾łt@CI[vB
 * \return int I: ERR_NONE ُI: ERR_FILE_OPEN
 */
int Cq2chwmBbs::OpenFile()
{
	BOOL bo_create = FALSE;
	MakeDirectory(GetDir());

	CString cstr_path;
	cstr_path = m_str_path;

	// t@C݃`FbNč쐬tO擾
	bo_create = TRUE;
	if (m_cFile.Open(cstr_path, CFile::modeRead) == TRUE) {
		if (m_cFile.GetLength() > 0) {
			bo_create = FALSE;
		}
		m_cFile.Close();
	}
	m_in_write = 0;
	if (m_cFile.Open(cstr_path, CFile::modeWrite|CFile::modeCreate|CFile::modeNoTruncate) == FALSE) {
		return ERR_FILE_OPEN;
	}
	m_cFile.Seek(0, CFile::end);

	// CEBhEփCxg
	PostCustomMessage(m_pParent->m_hWnd, new Cq2chwmOpenFileMessage(GetArticleId(), GetBoardUrl(), GetDatPath(), bo_create));

	return ERR_NONE;
}

//! t@C
/*!
 * Rg[Ă΂B
 * chp_data͎Mf[^̂܂ܓn
 * tH[}bgϊKvȏꍇWriteFileConvert(CYoString&)I[o[Ch邱
 * 2ch̏ꍇ͉LtH[}bg
 * O<>[AhX<>t<>bZ[W<>Xbh^Cg\n
 * t[4]/[2]/[2]([1j]) [2]:[2]:[2b] ID:[ID]
 * Xbh^Cg1sڂ̂
 * sĂ\Ȃ
 * srŐ؂ĂĂ\Ȃ(obt@OĂ܂Ə)
 * \param chp_data 2chDATt@CtH[}bg
 * \return int I: ERR_NONE ُI: ERR_FILE_WRITE
 */
int Cq2chwmBbs::WriteFile(
	const char *chp_data)
{
	// KsŏI悤Ƀt@CɏށB]m_str_buffɋL
	const char *chp_lf = strrchr(chp_data, '\n');
	if (chp_lf == NULL) {
		m_str_buff += chp_data;
	} else {
		chp_lf++;
		m_str_buff.StrnCat(chp_data, chp_lf - chp_data);

		// Kv2ch`ɃtH[}bgϊ
		{
			int in_ret = WriteFileConvert(m_str_buff);
			if (in_ret != ERR_NONE) {
				return in_ret;
			}
			if (m_str_buff.Length() == 0) {
				return ERR_NONE;
			}
		}

		// t@C
		try {
			m_cFile.Write((const char*)m_str_buff, m_str_buff.Length());
		} catch (CFileException* pEx) {
			pEx->Delete();
			return ERR_FILE_WRITE;
		}
		m_cFile.Flush();
		m_in_write += m_str_buff.Length();

		// CEBhEփCxg
		PostCustomMessage(m_pParent->m_hWnd, new Cq2chwmWriteFileMessage(GetArticleId(), GetBoardUrl(), GetDatPath(), m_str_buff));

		m_str_buff = chp_lf;
	}
	return ERR_NONE;
}

//! DATt@CݑÕtH[}bgϊ
/*!
 * BBSpɌpNXpɃI[o[Ch邱Ƃz
 * Mf[^str_buff2ch`̉LtH[}bg֕ϊs
 * O<>[AhX<>t<>bZ[W<>Xbh^Cg\n
 * t[4]/[2]/[2]([1j]) [2]:[2]:[2b] ID:[ID]
 * Xbh^Cg1sڂ̂
 * CString͕s݂邪s̓rŐ؂ĂȂ
 * \param str_buff Mf[^(sŏI邱Ƃۏ؂Ă)
 * \return int I: ERR_NONE ُI: ERR_FILE_WRITE_CONVERT
 */
int Cq2chwmBbs::WriteFileConvert(
	CYoString&)
{
	// 2chNXł͂ȂɂȂ
	return ERR_NONE;
}

//! t@CN[Y
/*!
 * DATt@C̃N[Y
 * \return int I: ERR_NONE ُI: ERR_FILE_WRITE
 */
int Cq2chwmBbs::CloseFile()
{
	// ]肠Ώ
	if (m_str_buff.Length() > 0) {
		int in_ret = WriteFile(m_str_buff);
		if (in_ret != ERR_NONE) {
			return in_ret;
		}
		m_str_buff = "";
	}

	m_cFile.Close();

	// CEBhEփCxg
	PostCustomMessage(m_pParent->m_hWnd, new Cq2chwmCloseFileMessage(GetArticleId(), GetBoardUrl(), GetDatPath(), m_in_write));

	return ERR_NONE;
}

//! HTTPNCAg̃IvVݒ
/*!
 * ProxyAUser-Agent, R[obN֐, 擾(Rangewb_)CYoHttpClientɃZbg
 * BBS̏ꍇA擾͂Ȃ̂ŕKI[o[Ch邱
 * \return int I: ERR_NONE
 */
int Cq2chwmBbs::ModifyHttp()
{
	// 2ch͍擾̂Rangeݒ
	ULONGLONG ull_length;
	FILETIME st_modify;
	if (ExistFile(m_str_path, &ull_length, &st_modify) == TRUE) {
		if (ull_length > 0) {
			// Range
			CYoString str_range;
			str_range.Format("bytes=%d-", ull_length - 1);
			m_cHttp.AddRequestHeader("Range", str_range);
		}

		// If-Modified-Since
		CYoString str_time = ConvertGmtTime(&st_modify);
		m_cHttp.AddRequestHeader("If-Modified-Since", str_time);

		// 擾Ȃ̂gzip͂܂Ȃ̂
		m_cHttp.SetGzipEncoding(FALSE);
	}

	return ERR_NONE;
}

//! URLI[v
/*!
 * WEBT[oɐڑANGXg𑗐MBX|Xwb_܂œǂݍށB
 * \return int I: ERR_NONE ُI: ERR_NONEȊO
 */
int Cq2chwmBbs::OpenUrl()
{
	// oϐ
	m_in_recv = 0;
	m_in_http_result_code = 0;

	// URL
	CYoString str_url = GetUrl();
	if (str_url.Length() == 0) {
		return ERR_HTTP_CONNECT;
	}

	m_cHttp.SetUrl(str_url);
	m_cHttp.ClearRequestHeader();

	// HTTPNCAgIvVݒ
	{
		if (Cq2chwmConfig::GetInstance()->GetProxyUse() == TRUE) {
			m_cHttp.SetProxy(Cq2chwmConfig::GetInstance()->GetProxyHost(), Cq2chwmConfig::GetInstance()->GetProxyPort());
			m_cHttp.SetProxyAuth(Cq2chwmConfig::GetInstance()->GetProxyId(), Cq2chwmConfig::GetInstance()->GetProxyPass());
		}
		m_cHttp.SetCallbackProc(CMainFrame::CallbackProc, m_pParent);
		m_cHttp.SetUserAgent(USERAGENT);
		int in_ret = ModifyHttp();
		if (in_ret != ERR_NONE) {
			return in_ret;
		}
	}

	// ڑ(gCH)
	if (m_cHttp.Connect(TIMEOUT) == FALSE) {
		return ERR_HTTP_CONNECT;
	}

	// GETNGXg
	if (m_cHttp.Get() == FALSE) {
		return ERR_HTTP_GET;
	}

	// HTTPR[h
	m_in_http_result_code = m_cHttp.GetResultCode();
	if (m_in_http_result_code == 304) {
		// 304 Not Modified͐ƂĕԂB302 Location̓Rg[ŎCq2chwmBbsIuWFNgɔC
		return ERR_NONE;
	} else if ( m_in_http_result_code == 302) {
		return ERR_HTTP_LOCATION;
	} else if (m_in_http_result_code == 416) {
		return ERR_HTTP_ABONE;
	} else if (m_in_http_result_code < 200 || m_in_http_result_code >= 300) {
		return ERR_HTTP_GET;
	}

	// `FbN
	{
		int in_ret = OpenUrlCheck();
		if (in_ret != ERR_NONE) {
			return in_ret;
		}
	}

	return ERR_NONE;
}

//! GETNGXg̃`FbNs
/*!
 * 2ch擾̏ꍇA1byteO烊NGXgځ[`FbNs
 * BBS̏ꍇȀ͂Ȃ͂Ȃ̂ŃI[o[ChďȂ悤ɂ邱
 * \return int I: ERR_NONE
 */
int Cq2chwmBbs::OpenUrlCheck()
{
	// ځ[񔻒
	CYoString str_range = m_cHttp.GetRequestHeader("Range");
	if (str_range.Length() > 0) {
		char cha_buff[1];
		m_cHttp.Recv(cha_buff, 1);
		if(*cha_buff != '\n'){
			return ERR_HTTP_ABONE;
		}
		m_in_recv = 1;
	}

	return ERR_NONE;
}

//! DATt@Cǂݍ
/*!
 * WEBT[oHTTPX|Xwb_ȍ~̃f[^ǂݍ
 * \param chp_buff 
 * \param in_len 
 * \return int 
 */
int Cq2chwmBbs::ReadUrl(
	char *chp_buff,
	int in_len)
{
	int in_ret = m_cHttp.Recv(chp_buff, in_len);
	if (in_ret < 0) {
		return ERR_HTTP_RECV;
	}

	// M dat  0x00 ꍇ͍폜
	for (int i = 0; i < in_ret; i++) {
		if( chp_buff[i] == 0x00 ){
			chp_buff[i] = ' ';
		}
	}
	chp_buff[in_ret] = 0x00;
	m_in_recv += in_ret;

	CYoString str_length = m_cHttp.GetResponseHeader("Content-Length");
	int in_length = str_length.Atoi();
	PostCustomMessage(m_pParent->m_hWnd, new Cq2chwmReadUrlMessage(GetArticleId(), GetBoardUrl(), GetDatPath(), m_in_recv, in_length));

	return in_ret;
}

//! WEBT[oؒf
/*!
 * 
 * \return int 
 */
int Cq2chwmBbs::CloseUrl()
{
	m_cHttp.Close();
	return ERR_NONE;
}

//! URLgݗ
/*!
 * DoAction\bhĂ΂BDATt@C擾pURLԂB
 * BBSpɌpꍇÃ\bhI[o[ChURLύX
 * \return CYoString 
 */
CYoString Cq2chwmBbs::GetUrl()
{
	CYoString str_url;
	str_url.Format("%sdat/%s.dat", GetBoardUrl(), GetArticleId());
	return str_url;
}

//! URL
/*!
 * Rg[URLׂǂ₢킹邽߂ɂ̃\bhĂяo
 * BBŜ߂ɌpꍇÃ\bhI[o[ChďׂURLǂf
 * \param chp_url x[XURL(ex http://pc10.2ch.net/mobile/ Ƃ http://xxx.bbspink.com/xxxx/Ƃ)
 * \return BOOL ׂURL: TRUE ȂURL: FALSE
 */
BOOL Cq2chwmBbs::MatchUrl()
{
	// URL`FbNOɃX1001Ȃ珈Ȃ
	if ((strstr(GetBoardUrl(), "2ch.net") != NULL || strstr(GetBoardUrl(), "bbspink.com") != NULL) &&
		Cq2chwmInfoFile::Count(GetBoardUrl(), GetArticleId()) == 1001)
	{
		return FALSE;
	}
	
	//CYoRegex cRegex("^http://[^/]*[^./]+\\.[^./]+\\.[^./]+/[^/]+/", TRUE);
	//return cRegex.Match(GetBaseUrl()) >= 0 ? TRUE : FALSE;
	return TRUE;
}

//! DoActionJnɌĂ΂
/*!
 * KvȂ珉sp
 * \return int I: ERR_NONE ُI: ERR_NONEȊO
 */
int Cq2chwmBbs::DoActionInit()
{
	return ERR_NONE;
}

//! DoActionIɌĂ΂
/*!
 * KvȂIsp
 * ̃\bh̕ԋplDoAction̕ԋplƂȂ̂(ʂȎĕύXꍇȊO)̂܂in_retԂ
 * ERR_RETRYԂDoActionēxs
 * \param in_ret DoAction̏
 * \return int I: in_ret gC: ERR_RETRY
 */
int Cq2chwmBbs::DoActionTerm(
	int in_ret)
{
	return in_ret;
}

//! DATt@C擾
/*!
 * URLI[v(WEBT[oڑ)
 * DATt@CI[v
 * URLǂݍ(WEBT[oM)
 * DATt@C
 * DATt@CN[Y
 * URLN[Y(WEBT[oؒf)
 * s
 * \return int I: ERR_NONE
 */
int Cq2chwmBbs::DoAction()
{
	int in_ret = ERR_NONE;

	// 
	in_ret = DoActionInit();
	if (in_ret != ERR_NONE) {
		in_ret = DoActionTerm(in_ret);
		if (in_ret == ERR_RETRY) {
			return DoAction();
		}
		return in_ret;
	}

	// URLJ
	in_ret = OpenUrl();
	if (in_ret != ERR_NONE) {
		CloseUrl();
		in_ret = DoActionTerm(in_ret);
		if (in_ret == ERR_RETRY) {
			return DoAction();
		}
		return in_ret;
	}

	// t@CJ
	in_ret = OpenFile();
	if (in_ret != ERR_NONE) {
		CloseUrl();
		in_ret = DoActionTerm(in_ret);
		if (in_ret == ERR_RETRY) {
			return DoAction();
		}
		return in_ret;
	}

	// URLǂ
	char cha_buff[RECV_BUFF];
	while(ReadUrl(cha_buff, sizeof(cha_buff) - 1) > 0) {
		// t@C
		int in_ret = WriteFile(cha_buff);
		if (in_ret != ERR_NONE) {
			CloseFile();
			CloseUrl();
			in_ret = DoActionTerm(in_ret);
			if (in_ret == ERR_RETRY) {
				return DoAction();
			}
			return in_ret;
		}
	}

	CloseFile();
	CloseUrl();
	in_ret = DoActionTerm(in_ret);
	if (in_ret == ERR_RETRY) {
		return DoAction();
	}

	return ERR_NONE;
}

//! ߋO擾NX
/*!
 * 
 * \param pParent 
 * \param chp_dir 
 * \param chp_id 
 * \param chp_url 
 */
Cq2chwmBbsKako::Cq2chwmBbsKako(
	CWnd *pParent,
	const char *chp_id,
	const char *chp_url) : Cq2chwmBbs(pParent, chp_id, chp_url)
{
}

//! kߋO擾NX
/*!
 * 
 * \param pParent 
 * \param chp_dir 
 * \param chp_id 
 * \param chp_url 
 */
Cq2chwmBbsKakoPlain::Cq2chwmBbsKakoPlain(
	CWnd *pParent,
	const char *chp_id,
	const char *chp_url) : Cq2chwmBbsKako(pParent, chp_id, chp_url)
{
}

//! GETNGXg̃`FbN
/*!
 * ߋO擾̏ꍇ́A`FbNKvȂ
 * \return int 
 */
int Cq2chwmBbsKako::OpenUrlCheck()
{
	RemoveFile(GetDatPath());
	return ERR_NONE;
}

//! URLgݗ
/*!
 * ߋO擾pURLgݗ
 * http://pc10.2ch.net/mobile/
 * 
 * http://pc10.2ch.net/mobile/kako/1040/10408/1040837750.dat.gz
 * \return CYoString 
 */
CYoString Cq2chwmBbsKako::GetUrl()
{
	CYoString str_url;
	CYoString str_id3bytes;
	CYoString str_id4bytes;
	CYoString str_id5bytes;
	str_id3bytes.StrnCpy(GetArticleId(), 3);
	str_id4bytes.StrnCpy(GetArticleId(), 4);
	str_id5bytes.StrnCpy(GetArticleId(), 5);
	if (strlen(GetArticleId()) == 9) {
		str_url.Format("%skako/%s/%s.dat.gz", GetBoardUrl(), (const char*)str_id3bytes, GetArticleId());
	} else {
		str_url.Format("%skako/%s/%s/%s.dat.gz", GetBoardUrl(), (const char*)str_id4bytes, (const char*)str_id5bytes, GetArticleId());
	}

	return str_url;
}

//! URLgݗ
/*!
 * kߋO擾pURLgݗ
 * http://pc10.2ch.net/mobile/
 * 
 * http://pc10.2ch.net/mobile/kako/1040/10408/1040837750.dat
 * \return CYoString 
 */
CYoString Cq2chwmBbsKakoPlain::GetUrl()
{
	CYoString str_url;
	CYoString str_id3bytes;
	CYoString str_id4bytes;
	CYoString str_id5bytes;
	str_id3bytes.StrnCpy(GetArticleId(), 3);
	str_id4bytes.StrnCpy(GetArticleId(), 4);
	str_id5bytes.StrnCpy(GetArticleId(), 5);
	if (strlen(GetArticleId()) == 9) {
		str_url.Format("%skako/%s/%s.dat", GetBoardUrl(), (const char*)str_id3bytes, GetArticleId());
	} else {
		str_url.Format("%skako/%s/%s/%s.dat", GetBoardUrl(), (const char*)str_id4bytes, (const char*)str_id5bytes, GetArticleId());
	}

	return str_url;
}

//! HTTPNCAg̃IvVݒ
/*!
 * ߋOqɂ.gzŕۑĂ邽gzipGR[fBOLɂ
 * ModifyHttpłȂɂȂĂgzipL
 * \param cHttp 
 * \return int I: ERR_NONE
 */
int Cq2chwmBbsKako::ModifyHttp()
{
	return ERR_NONE;
}

//! DoLibANZXpRXgN^
/*!
 * 
 * \param pParent 
 * \param chp_id 
 * \param chp_url 
 */
Cq2chwmBbsDoLib::Cq2chwmBbsDoLib(
	CWnd *pParent,
	const char *chp_id,
	const char *chp_url) : Cq2chwmBbs(pParent, chp_id, chp_url)
{
	m_bo_check = FALSE;
	m_bo_login = FALSE;
}

//! DATt@CݑÕtH[}bgϊ
/*!
 * 2chȂ̂ŕϊ̕Kv͂ȂBA1sڂ̐擪+OK-ERR̃`FbNs
 * \param str_buff 
 * \return int 
 */
int Cq2chwmBbsDoLib::WriteFileConvert(
	CYoString &str_buff)
{
	if (m_bo_check == FALSE) {
		char *chp_sta = str_buff;
		char *chp_end = strchr(chp_sta, '\n');
		if (chp_end == NULL) {
			// sȂ1sڂ̎MIĂȂ
			m_str_firstline = chp_sta;
			str_buff = "";
		} else {
			m_str_firstline.StrnCat(chp_sta, chp_end - chp_sta);
			if (strncmp(m_str_firstline, "-ERR", 4) == 0) {
				CYoString str_err = m_str_firstline;
				SetErrorMessage(str_err);
				str_buff = "";
				PRINTLOG("%s", (const char*)str_err);
				return ERR_DOLIB_AUTH;
			}
			m_bo_check = TRUE;
			str_buff = chp_end + 1;
		}
	}

	return ERR_NONE;
}

//! GETNGXg̃`FbN
/*!
 * ɂ邱ƂȂ
 * \return int 
 */
int Cq2chwmBbsDoLib::OpenUrlCheck()
{
	return ERR_NONE;
}

//! URLgݗ
/*!
 * http://pc10.2ch.net/mobile/
 * 
 * http://pc10.2ch.net/test/offlaw.cgi/mobile/1040837750/?sid=[ZbVID]
 * 
 * \return CYoString 
 */
CYoString Cq2chwmBbsDoLib::GetUrl()
{
	CYoRegex cRegex("http://([^/]+)/([^/]+)/");
	if( cRegex.Match(GetBoardUrl()) < 0 ){
		return CYoString();
	}
	CYoString str_url;
	str_url.Format("http://%s/test/offlaw.cgi/%s/%s/", cRegex.Get(1), cRegex.Get(2), GetArticleId());
	return str_url;
}

//! URL
/*!
 * URLId/Pw`FbNs
 * \return BOOL 
 */
BOOL Cq2chwmBbsDoLib::MatchUrl()
{
	// Id/Pwݒ肳ĂȂƏȂ
	if (strlen(Cq2chwmConfig::GetInstance()->GetDoLibId()) == 0 || strlen(Cq2chwmConfig::GetInstance()->GetDoLibPass()) == 0) {
		return FALSE;
	}

	return Cq2chwmBbs::MatchUrl();
}

//! HTTPNCAg̃IvVݒ
/*!
 * DoLibANZX̏ꍇraw=0.0&sid=[ZbVID]t
 * \param cHttp 
 * \return void 
 */
int Cq2chwmBbsDoLib::ModifyHttp()
{
	// ݒt@CɃZbVIDȂ炻gpBȂΔF؂Ď擾
	CYoString str_sid = Cq2chwmConfig::GetInstance()->GetDoLibSid();
	if( str_sid.Length() == 0 ){
		if (Cq2chwmDoLib::GetSid(str_sid, Cq2chwmConfig::GetInstance()->GetDoLibId(), Cq2chwmConfig::GetInstance()->GetDoLibPass()) == FALSE) {
			return ERR_DOLIB_AUTH;
		}
		Cq2chwmConfig::GetInstance()->SetDoLibSid(str_sid);
	}

	CYoString str_ua;
	CYoString str_id;
	if (Cq2chwmDoLib::ParseSid(str_ua, str_id, str_sid) == FALSE) {
		return ERR_DOLIB_AUTH;
	}

	str_ua += " ("APP_NAME"/"APP_VERSION")";
	str_sid.UrlEncode();
	m_cHttp.SetUserAgent(str_ua);
	m_cHttp.ClearParameter();
	m_cHttp.SetParameter("raw", "0.0");
	m_cHttp.SetParameter("sid", str_sid);

	// DATt@CȂIf-Modify-Sinceݒ(擾͂Ȃ̂DATt@CobNAbvƂ)
	FILETIME st_modify;
	if (ExistFile(GetDatPath(), NULL, &st_modify) == TRUE) {
		// If-Modified-Since
		CYoString str_time = ConvertGmtTime(&st_modify);
		m_cHttp.AddRequestHeader("If-Modified-Since", str_time);

		// t@C̃obNAbvs
		CYoString str_file_bak = CYoString(GetDatPath()) + ".bak";
		RenameFile(GetDatPath(), str_file_bak);
	} else {
		m_cHttp.SetIfModifiedSince(0);
	}

	return ERR_NONE;
}

//! DoAction̏
/*!
 * \return int 
 */
int Cq2chwmBbsDoLib::DoActionInit()
{
	m_str_firstline = "";
	return ERR_NONE;
}

//! DoAction̏I
/*!
 * 304ȂobNAbvt@C߂
 * OC(!m_bo_login)DoLib֘AG[Ȃ烍OCăgC
 * قƂDoLib̃ZbVL؂̃bZ[W܂ł݂ǂ܂MpłȂȂ̂
 * DoLib֘AG[Ȃ烊gCႤ
 * \param in_ret 
 * \return int
 */
int Cq2chwmBbsDoLib::DoActionTerm(
	int in_ret)
{
	if (m_bo_login == FALSE && in_ret == ERR_DOLIB_AUTH) {
		// OCăgCĂ݂
		if (m_str_firstline == "-ERR ȔorXbhȂłB") {
			// DoLib̃G[bZ[W̎dl킩ȂǁAƂ肠̃bZ[W̓gCĂ
			;
		} else {
			// ZbV؂̃bZ[W"-ERR @܂"݂ǁc
			CYoString str_sid;
			if (Cq2chwmDoLib::GetSid(str_sid, Cq2chwmConfig::GetInstance()->GetDoLibId(), Cq2chwmConfig::GetInstance()->GetDoLibPass()) == FALSE) {
				return ERR_DOLIB_AUTH;
			}
			Cq2chwmConfig::GetInstance()->SetDoLibSid(str_sid);
			m_bo_login = TRUE;

			return ERR_RETRY;
		}
	}

	CYoString str_file_bak = CYoString(GetDatPath()) + ".bak";
	if (in_ret != ERR_NONE || GetHttpResultCode() == 304) {
		// G[304 Not ModifiedȂobNAbvt@Cɖ߂
		RenameFile(str_file_bak, GetDatPath());

		// r[Ƀ[h𑣂
		PostCustomMessage(m_pParent->m_hWnd, new Cq2chwmReloadFileMessage(GetArticleId(), GetBoardUrl(), GetDatPath()));
	} else {
		RemoveFile(str_file_bak);
	}

	return in_ret;
}

//! 2ch݊SJISf擾NX
/*!
 * be.2ch.netEUC->SJISϊKv炵
 * pukiwiki2chBBSvOC
 * \param pParent 
 * \param chp_id 
 * \param chp_url 
 */
Cq2chwmBbsSjis::Cq2chwmBbsSjis(
	CWnd *pParent,
	const char *chp_id,
	const char *chp_url) : Cq2chwmBbs(pParent, chp_id, chp_url)
{
}

//! URL
/*!
 * be.2ch.net炵
 * \param chp_url x[XURL(ex http://be.2ch.net/?????/)
 * \return BOOL ׂURL: TRUE ȂURL: FALSE
 */
BOOL Cq2chwmBbsSjis::MatchUrl()
{
	// URL`FbNOɃX1001Ȃ珈Ȃ
	if (Cq2chwmInfoFile::Count(GetBoardUrl(), GetArticleId()) == 1001) {
		return FALSE;
	}
	
	CYoRegex cRegex("^http://be\\.2ch\\.net/[^/]+/|^http://[^/]+/plugin/2chBBS", TRUE);
	return cRegex.Match(GetBoardUrl()) >= 0 ? TRUE : FALSE;
}

//! DATt@CݑÕtH[}bgϊ
/*!
 * be.2ch.netEUC->SJISϊKv炵(be.2ch.net̏ꏊ킩񂯂ǁc)
 * pukiwiki2chBBSvOC̓tH[}bgϊ(NXقC邯ǂƂ炢`)
 * \param str_buff 
 * \return int 
 */
int Cq2chwmBbsSjis::WriteFileConvert(
	CYoString &str_buff)
{
	str_buff.ConvertKCodeEx(CYoString::EUCTOSJIS);
	if (strstr(GetBoardUrl(), "/plugin/2chBBS/") != NULL) {
		// 2chdat`ɕϊ
		CYoString str_convert;
		char *chp_sta = str_buff;
		char *chp_end;
		while ((chp_end = strchr(chp_sta, '\n'))) {
			// pukiwiki`: [O(0)]<>[[(1)]<>[t(2)]<>[Rg(3)]<>[Xbh(4)]<>[MD5zXg(5)]<>[ID(6)]
			*chp_end = 0x00;
			CYoDataArray cArray = CYoDataArray::CreateStringArray(chp_sta, "<>");
			if (cArray.Count() != 7) {
				return ERR_FILE_CONVERT;
			}
			CYoString str_name = (char*)cArray.Get(0);
			CYoString str_mail = (char*)cArray.Get(1);
			CYoString str_date = (char*)cArray.Get(2);
			CYoString str_comment = (char*)cArray.Get(3);
			CYoString str_bname = (char*)cArray.Get(4);
			CYoString str_id = (char*)cArray.Get(6);
			// 2ch`: [O]<>[[]<>[t] ID:[ID]<>[Rg]<>[Xbh^Cg]
			CYoString str_line;
			str_line.Format("%s<>%s<>%s ID: %s<>%s<>%s",
								  (const char*)str_name, (const char*)str_mail, (const char *)str_date,
								  (const char*)str_id, (char*)str_comment, (char*)str_bname);

			// DAT̃TCY킹邽߂ɃXy[Xł߂
			for (unsigned int i = str_line.Length(); i < strlen(chp_sta); i++) {
				str_line += " ";
			}
			str_convert += str_line + "\n";
			chp_sta = chp_end + 1;
		}
		str_buff = str_convert;
	}

	return ERR_NONE;
}
