#include "StdAfx.h"
#include "YoRegex.h"
#include "q2chwmCommon.h"
#include "q2chwmEditCtrl.h"

void Cq2chwmEditCtrl::Regist(
	const HINSTANCE hInstance)
{
	nedit_regist(hInstance);
}

Cq2chwmEditCtrl::Cq2chwmEditCtrl()
{
	m_in_fontsize = 0;
}

Cq2chwmEditCtrl::~Cq2chwmEditCtrl()
{
	ShowWindow(SW_HIDE);
	::SendMessage(m_hWnd, WM_DESTROY, 0, 0);
}

void Cq2chwmEditCtrl::SetAutoUpdate(
	BOOL bo_update)
{
	//getPaintTool().setAutoUpdate(bo_update == TRUE ? true : false);
}

BOOL Cq2chwmEditCtrl::Create(
	CWnd *pParent,
	int x,
	int y,
	int cx,
	int cy)
{
	m_hWnd = ::CreateWindowEx(0, NEDIT_WND_CLASS, TEXT(""),
		WS_VISIBLE|WS_CHILD|WS_VSCROLL|WS_HSCROLL|/*WS_BORDER|*/ES_MULTILINE|ES_NOHIDESEL,
		0, 0, 0, 0,
		pParent->m_hWnd, (HMENU)0/*IDC_EDIT_EDIT*/, AfxGetApp()->m_hInstance, NULL);
	::SendMessage(m_hWnd, EM_SETREADONLY, TRUE, 0);
	return TRUE;
}

void Cq2chwmEditCtrl::SetFont(
	const char *chp_name,
	int in_size)
{
	if (m_str_fontname == chp_name && m_in_fontsize == in_size) return;
	m_str_fontname = chp_name;
	m_in_fontsize = in_size;
	CString cstr_name;
	cstr_name = chp_name;
	LOGFONT lf;
	memset(&lf, 0x00, sizeof(lf));
	_tcscpy_s(lf.lfFaceName, LF_FACESIZE, cstr_name);
	//_tcscpy_s(m_lf.lfFaceName, cstr_name);
	lf.lfHeight = in_size * 10;
	lf.lfWeight = FW_NORMAL;
	lf.lfCharSet = DEFAULT_CHARSET;
	m_cFont.DeleteObject();
	m_cFont.CreatePointFontIndirect(&lf);
	HFONT hFont = (HFONT)m_cFont;
	::SendMessage(m_hWnd, WM_SETFONT, (WPARAM)hFont, MAKELPARAM(TRUE, 0));
}

void Cq2chwmEditCtrl::SetColor(
	COLORREF *pColors)
{
}

void Cq2chwmEditCtrl::SetFocus()
{
	::SendMessage(m_hWnd, WM_SETFOCUS, 0, 0);
}

void Cq2chwmEditCtrl::SetText(
	const char *chp_text,
	int in_len)
{
	CString cstr_text;
	cstr_text = chp_text;
	::SendMessage(m_hWnd, WM_SETTEXT, 0, (LPARAM)(const TCHAR*)cstr_text);
}

void Cq2chwmEditCtrl::AddText(
	const char *chp_text,
	int in_len)
{
	CString cstr_text;
	cstr_text = chp_text;
	::SendMessage(m_hWnd, WM_ADDTEXT, 0, (LPARAM)(const TCHAR*)cstr_text);
}

void Cq2chwmEditCtrl::SetWrap(
	BOOL bo_flg)
{
	::SendMessage(m_hWnd, WM_SETWORDWRAP, bo_flg, 0);
}

BOOL Cq2chwmEditCtrl::MoveWindow(
	int x,
	int y,
	int cx,
	int cy)
{
	::MoveWindow(m_hWnd, x, y, cx, cy, TRUE);
	return TRUE;
}

BOOL Cq2chwmEditCtrl::ShowWindow(
	int in_cmd)
{
	::ShowWindow(m_hWnd, in_cmd);
	return TRUE;
}

int Cq2chwmEditCtrl::GetLines()
{
	return ::SendMessage(m_hWnd, EM_GETLINECOUNT, 0, 0);
}

// s̍ŌȂTRUEA܂sȂFALSE
BOOL Cq2chwmEditCtrl::GetLineString(
	int in_line,
	CString& cstr_line)
{
	int in_index = ::SendMessage(m_hWnd, EM_LINEINDEX, in_line, 0);
	int in_len = ::SendMessage(m_hWnd, EM_LINELENGTH, in_index, 0);
	if (in_len == 0) return FALSE;
	TCHAR *pstr = cstr_line.GetBufferSetLength(in_len);
	::SendMessage(m_hWnd, EM_GETLINE, in_line, (LPARAM)pstr);
	cstr_line.ReleaseBufferSetLength(in_len);
	return TRUE;
}

BOOL Cq2chwmEditCtrl::IsEndOfLine(
	int in_line)
{
	if (GetLines() == in_line) return TRUE;
	return FALSE;
}

void Cq2chwmEditCtrl::SetTopLine(
	int in_line)	// \sԍ
{
	//int in_index = ::SendMessage(m_hWnd, EM_LINEINDEX, in_line, 0);
	::SendMessage(m_hWnd, EM_LINESCROLL, 0, in_line - GetTopLine());
	//::SendMessage(m_hWnd, EM_SCROLLCARET, 0, 0);
}

int Cq2chwmEditCtrl::GetTopLine()
{
	return ::SendMessage(m_hWnd, EM_GETFIRSTVISIBLELINE, 0, 0);
}

TCHAR *Cq2chwmEditCtrl::GetLine(
	int in_line)	// \sԍ(0`)
{
	if (in_line < 0) {
		return NULL;
	}
	BUFFER *bf = (BUFFER *)GetWindowLong(m_hWnd, GWL_USERDATA);
	if (bf == NULL) {
		return NULL;
	}

	int in_index;// = ::SendMessage(m_hWnd, EM_LINEINDEX, in_line, 0);
	// ptH[}XAbv̂߃EBhEbZ[WgȂ
	{
		if (in_line < 0 || (unsigned)in_line >= (WPARAM)bf->line_len) {
			return NULL;
		}
		in_index = line_get(bf, in_line);
		if (in_index < 0) {
			return NULL;
		}
	}

	if ((int)bf->buf_len < in_index) {
		return bf->input_buf + (in_index - bf->buf_len);
	}
	return lstrlen(bf->buf) == 0 ? bf->input_buf + in_index : bf->buf + in_index;
}

void Cq2chwmEditCtrl::SetSelection(
	int in_row_s,		// Docsԍ
	int in_row_e,
	int in_col_s,
	int in_col_e)
{
	int in_index_s = ::SendMessage(m_hWnd, EM_LINEINDEX, in_row_s, 0);
	int in_index_e = ::SendMessage(m_hWnd, EM_LINEINDEX, in_row_e, 0);
	::SendMessage(m_hWnd, EM_SETSEL, in_index_s + in_col_s, in_index_e + in_col_e);
}

void Cq2chwmEditCtrl::GetSelection(
	int& in_row_s,
	int& in_row_e,
	int& in_col_s,
	int& in_col_e)
{
	WPARAM wStart;
	LPARAM lEnd;
	::SendMessage(m_hWnd, EM_GETSEL, (WPARAM)&wStart, (LPARAM)&lEnd);
	in_row_s = ::SendMessage(m_hWnd, EM_LINEFROMCHAR, wStart, 0);
	in_row_e = ::SendMessage(m_hWnd, EM_LINEFROMCHAR, lEnd, 0);
	int in_index_s = ::SendMessage(m_hWnd, EM_LINEINDEX, in_row_s, 0);
	in_col_s = wStart - in_index_s;
	int in_index_e = ::SendMessage(m_hWnd, EM_LINEINDEX, in_row_e, 0);
	in_col_e = lEnd - in_index_e;
}

BOOL Cq2chwmEditCtrl::IsVisibleLine(
	int in_line)
{
	int in_topline = ::SendMessage(m_hWnd, EM_GETFIRSTVISIBLELINE, 0, 0);
	RECT rc;
	::GetClientRect(m_hWnd, &rc);
	if (in_line < in_topline || in_line > in_topline + GetVisibleLines()) {
		return FALSE;
	}
	return TRUE;
}

// ʂɕ\Ăs擾
int Cq2chwmEditCtrl::GetVisibleLines()
{
	RECT rc;
	::GetClientRect(m_hWnd, &rc);
	BUFFER *bf;
	::SendMessage(m_hWnd, WM_GETBUFFERINFO, 0, (LPARAM)&bf);
	return m_in_fontsize > 0 ? (rc.bottom - rc.top) / bf->font_height : 0;
}

BOOL Cq2chwmEditCtrl::SearchNext(
	const char *chp_pat,
	BOOL bo_visible)
{
	// ݑIs擾
	int in_selrow_s;
	int in_selrow_e;
	int in_selcol_s;
	int in_selcol_e;
	GetSelection(in_selrow_s, in_selrow_e, in_selcol_s, in_selcol_e);

	// Is猟JnʒuvZ
	int in_search_row;
	int in_search_col;
	if (in_selrow_e == -1 || IsVisibleLine(in_selrow_e) == FALSE) {
		in_search_row = GetTopLine();
		in_search_col = 0;
	} else {
		in_search_row = in_selrow_e;
		in_search_col = in_selcol_e;
	}

	CYoRegex cRegex(chp_pat, CYoRegex::SJIS, TRUE);
	for (int i = in_search_row; i < GetLines(); i++) {
		if (bo_visible == TRUE && IsVisibleLine(i) == FALSE) break;
		CString cstr_line;
		int in_start = i;
		while (i < GetLines()) {
			CString cstr_tmp;
			GetLineString(i, cstr_tmp);
			cstr_line += cstr_tmp;
			if (::SendMessage(m_hWnd, EM_GETLINEEND, i, 0) == TRUE) break;
			i++;
		}
		in_search_col = GetByteLength(cstr_line, in_search_col);
		CYoString str_line = A(cstr_line);
		int in_ret;
		if ((in_ret = cRegex.Match(str_line, in_search_col)) >= 0) {
			int in_end = GetStringLength(str_line, in_ret + strlen(cRegex.Get(0)));
			in_ret = GetStringLength(str_line, in_ret);
			SetSelection(in_start, in_start, in_ret, in_end);
			if (IsVisibleLine(i) == FALSE) {
				SetTopLine(i - GetVisibleLines() + 1);
			}
			::InvalidateRect(m_hWnd, NULL, FALSE);
			return TRUE;
		}
		in_search_col = 0;
	}
	return FALSE;
}

BOOL Cq2chwmEditCtrl::SearchPrev(
	const char *chp_pat,
	BOOL bo_visible)
{
	// ݑIs擾
	int in_selrow_s;
	int in_selrow_e;
	int in_selcol_s;
	int in_selcol_e;
	GetSelection(in_selrow_s, in_selrow_e, in_selcol_s, in_selcol_e);
	if (in_selrow_s == in_selrow_e && in_selcol_s == in_selcol_e) {
		in_selrow_s = -1;
		in_selrow_e = -1;
		in_selcol_s = -1;
		in_selcol_e = -1;
	}

	// Is猟JnʒuvZ
	int in_search_row;
	int in_search_col;
	if (in_selrow_s == -1 || IsVisibleLine(in_selrow_s) == FALSE) {
		in_search_row = GetTopLine() + GetVisibleLines();		// \s̍ŏIs
		in_search_col = -1;						// sS
	} else {
		if (in_selcol_s == 0) {
			in_selrow_s--;
			in_selcol_s = -1;
		}
		in_search_row = in_selrow_s;			// \s
		in_search_col = in_selcol_s;			// s̓r܂
	}

	CYoRegex cRegex(chp_pat, CYoRegex::SJIS, TRUE);
	for (int i = in_search_row; i >= 0; i--) {
		if (bo_visible == TRUE && IsVisibleLine(i) == FALSE) break;
		CString cstr_line;
		while (i >= 0) {
			CString cstr_tmp;
			GetLineString(i, cstr_tmp);
			if (in_selrow_s - 1 == i && in_search_col != -1) {
				// |>>1|ʕ܂Ԃ
				// |>>2@@@@@@@@@@|s
				// ̂ƂɁu>>2vIԂłƂ
				// u>>1vΏۂƂ邽߂̏
				in_search_col = cstr_tmp.GetLength();
			}
			cstr_line = cstr_tmp + cstr_line;
			if (i == 0 || ::SendMessage(m_hWnd, EM_GETLINEEND, i - 1, 0) == TRUE) {
				break;
			}
			i--;
		}
		CYoString str_line = A(cstr_line);
		if (in_search_col != -1) {
			in_search_col = GetByteLength(cstr_line, in_search_col);
			str_line = str_line.Left(in_search_col);
		}
		int in_ret;
		if ((in_ret = cRegex.MatchR(str_line)) >= 0) {
			int in_end = GetStringLength(str_line, in_ret + strlen(cRegex.Get(0)));
			in_ret = GetStringLength(str_line, in_ret);
			SetSelection(i, i, in_ret, in_end);
			if (IsVisibleLine(i) == FALSE) {
				SetTopLine(i);
			}
			::InvalidateRect(m_hWnd, NULL, FALSE);
			return TRUE;
		}
		in_search_col = -1;
	}
	return FALSE;
}

BOOL Cq2chwmEditCtrl::GetSelectedString(
	CString& cstr_text)
{
	WPARAM wStart;
	LPARAM lEnd;
	::SendMessage(m_hWnd, EM_GETSEL, (WPARAM)&wStart, (LPARAM)&lEnd);
	TCHAR *pstr = cstr_text.GetBufferSetLength(lEnd - wStart);
	::SendMessage(m_hWnd, EM_GETSELTEXT, 0, (LPARAM)pstr);
	cstr_text.ReleaseBufferSetLength(lEnd - wStart);
	return TRUE;
}

void Cq2chwmEditCtrl::OnKeyDown(
	UINT nChar,
	UINT nRepCnt,
	UINT nFlags)
{
	::SendMessage(m_hWnd, WM_KEYDOWN, nChar, nRepCnt);
}

void Cq2chwmEditCtrl::Clear()
{
	::SendMessage(m_hWnd, WM_SETTEXT, 0, (LPARAM)TEXT(""));
}

void Cq2chwmEditCtrl::Copy()
{
	::SendMessage(m_hWnd, WM_COPY, 0, 0);
}

void Cq2chwmEditCtrl::ScrollVertical(
	BOOL bo_next,
	int in_num)
{
	// LPARAM͌ݖ
	// IɃXN[ʂwł悤ɂ
	::SendMessage(m_hWnd, WM_VSCROLL, bo_next == TRUE ? SB_LINEDOWN : SB_LINEUP, in_num);
}

void Cq2chwmEditCtrl::ScrollHorizontal(
	BOOL bo_next,
	int in_num)
{
	// LPARAM͌ݖ
	// IɃXN[ʂwł悤ɂ
	::SendMessage(m_hWnd, WM_HSCROLL, bo_next == TRUE ? SB_LINERIGHT : SB_LINELEFT, in_num);
}
