// q2chwmFolderSelector.cpp : t@C
//

#include "stdafx.h"
#include "q2chwm.h"
#include "q2chwmFolderSelector.h"

// Cq2chwmFolderSelector _CAO
IMPLEMENT_DYNAMIC(Cq2chwmFolderSelector, CDialog)

Cq2chwmFolderSelector::Cq2chwmFolderSelector(CWnd* pParent /*=NULL*/)
	: CDialog(Cq2chwmFolderSelector::IDD, pParent)
{
	m_cImageList.Create(32, 32, ILC_COLOR24, 1, 1);
	m_cImageList.SetBkColor(GetSysColor(COLOR_WINDOW));

	// [gtH_ACR擾
	SHFILEINFO shinfo;
	HIMAGELIST hImageList = (HIMAGELIST)::SHGetFileInfo(_T("\\"), 0, &shinfo, sizeof(shinfo),
		SHGFI_DISPLAYNAME|SHGFI_ICON|SHGFI_SMALLICON|SHGFI_SYSICONINDEX);
	if (hImageList != 0) {
		m_cImageList.Add(shinfo.hIcon);
	}
}

Cq2chwmFolderSelector::~Cq2chwmFolderSelector()
{
}

void Cq2chwmFolderSelector::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(Cq2chwmFolderSelector, CDialog)
	ON_NOTIFY(TVN_ITEMEXPANDING, IDC_TREE_FOLDER, &Cq2chwmFolderSelector::OnTvnItemexpandingTreeFolder)
	ON_WM_SIZE()
	ON_COMMAND(ID_MENU_CANCEL, &Cq2chwmFolderSelector::OnMenuCancel)
	ON_COMMAND(ID_MENU_OK, &Cq2chwmFolderSelector::OnMenuOk)
END_MESSAGE_MAP()


// Cq2chwmFolderSelector bZ[W nh

BOOL Cq2chwmFolderSelector::OnInitDialog()
{
	CDialog::OnInitDialog();

	// TODO:  ɏǉĂ
	insertChildItem(_T("\\"), NULL);
	CTreeCtrl *pTree = (CTreeCtrl*)GetDlgItem(IDC_TREE_FOLDER);
	HTREEITEM hItem = pTree->GetRootItem();
	if (hItem != NULL) {
		do {
			CString cstr_path = getPath(hItem);
			insertChildItem(cstr_path, hItem);
		} while ((hItem = pTree->GetNextSiblingItem(hItem)) != NULL);
	}

	pTree->SetImageList(&m_cImageList, TVSIL_NORMAL);

#ifdef WIN32_PLATFORM_PSPC
	if (!m_wndCommandBar.Create(this) ||
	    !m_wndCommandBar.InsertMenuBar(IDR_MENU_DIALOG) ||
	    !m_wndCommandBar.AddAdornments())
	{
		TRACE0("CommandBar ̍쐬Ɏs܂\n");
		return FALSE;
	}
	m_wndCommandBar.SetBarStyle(m_wndCommandBar.GetBarStyle() | CBRS_SIZE_FIXED);
#endif // WIN32_PLATFORM_PSPC

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

CString Cq2chwmFolderSelector::getPath(
	HTREEITEM hItem)
{
	CTreeCtrl *pTree = (CTreeCtrl*)GetDlgItem(IDC_TREE_FOLDER);
	CString cstr_ret;
	do {
		cstr_ret = pTree->GetItemText(hItem) + _T("\\") + cstr_ret;
	} while ((hItem = pTree->GetParentItem(hItem)) != NULL);
	cstr_ret = _T("\\") + cstr_ret;
	return cstr_ret;
}

void Cq2chwmFolderSelector::deleteChildItem(
	HTREEITEM hItem)
{
	CTreeCtrl *pTree = (CTreeCtrl*)GetDlgItem(IDC_TREE_FOLDER);
	HTREEITEM hChildItem;
	while ((hChildItem = pTree->GetChildItem(hItem)) != NULL) {
		pTree->DeleteItem(hChildItem);
	}
}

void Cq2chwmFolderSelector::insertChildItem(
	CString cstr_path,
	HTREEITEM hItem)
{
	CTreeCtrl *pTree = (CTreeCtrl*)GetDlgItem(IDC_TREE_FOLDER);
	WIN32_FIND_DATA st_find;
	HANDLE hFind;

	cstr_path += _T("*");
	hFind = ::FindFirstFile(cstr_path, &st_find);
	if (hFind != INVALID_HANDLE_VALUE) {
		do {
			if (wcscmp(st_find.cFileName, _T(".")) == 0 || wcscmp(st_find.cFileName, _T("..")) == 0) continue;
			if (st_find.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) {
				pTree->InsertItem(TVIF_PARAM|TVIF_TEXT, st_find.cFileName, -1, -1, 0, 0, (LPARAM)NULL, hItem, NULL);
			}
		} while (FindNextFile(hFind, &st_find));
		::FindClose(hFind);
	}
}

void Cq2chwmFolderSelector::OnTvnItemexpandingTreeFolder(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMTREEVIEW pNMTreeView = reinterpret_cast<LPNMTREEVIEW>(pNMHDR);
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	if (pNMTreeView->action == 2) {
		CTreeCtrl *pTree = (CTreeCtrl*)GetDlgItem(IDC_TREE_FOLDER);
		HTREEITEM hItem = pTree->GetChildItem(pNMTreeView->itemNew.hItem);
		if (hItem != NULL) {
			do {
				if ((pTree->GetItemState(hItem, TVIF_STATE) & TVIS_EXPANDED) == 0) {
					CString cstr_path = getPath(hItem);
					deleteChildItem(hItem);
					insertChildItem(cstr_path, hItem);
				}
			} while ((hItem = pTree->GetNextSiblingItem(hItem)) != NULL);
		}
	}
	*pResult = 0;
}

void Cq2chwmFolderSelector::OnOK()
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	CTreeCtrl *pTree = (CTreeCtrl*)GetDlgItem(IDC_TREE_FOLDER);
	HTREEITEM hItem = pTree->GetSelectedItem();
	if (hItem != NULL) {
		CString cstr_path = getPath(hItem);
		m_str_path = A(cstr_path);
	}

	CDialog::OnOK();
}

void Cq2chwmFolderSelector::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B
	if (GetDlgItem(IDC_TREE_FOLDER) != NULL) {
		GetDlgItem(IDC_TREE_FOLDER)->MoveWindow(0, 0, cx, cy, TRUE);
	}
}

void Cq2chwmFolderSelector::OnMenuCancel()
{
	// TODO: ɃR}h nh R[hǉ܂B
	OnCancel();
}

void Cq2chwmFolderSelector::OnMenuOk()
{
	// TODO: ɃR}h nh R[hǉ܂B
	OnOK();
}
