#include "stdafx.h"
#include "YoFile.h"
#include "YoRegex.h"
#include "YoTime.h"
#include "q2chwmInfoFile.h"

enum{
	IDX_INFO_CACHE = 0
};

Cq2chwmInfoFile::Cq2chwmInfoFile()
{
	Clear();
}

Cq2chwmInfoFile::~Cq2chwmInfoFile()
{
}

BOOL Cq2chwmInfoFile::Exist(
	const char *chp_burl,
	const char *chp_aid)
{
	CYoString str_filename = UrlToPath(chp_burl);
	str_filename += "\\info\\";
	str_filename += chp_aid;
	return ExistFile(str_filename);
}

#define PAT_INFO_NUMBER		"\\(number . ([0-9]+)\\)"
#define PAT_INFO_NAME		"\\(name . \"((\\\\\"|[^\"])+)\"\\)"
#define PAT_INFO_DATE		"\\(time . \"([^\"]+)\"\\)"
#define PAT_INFO_MAIL		"\\(mail . \"((\\\\\"|[^\"])+)\"\\)"
#define PAT_INFO_HIDE		"\\(hide ([^\\)]+)\\)"
#define PAT_INFO_IMPORTANT	"\\(important ([^\\)]+)\\)"
#define PAT_INFO_NEW		"\\(new ([^\\)]+)\\)"
#define PAT_INFO_COUNT		"\\(count ([^\\)]+)\\)"
BOOL Cq2chwmInfoFile::Create(
	const char *chp_burl,
	const char *chp_aid)
{
	CYoTime cTime;
	m_str_filename = UrlToPath(chp_burl);
	m_str_filename += "\\info\\";
	m_str_filename += chp_aid;
	CYoTextFile cFile(m_str_filename, CYoFile::READ);
	if (cFile.Open() == FALSE) {
		PRINTLOG("error %s(%d)", (const char*)m_str_filename, ::GetLastError());
		return FALSE;
	}

	CYoString str_line;
	cFile.ReadLine(str_line);
	const char *chp_line = str_line;

	CYoRegex cRegex;
	if( cRegex.Match( PAT_INFO_NUMBER, chp_line ) >= 0 ){
		m_in_number = atoi( cRegex.Get(1) );
	}

	if( cRegex.Match( PAT_INFO_NAME, chp_line ) >= 0 ){
		m_bl_name = TRUE;
		m_str_name = cRegex.Get(1);
		m_str_name.Replace( "\\\"", "\"" );
	}

	if( cRegex.Match( PAT_INFO_DATE, chp_line ) >= 0 ){
		m_bl_date = TRUE;
		m_str_date = cRegex.Get(1);
	}

	if( cRegex.Match( PAT_INFO_MAIL, chp_line ) >= 0 ){
		m_bl_mail = TRUE;
		m_str_mail = cRegex.Get(1);
		m_str_mail.Replace( "\\\"", "\"" );
	}

	if (cRegex.Match(PAT_INFO_HIDE, chp_line) >= 0) {
		CYoDataArray cArray = CYoDataArray::CreateStringArray(cRegex.Get(1), " ");
		for (int i = 0; i < cArray.Count(); i++) {
			m_cHideArray.Add(atoi(cArray.Get(i)));
		}
	}

	if (cRegex.Match(PAT_INFO_IMPORTANT, chp_line) >= 0) {
		CYoDataArray cArray = CYoDataArray::CreateStringArray(cRegex.Get(1), " ");
		for (int i = 0; i < cArray.Count(); i++) {
			m_cImportantArray.Add(atoi(cArray.Get(i)));
		}
	}

	if (cRegex.Match(PAT_INFO_NEW, chp_line) >= 0) {
		m_bo_new = atoi(cRegex.Get(1)) == 1 ? TRUE : FALSE;
	} else {
		m_bo_new = FALSE;
	}

	if (cRegex.Match(PAT_INFO_COUNT, chp_line) >= 0) {
		m_in_count = atoi(cRegex.Get(1));
	} else {
		m_in_count = 0;
	}

	cFile.Close();
	PRINTLOG("done [%s][%s]%d(msec)", chp_burl, chp_aid, cTime.Elapsed());
	return TRUE;
}

#define FORMAT_NUMBER	"((number . %d) "
#define FORMAT_NAME		"(name . \"%s\") "
#define FORMAT_DATE		"(time . \"%s\") "
#define FORMAT_MAIL		"(mail . \"%s\") "
#define FORMAT_HIDE		"(hide %s) "
#define FORMAT_IMPORTANT	"(important %s) "
#define FORMAT_NEW			"(new %d) "
#define FORMAT_COUNT		"(count %d) "
int Cq2chwmInfoFile::Write()
{
	// fBNg쐬
	CYoString str_dir = GetBaseName(m_str_filename);
	MakeDirectory(str_dir);

	CYoString str_info;

	// OɌĂbZ[Wԍ
	str_info.FormatAdd(FORMAT_NUMBER, m_in_number);

	// Oɏ񂾖O
	if( m_bl_name == FALSE ){
		str_info += "nil ";
	}else{
		str_info.FormatAdd(FORMAT_NAME, (char*)m_str_name);
	}

	// Oɏ񂾓tH
	if (m_bl_date == FALSE) {
		str_info += "nil ";
	} else {
		str_info.FormatAdd(FORMAT_DATE, (char*)m_str_date);
	}

	// hide
	if (m_cHideArray.Count() == 0) {
		str_info += "nil ";
	} else {
		CYoString str_hide;
		for (int i = 0; i < m_cHideArray.Count(); i++) {
			if (i == 0) {
				str_hide = (int)m_cHideArray.Get(i);
			} else {
				str_hide.FormatAdd(" %d", m_cHideArray.Get(i));
			}
		}
		str_info.FormatAdd(FORMAT_HIDE, (const char*)str_hide);
	}

	// important
	if (m_cImportantArray.Count() == 0) {
		str_info += "nil ";
	} else {
		CYoString str_important;
		for (int i = 0; i < m_cImportantArray.Count(); i++) {
			if (i == 0) {
				str_important = (int)m_cImportantArray.Get(i);
			} else {
				str_important.FormatAdd(" %d", m_cImportantArray.Get(i));
			}
		}
		str_info.FormatAdd(FORMAT_IMPORTANT, (const char*)str_important);
	}

	// Oɏ񂾃[AhX
	if (m_bl_mail == FALSE) {
		str_info += "nil ";
	} else {
		str_info.FormatAdd(FORMAT_MAIL, (char*)m_str_mail);
	}

	if (m_bo_new == FALSE) {
		str_info += "nil ";
	} else {
		str_info.FormatAdd(FORMAT_NEW, m_bo_new);
	}

	if (m_in_count == 0) {
		str_info += "nil ";
	} else {
		str_info.FormatAdd(FORMAT_COUNT, m_in_count);
	}

	// H
	str_info += "nil)";

	CFile cFile;
	CString cstr_filename;
	cstr_filename = m_str_filename;
	if (cFile.Open(cstr_filename, CFile::modeWrite|CFile::modeCreate) == FALSE) {
		return FALSE;
	}
	cFile.Write((const char*)str_info, str_info.Length());
	cFile.Close();

	return TRUE;
}

const char* Cq2chwmInfoFile::GetName()
{
	if( m_bl_name == FALSE ) return NULL;
	return m_str_name;
}

const char* Cq2chwmInfoFile::GetDate()
{
	if( m_bl_date == FALSE ) return NULL;
	return m_str_date;
}

const char* Cq2chwmInfoFile::GetMail()
{
	if( m_bl_mail == FALSE ) return NULL;
	return m_str_mail;
}

void Cq2chwmInfoFile::Clear()
{
	m_in_number = 0;
	m_bl_name = FALSE;
	m_bl_date = FALSE;
	m_bl_mail = FALSE;
	m_str_name = "";
	m_str_date = "";
	m_str_mail = "";
	m_cHideArray.RemoveAll();
	m_cImportantArray.RemoveAll();
	m_bo_new = FALSE;
	m_in_count = 0;
}

BOOL Cq2chwmInfoFile::RemoveHideMessage(
	int in_number)
{
	for (int i = 0; i < m_cHideArray.Count(); i++) {
		if (in_number == (int)m_cHideArray.Get(i)) {
			m_cHideArray.Remove(i);
			return TRUE;
		}
	}
	return FALSE;
}

BOOL Cq2chwmInfoFile::RemoveImportantMessage(
	int in_number)
{
	for (int i = 0; i < m_cImportantArray.Count(); i++) {
		if (in_number == (int)m_cImportantArray.Get(i)) {
			m_cImportantArray.Remove(i);
			return TRUE;
		}
	}
	return FALSE;
}

int Cq2chwmInfoFile::Count(
	const char *chp_burl,
	const char *chp_aid)
{
	Cq2chwmInfoFile cInfo;
	cInfo.Create(chp_burl, chp_aid);
	return cInfo.GetCount();
}
