// q2chwmPageKey.cpp : t@C
//

#include "stdafx.h"
#include "q2chwm.h"
#include "q2chwmPageKey.h"
#include "q2chwmLayoutManager.h"

// Cq2chwmPageKey _CAO

IMPLEMENT_DYNAMIC(Cq2chwmPageKey, CDialog)

Cq2chwmPageKey::Cq2chwmPageKey(CWnd* pParent /*=NULL*/)
	: Cq2chwmConfigPage(Cq2chwmPageKey::IDD, pParent)
{

}

Cq2chwmPageKey::~Cq2chwmPageKey()
{
}

void Cq2chwmPageKey::DoDataExchange(CDataExchange* pDX)
{
	Cq2chwmConfigPage::DoDataExchange(pDX);
}


BEGIN_MESSAGE_MAP(Cq2chwmPageKey, Cq2chwmConfigPage)
	ON_WM_SIZE()
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_LIST, &Cq2chwmPageKey::OnLvnItemchangedList)
	ON_BN_CLICKED(IDC_BUTTON_DISABLE, &Cq2chwmPageKey::OnBnClickedButtonDisable)
	ON_BN_CLICKED(IDC_BUTTON_SUBDISABLE, &Cq2chwmPageKey::OnBnClickedButtonSubDisable)
END_MESSAGE_MAP()


// Cq2chwmPageKey bZ[W nh

void Cq2chwmPageKey::OnSize(UINT nType, int cx, int cy)
{
	CDialog::OnSize(nType, cx, cy);

	// TODO: ɃbZ[W nh R[hǉ܂B
	Cq2chwmLayoutManager cLayout(
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_KEYNAME), 1, GetDlgItem(IDC_EDIT_KEYCODE), 1, GetDlgItem(IDC_BUTTON_DISABLE), 1),
		new Cq2chwmLayoutLine(GetDlgItem(IDC_STATIC_KEYSUBNAME), 1, GetDlgItem(IDC_EDIT_KEYSUBCODE), 1, GetDlgItem(IDC_BUTTON_SUBDISABLE), 1),
		new Cq2chwmLayoutLine(5, GetDlgItem(IDC_LIST), 1)
	);
	cLayout.Layout(cx, cy);

	CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
	if (pList != NULL) {
		pList->SetColumnWidth(0, cx / 3);
		pList->SetColumnWidth(1, cx / 3);
		pList->SetColumnWidth(2, cx / 3);
	}
}

void Cq2chwmPageKey::Write()
{
	Cq2chwmConfig::GetInstance()->SetConfigKey(m_cConfigKey);
}

BOOL Cq2chwmPageKey::OnInitDialog()
{
	Cq2chwmConfigPage::OnInitDialog();

	// TODO:  ɏǉĂ
	CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
	pList->SetExtendedStyle(LVS_EX_FULLROWSELECT);
	pList->InsertColumn(0, _T("@\"));
	pList->InsertColumn(1, _T("L[1"));
	pList->InsertColumn(2, _T("L[2"));
	for (int i = 0; i < m_cConfigKey.Count(); i++) {
		CString cstr_tmp;
		cstr_tmp = m_cConfigKey.GetName(i);
		pList->InsertItem(i, cstr_tmp);
		cstr_tmp = m_cConfigKey.GetCodeName(m_cConfigKey.GetCode(i));
		pList->SetItemText(i, 1, cstr_tmp);
		cstr_tmp = m_cConfigKey.GetCodeName(m_cConfigKey.GetSubCode(i));
		pList->SetItemText(i, 2, cstr_tmp);
	}

	return TRUE;  // return TRUE unless you set the focus to a control
	// O : OCX vpeB y[W͕K FALSE Ԃ܂B
}

BOOL Cq2chwmPageKey::OnChildNotify(UINT message, WPARAM wParam, LPARAM lParam, LRESULT* pLResult)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB

	return Cq2chwmConfigPage::OnChildNotify(message, wParam, lParam, pLResult);
}

BOOL Cq2chwmPageKey::PreTranslateMessage(MSG* pMsg)
{
	// TODO: ɓȃR[hǉ邩A͊{NXĂяoĂB
	CEdit *pEdit = (CEdit*)GetDlgItem(IDC_EDIT_KEYCODE);
	CEdit *pEditSub = (CEdit*)GetDlgItem(IDC_EDIT_KEYSUBCODE);
	CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
	POSITION pos = pList->GetFirstSelectedItemPosition();
	if (pos != NULL && pEdit->m_hWnd == pMsg->hwnd && pMsg->message == WM_KEYDOWN && pMsg->wParam != 13) {
		// C
		int in_index = (int)pos - 1;
		setCode(in_index, pMsg->wParam);
		return TRUE;
	} else if (pos != NULL && pEditSub->m_hWnd == pMsg->hwnd && pMsg->message == WM_KEYDOWN && pMsg->wParam != 13) {
		// Tu
		int in_index = (int)pos - 1;
		setSubCode(in_index, pMsg->wParam);
		return TRUE;
	}

	return Cq2chwmConfigPage::PreTranslateMessage(pMsg);
}

void Cq2chwmPageKey::OnLvnItemchangedList(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMLISTVIEW pNMLV = reinterpret_cast<LPNMLISTVIEW>(pNMHDR);
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
	POSITION pos = pList->GetFirstSelectedItemPosition();
	if (pos != NULL) {
		int in_index = (int)pos - 1;

		// C
		{
			CEdit *pEdit = (CEdit*)GetDlgItem(IDC_EDIT_KEYCODE);
			CString cstr_code;
			cstr_code.Format(_T("%d"), m_cConfigKey.GetCode(in_index));
			pEdit->SetWindowTextW(cstr_code);

			CStatic *pStatic = (CStatic*)GetDlgItem(IDC_STATIC_KEYNAME);
			CString cstr_name;
			cstr_name = m_cConfigKey.GetCodeName(m_cConfigKey.GetCode(in_index));
			pStatic->SetWindowText(cstr_name);
		}

		// Tu
		{
			CEdit *pEdit = (CEdit*)GetDlgItem(IDC_EDIT_KEYSUBCODE);
			CString cstr_code;
			cstr_code.Format(_T("%d"), m_cConfigKey.GetSubCode(in_index));
			pEdit->SetWindowTextW(cstr_code);

			CStatic *pStatic = (CStatic*)GetDlgItem(IDC_STATIC_KEYSUBNAME);
			CString cstr_name;
			cstr_name = m_cConfigKey.GetCodeName(m_cConfigKey.GetSubCode(in_index));
			pStatic->SetWindowText(cstr_name);
		}
	}

	*pResult = 0;
}

void Cq2chwmPageKey::OnBnClickedButtonDisable()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
	POSITION pos = pList->GetFirstSelectedItemPosition();
	if (pos != NULL) {
		// C
		int in_index = (int)pos - 1;
		setCode(in_index, 0);
	}
}

void Cq2chwmPageKey::OnBnClickedButtonSubDisable()
{
	// TODO: ɃRg[ʒmnh R[hǉ܂B
	CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
	POSITION pos = pList->GetFirstSelectedItemPosition();
	if (pos != NULL) {
		// C
		int in_index = (int)pos - 1;
		setSubCode(in_index, 0);
	}
}

void Cq2chwmPageKey::setCode(
	int in_index,
	unsigned char uc_code)
{
	if (in_index >= m_cConfigKey.Count()) return;
	m_cConfigKey.SetCode(in_index, uc_code);
	CString cstr_code;
	cstr_code.Format(_T("%d"), uc_code);
	CEdit *pEdit = (CEdit*)GetDlgItem(IDC_EDIT_KEYCODE);
	if (pEdit == NULL) return;
	pEdit->SetWindowText(cstr_code);

	CStatic *pStatic = (CStatic*)GetDlgItem(IDC_STATIC_KEYNAME);
	if (pStatic == NULL) return;
	CString cstr_name;
	cstr_name = m_cConfigKey.GetCodeName(m_cConfigKey.GetCode(in_index));
	pStatic->SetWindowText(cstr_name);

	CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
	if (pList == NULL) return;
	pList->SetItemText(in_index, 1, cstr_name);
}

void Cq2chwmPageKey::setSubCode(
	int in_index,
	unsigned char uc_code)
{
	if (in_index >= m_cConfigKey.Count()) return;
	m_cConfigKey.SetSubCode(in_index, uc_code);
	CString cstr_code;
	cstr_code.Format(_T("%d"), uc_code);
	CEdit *pEdit = (CEdit*)GetDlgItem(IDC_EDIT_KEYSUBCODE);
	if (pEdit == NULL) return;
	pEdit->SetWindowText(cstr_code);

	CStatic *pStatic = (CStatic*)GetDlgItem(IDC_STATIC_KEYSUBNAME);
	if (pStatic == NULL) return;
	CString cstr_name;
	cstr_name = m_cConfigKey.GetCodeName(m_cConfigKey.GetSubCode(in_index));
	pStatic->SetWindowText(cstr_name);

	CListCtrl *pList = (CListCtrl*)GetDlgItem(IDC_LIST);
	if (pList == NULL) return;
	pList->SetItemText(in_index, 2, cstr_name);
}
