#include "StdAfx.h"
#include "q2chwmListItem.h"
#include "q2chwmCommon.h"

Cq2chwmListItem::Cq2chwmListItem(
	int in_index,
	const char *chp_aname,
	const char *chp_aid,
	const char *chp_bname,
	const char *chp_bid,
	const char *chp_burl) :
	m_str_aname(chp_aname),
	m_str_aid(chp_aid),
	m_str_bname(chp_bname),
	m_str_burl(chp_burl),
	m_str_bid(chp_bid)
{
	m_in_index = in_index;
	m_bo_cache = FALSE;
	m_bo_new = FALSE;
	m_bo_search = FALSE;
	m_bo_error = FALSE;
	HtmlToText(m_str_aname);
	HtmlToText(m_str_bname);
}

Cq2chwmListItem::~Cq2chwmListItem(void)
{
}

const char *Cq2chwmListItem::GetFileName()
{
	if (m_str_filename.Length() == 0) {
		m_str_filename = UrlToPath(m_str_burl);
		m_str_filename += "\\" + m_str_aid + ".dat";
	}
	return m_str_filename;
}

const char *Cq2chwmListItem::GetArticleUrl()
{
	if (m_str_aurl.Length() == 0) {
		m_str_aurl = m_str_burl + m_str_aid;
	}
	return m_str_aurl;
}
