#include "StdAfx.h"
#include "YoConfig.h"
#include "q2chwmBookmarkItem.h"
#include "q2chwmDatFile.h"
#include "q2chwmCommon.h"
#include "q2chwmInfoFile.h"

Cq2chwmBookmarkItem::Cq2chwmBookmarkItem(
	int in_index,
	const char *chp_aname,
	const char *chp_aid,
	const char *chp_bname,
	const char *chp_bid,
	const char *chp_burl,
	int in_count) : Cq2chwmListItem(in_index, chp_aname, chp_aid, chp_bname, chp_bid, chp_burl)
{
	m_cInfo.Create(GetBoardUrl(), GetArticleId());
	memset(&m_st_modify, 0x00, sizeof(m_st_modify));

	// infot@CVtOAX擾
	refresh();

	if (in_count != -1) {
		// ^Ă炻D悷
		m_in_count = in_count;
	}
}

Cq2chwmBookmarkItem::~Cq2chwmBookmarkItem()
{
}

void Cq2chwmBookmarkItem::refresh()
{
	FILETIME st_modify;
	ULONGLONG ull_length;
	if (ExistFile(m_cInfo.GetFileName(), &ull_length, &st_modify) == FALSE || ull_length == 0) {
		// t@CȂ
		memset(&m_st_modify, 0x00, sizeof(m_st_modify));
		SetNew(FALSE);
		m_in_count = 0;
		m_in_count_new = 0;
	} else if (memcmp(&m_st_modify, &st_modify, sizeof(m_st_modify)) == 0) {
		// t@CXVtɕύXȂVtO擾Ȃ
	} else {
		// t@CXVtɕύXAs𐔂
		memcpy(&m_st_modify, &st_modify, sizeof(m_st_modify));
		m_cInfo.Create(GetBoardUrl(), GetArticleId());
		SetNew(m_cInfo.GetNew());
		m_in_count = m_cInfo.GetCount();

		// ǌvZ
		if (GetNew() == TRUE) {
			m_in_count_new = m_in_count - m_cInfo.GetMax();
			if (m_in_count_new < 0) m_in_count_new = 0;
		} else {
			m_in_count_new = 0;
		}
	}
}

BOOL Cq2chwmBookmarkItem::GetNew()
{
	return Cq2chwmListItem::GetNew();
}

int Cq2chwmBookmarkItem::GetCount()
{
	return m_in_count;
}

int Cq2chwmBookmarkItem::GetCountNew()
{
	return m_in_count_new;
}

int Cq2chwmBookmarkItem::GetState()
{
	int in_state = Cq2chwmListItem::STATE_NORMAL;
	if (GetNew() == TRUE) in_state |= Cq2chwmListItem::STATE_NEW;
	if (m_bo_running == TRUE) in_state |= Cq2chwmListItem::STATE_NETWORK;
	return in_state;
}
