#pragma once

#include "q2chwmEditCtrl.h"
#include "q2chwmMessage.h"
#include "q2chwmInfoFile.h"

class Cq2chwmDatCtrl
{
private:
	CWnd *m_pMain;
	CWnd *m_pParent;
	Cq2chwmEditCtrl m_cEdit;
	CYoString m_str_aname;
	CYoString m_str_aurl;
	CYoString m_str_aid;
	CYoString m_str_bname;
	CYoString m_str_burl;
	CYoString m_str_bid;
	CYoString m_str_url;					// DATURL
	CYoString m_str_filename;
	CYoPtrArray m_cArrayFromLine;
	CYoPtrArray m_cArrayJumpHistory;
	Cq2chwmInfoFile m_cInfo;
	BOOL m_bo_running;
	int m_in_width;
	CYoString m_str_err;
	CYoString m_str_font_name;			// tHgύXꂽcreateIndexs
	int m_in_font_size;					// tHgύXꂽcreateIndexs
	BOOL m_bo_font_bold;				// tHgύXꂽcreateIndexs
	CYoRegex *m_pRegex;
	BOOL m_bo_transparentabone;			// ځ[ȂTRUE
	int m_in_line_max;					// {ős
	CMapStringToPtr m_cMapId;			// ID̏o񐔂ێnbV}bv(L[=ID l=o)
	CMapStringToPtr m_cMapRefer;		// 탌XLێnbV}bv(L[=Xԍ l=1)

private:
	void createIndex(int in_line = 0);
	int CreateFromFile();
	BOOL isAboneLine(int in_line);
	static BOOL DrawProc(HWND hWnd, HDC hDC, int in_left, int in_top, RECT *rect, const TCHAR *lpszText, int in_len, BOOL sel, const void *vop_user);
	static BOOL GetColorProc(int in_id, COLORREF *color, const void *vop_user);
	static BOOL BeforeWindowProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam, const void *vop_user);
	static BOOL AfterWindowProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam, const void *vop_user);

public:
	Cq2chwmDatCtrl(CWnd *pParent, CWnd *pMain);
	~Cq2chwmDatCtrl();

	// Cxg
	void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
	void OnCustomMessage(Cq2chwmMessage *pMessage);
	BOOL OnLButtonUp(WPARAM wParam, LPARAM lParam);

	// oϐANZX
	inline const char *GetBoardName(){ return m_str_bname; }
	inline const char *GetBoardUrl(){ return m_str_burl; }
	inline const char *GetBoardId(){ return m_str_bid; }
	inline const char *GetArticleName(){ return m_str_aname; }
	inline const char *GetArticleUrl(){ return m_str_aurl; }
	inline const char *GetArticleId(){ return m_str_aid; }
	inline const char *GetFileName(){ return m_str_filename; }
	inline BOOL IsRunning(){ return m_bo_running; }

	// EBhE
	int Create(const char *chp_aname, const char *chp_aid, const char *chp_bname, const char *chp_burl, const char *chp_bid);
	int CreateFromHttp();
	BOOL MoveWindow(int x, int y, int cx, int cy);
	BOOL ShowWindow(int in_cmd);
	void Copy();
	int Reload();
	LRESULT SendMessage(int msg, WPARAM wParam = 0, LPARAM lParam = 0);

	// \n
	void SetFont(const char *chp_name, int in_size, BOOL bo_bold);
	BOOL ResetNewKey();
	void SetWrap(BOOL bo_wrap);
	BOOL GetWrap();
	void SetTransParentAbone(BOOL bo_flg);
	BOOL GetTransParentAbone();

	// ړn
	BOOL JumpNextMessage();
	BOOL JumpPrevMessage();
	void JumpFirstMessage();
	void JumpLastMessage();
	void JumpNextLink();
	void JumpPrevLink();
	void JumpNextLine(BOOL bo_link = TRUE);
	void JumpPrevLine(BOOL bo_link = TRUE);
	void Jump(LPCTSTR lpszLink = NULL);
	void JumpBack();
	void JumpNumber(int in_number);
	void JumpUrl(const char *chp_url);
	BOOL SearchNext(const char *chp_pat){ return m_cEdit.SearchNext(chp_pat); }
	BOOL SearchPrev(const char *chp_pat){ return m_cEdit.SearchPrev(chp_pat); }

	// bZ[Wn
	int GetMessageCount(){ return m_cArrayFromLine.Count(); }
	int GetCurrentMessageNumber();
	BOOL GetSelectedString(CString& str_text);
	void GetCurrentMessageText(CString& str_text, BOOL bo_all = FALSE, BOOL bo_ext = FALSE);
	void Clear();
	const char *GetErrorMessage(){ return m_str_err; }
	int GetLastMessageNumber();
	int GetFirstMessageNumber();
	BOOL GetMessageId(int in_number, CString& str_id);
	BOOL GetMessageName(int in_number, CString& str_name);
	void GetMessageText(int in_number, CString& str_text, BOOL bo_all = FALSE, BOOL bo_ext = FALSE);
	void SetText(const char *chp_text){ m_cEdit.SetText(chp_text); }
	void SetText(const wchar_t *wchp_text){ m_cEdit.SetText(wchp_text); }
	void CopyMessage(int in_number);
	void CopyMessageAll();
	int GetMessageNumber(int in_line);

	// Infot@CANZX
	void SetName(const char *chp_name){ m_cInfo.SetName(chp_name); }
	void SetMail(const char *chp_mail){ m_cInfo.SetMail(chp_mail); }
	const char *GetName(){ return m_cInfo.GetName(); }
	const char *GetMail(){ return m_cInfo.GetMail(); }
	BOOL Write(BOOL bo_force = FALSE);
	void Delete();

	// o
	BOOL GrepRefer(int in_number);
	BOOL GrepId(LPCTSTR lpszId);
	BOOL GrepName(LPCTSTR lpszName);
};
