#include "stdafx.h"
#include "q2chwmDoLib.h"
#include "YoHttpClient.h"
#include "YoCommon.h"
#include "q2chwmCommon.h"
#include "q2chwmConfig.h"

BOOL Cq2chwmDoLib::GetSid(
	CYoString &str_sid,
	const char *chp_id,
	const char *chp_pw)
{
	CYoString str_ret;
	CYoHttpClient cHttp("https://2chv.tora3.net/futen.cgi");
	cHttp.SetUserAgent("DOLIB/1.00");
	if (Cq2chwmConfig::GetInstance()->GetProxyUse() == TRUE) {
		cHttp.SetProxy(Cq2chwmConfig::GetInstance()->GetProxyHost(), Cq2chwmConfig::GetInstance()->GetProxyPort());
		cHttp.SetProxyAuth(Cq2chwmConfig::GetInstance()->GetProxyId(), Cq2chwmConfig::GetInstance()->GetProxyPass());
	}
	cHttp.AddRequestHeader("X-2ch-UA", APP_NAME"/"APP_VERSION);
	cHttp.SetParameter("ID", chp_id);
	cHttp.SetParameter("PW", chp_pw);

	if (cHttp.Connect() == FALSE) {
		return FALSE;
	}
	if (cHttp.Post() == FALSE) {
		return FALSE;
	}
	char cha_buff[256];
	int in_size;
	while ((in_size = cHttp.Recv(cha_buff, sizeof(cha_buff) - 1)) > 0){
		cha_buff[in_size] = 0x00;
		str_ret += cha_buff;
	}

	// SESSION-ID=[User-Agent]:[SessionId]`̕p[X
	char *chp_tmp = str_ret;
	chp_tmp = strchr(chp_tmp, '=');
	if (chp_tmp == NULL) {
		return FALSE;
	}
	chp_tmp += 1;
	while (*(chp_tmp + strlen(chp_tmp) - 1) == '\r' || *(chp_tmp + strlen(chp_tmp) - 1) == '\n') {
		*(chp_tmp + strlen(chp_tmp) - 1) = 0x00;
	}

	{
		CYoString str_ua;
		CYoString str_id;
		if (ParseSid(str_ua, str_id, chp_tmp) == FALSE) {
			return FALSE;
		}
	}
	str_sid = chp_tmp;

	return TRUE;
}

BOOL Cq2chwmDoLib::ParseSid(
	CYoString &str_ua,
	CYoString &str_id,
	const char *chp_ua_and_sid)
{
	CYoString str_tmp = chp_ua_and_sid;
	char *chp_ret = (char*)str_tmp;
	char *chp_tmp = strchr(chp_ret, ':');
	if (chp_tmp == NULL) {
		return FALSE;
	}
	*chp_tmp = 0x00;
	if (strcmp( chp_ret, "ERROR" ) == 0) {
		return FALSE;
	}
	str_ua = chp_ret;
	str_id = chp_tmp + 1;
	return TRUE;
}
