#include "StdAfx.h"
#include "YoRegex.h"
#include "q2chwm.h"
#include "q2chwmBoardView.h"
#include "q2chwmDatFile.h"
#include "q2chwmBookmarkBoardFile.h"
#include "q2chwmConfig.h"
#include "q2chwmCommon.h"

Cq2chwmBookmarkBoardFile::Cq2chwmBookmarkBoardFile(void)
{
}

Cq2chwmBookmarkBoardFile::~Cq2chwmBookmarkBoardFile(void)
{
}

void Cq2chwmBookmarkBoardFile::RemoveAll()
{
	for (int i = 0; i < Count(); i++) {
		Cq2chwmBookmarkBoardItem *pItem = GetItem(i);
		delete pItem;
	}
	CYoPtrArray::RemoveAll();
}

int Cq2chwmBookmarkBoardFile::Create()
{
	Cq2chwmBoardFileEtc cBoardFileEtc;
	cBoardFileEtc.CreateFromFile();
	for (int i = 0; i < cBoardFileEtc.Rows(); i++) {
		addItem(i, cBoardFileEtc.GetBoardName(i), cBoardFileEtc.GetBoardId(i), cBoardFileEtc.GetBoardUrl(i));
	}
	return TRUE;
}

BOOL Cq2chwmBookmarkBoardFile::AddItem(
	const char *chp_bname,
	const char *chp_bid,
	const char *chp_burl)
{
	return addItem(0, chp_bname, chp_bid, chp_burl);
}

BOOL Cq2chwmBookmarkBoardFile::addItem(
	int in_index,
	const char *chp_bname,
	const char *chp_bid,
	const char *chp_burl)
{
	// ǉACeȍ~NoCNg
	for (int i = 0; i < Count(); i++) {
		Cq2chwmBookmarkBoardItem *pItem = GetItem(i);
		if (pItem->GetIndex() >= in_index + 1) {
			pItem->SetIndex(pItem->GetIndex() + 1);
		}
	}

	// ACeǉ
	Cq2chwmBookmarkBoardItem *pItem = new Cq2chwmBookmarkBoardItem(in_index + 1, chp_bname, chp_bid, chp_burl);
	Insert(in_index, pItem);

	return TRUE;
}

void Cq2chwmBookmarkBoardFile::Sort(
	int in_col,
	BOOL bo_asc)
{
	if (bo_asc == TRUE) {
		CYoPtrArray::Sort(Cq2chwmBookmarkBoardFile::compAsc, (const void*)in_col);
	} else {
		CYoPtrArray::Sort(Cq2chwmBookmarkBoardFile::compDesc, (const void*)in_col);
	}
}

int Cq2chwmBookmarkBoardFile::compAsc(
	const void *vop_user,
	const void *a,
	const void *b)
{
	int in_col = (int)vop_user;
	Cq2chwmBookmarkBoardItem *aa;
	Cq2chwmBookmarkBoardItem *bb;
	memcpy(&aa, (const void*)a, sizeof(Cq2chwmBookmarkBoardItem*));
	memcpy(&bb, (const void*)b, sizeof(Cq2chwmBookmarkBoardItem*));
	switch (in_col) {
	case IDX_INDEX:
		return aa->GetIndex() > bb->GetIndex() ? 1 : -1;
	case IDX_BNAME:
		return strcmp(aa->GetBoardName(), bb->GetBoardName());
	case IDX_BID:
		return strcmp(aa->GetBoardId(), bb->GetBoardId());
	case IDX_SEARCH:
		// tO, NoŃ\[g
		return MAKESORTINT(bb->GetSearch(), -bb->GetIndex(), 0) >
			MAKESORTINT(aa->GetSearch(), -aa->GetIndex(), 0) ? 1 : -1;
	}
	return 0;
}

int Cq2chwmBookmarkBoardFile::compDesc(
	const void *vop_user,
	const void *a,
	const void *b)
{
	int in_col = (int)vop_user;
	Cq2chwmBookmarkBoardItem *aa;
	Cq2chwmBookmarkBoardItem *bb;
	memcpy(&aa, (const void*)a, sizeof(Cq2chwmBookmarkBoardItem*));
	memcpy(&bb, (const void*)b, sizeof(Cq2chwmBookmarkBoardItem*));
	switch (in_col) {
	case IDX_INDEX:
		return aa->GetIndex() < bb->GetIndex() ? 1 : -1;
	case IDX_BNAME:
		return strcmp(bb->GetBoardName(), aa->GetBoardName());
	case IDX_BID:
		return strcmp(bb->GetBoardId(), aa->GetBoardId());
	}
	return 0;
}

void Cq2chwmBookmarkBoardFile::RemoveItem(
	int in_pos)
{
	Cq2chwmBookmarkBoardItem *pItem = GetItem(in_pos);
	if (pItem == NULL) return;
	int in_index = pItem->GetIndex();
	delete pItem;
	CYoPtrArray::Remove(in_pos);

	// CfbNX̍Đݒ
	for (int i = 0; i < Count(); i++) {
		Cq2chwmBookmarkBoardItem *pItem = GetItem(i);
		if (in_index < pItem->GetIndex()) {
			pItem->SetIndex(pItem->GetIndex() - 1);
		}
	}
}

int Cq2chwmBookmarkBoardFile::SearchItem(
	const char *chp_filename)
{
	for (int i = 0; i < Count(); i++) {
		Cq2chwmBookmarkBoardItem *pItem = GetItem(i);
		if (strcmp(pItem->GetBoardName(), chp_filename) == 0) {
			return i;
		}
	}
	return -1;
}
