#include "stdafx.h"
#include "q2chwmBbs.h"
#include "q2chwmBbsMachi.h"
#include "q2chwmBbsLivedoor.h"
#include "q2chwmBbsManager.h"

Cq2chwmBbsManager *Cq2chwmBbsManager::m_pInstance = NULL;

//! CX^X擾
/*!
 * 
 * \return Cq2chwmBbsManager* 
 */
Cq2chwmBbsManager *Cq2chwmBbsManager::GetInstance()
{
	if (m_pInstance == NULL) {
		m_pInstance = new Cq2chwmBbsManager();
		atexit(Cq2chwmBbsManager::Delete);
	}
	return m_pInstance;
}

void Cq2chwmBbsManager::Delete()
{
	if (m_pInstance != NULL) delete m_pInstance;
}

//! RXgN^
/*!
 * 
 */
Cq2chwmBbsManager::Cq2chwmBbsManager() : CYoMutex()
{
}

//! fXgN^
/*!
 * 
 */
Cq2chwmBbsManager::~Cq2chwmBbsManager()
{
}

//! DAT擾
/*!
 * CQ2chBbsMachi->CQ2chBbsLivedoor->CQ2chBbsSjis->CQ2chBbs->CQ2chBbsKako->CQ2chBbsDoLib
 * ̏DAT擾sB
 * URL`FbNA2d擾Ȃ
 * \param pParent eEBhẼ|C^
 * \param chp_id fID(ex. 1034469883)
 * \param chp_url x[XURL(ex. http://pc10.2ch.net/mobile/)
 * \return int I: ERR_NONE
 */
int Cq2chwmBbsManager::HttpGet(
	CWnd *pParent,
	const char *chp_url,
	const char *chp_id,
	CYoString &str_err)
{
	// ̌fIDƃx[XURL
	if (addAction(chp_id, chp_url) == FALSE) {
		// Ȃ琳IƂĕԂ(2d擾)
		return ERR_NONE;
	}

	/*
	Cq2chwmBbs *pBbsArray[] = {
		new Cq2chwmBbsMachi(pParent, chp_id, chp_url),		// XBBS
		new Cq2chwmBbsLivedoor(pParent, chp_id, chp_url),		// 
		new Cq2chwmBbsSjis(pParent, chp_id, chp_url),			// 2ch݊SJISf beƂwikiƂ
		new Cq2chwmBbs(pParent, chp_id, chp_url),				// 2ch
		new Cq2chwmBbsKako(pParent, chp_id, chp_url),			// 2ch ߋO
		new Cq2chwmBbsDoLib(pParent, chp_id, chp_url),		// 2ch Do Lib
	};
	*/
	int in_ret = ERR_NONE;

	for (unsigned int i = 0;; i++) {
		Cq2chwmBbs *pBbs = NULL;
		switch (i) {
			case 0:
				pBbs = new Cq2chwmBbsMachi(pParent, chp_id, chp_url);
				break;
			case 1:
				pBbs = new Cq2chwmBbsLivedoor(pParent, chp_id, chp_url);
				break;
			case 2:
				pBbs = new Cq2chwmBbsSjis(pParent, chp_id, chp_url);
				break;
			case 3:
				pBbs = new Cq2chwmBbs(pParent, chp_id, chp_url);
				break;
			case 4:
				pBbs = new Cq2chwmBbsDoLib(pParent, chp_id, chp_url);
				break;
			case 5:
				pBbs = new Cq2chwmBbsKako(pParent, chp_id, chp_url);
				break;
			case 6:
				pBbs = new Cq2chwmBbsKakoPlain(pParent, chp_id, chp_url);
				break;
			default:
				break;
		}
		if (pBbs == NULL) break;

		// URL`FbN
		if (pBbs->MatchUrl() == FALSE) {
			delete pBbs;
			continue;
		}

		// dat擾q֐R[
		in_ret = pBbs->DoAction();
		if( in_ret == ERR_HTTP_ABONE){
			// datt@CobNAbv
			CYoString str_file = pBbs->GetDatPath();
			CYoString str_file_bak = str_file + ".bak";
			RenameFile(str_file, str_file_bak);

			in_ret = pBbs->DoAction();
			if( in_ret == ERR_NONE ){
				RemoveFile(str_file_bak);
			} else {
				RenameFile(str_file_bak, str_file);

				// \̃XgA
				PostCustomMessage(pParent->m_hWnd, new Cq2chwmReloadFileMessage(chp_id, chp_url, pBbs->GetDatPath()));
			}
		}

		if( in_ret == ERR_CANCELED ){
			// datt@Ct0ɂ
			CYoString str_file = pBbs->GetDatPath();
			CleanFileTime(str_file);
		} else if (in_ret == ERR_HTTP_LOCATION) {
			// 302 Location͎CQ2chBbsIuWFNgŏĂ݂
			delete pBbs;
			continue;
		} else if (in_ret != ERR_NONE) {
			str_err = pBbs->GetErrorMessage();
			delete pBbs;
			goto error;
		}

		// I
		delete pBbs;
		break;
	}

  error:
	delAction(chp_id, chp_url);
	return in_ret;
}

//! 
/*! ANV폜
 * ƂċLĂfIDƃx[XURLANVe[u폜
 * \param chp_id 
 * \param chp_url 
 * \return void 
 */
void Cq2chwmBbsManager::delAction(
	const char *chp_id,
	const char *chp_url)
{
	Lock();
	for (int i = 0; i < m_cActionTable.Rows(); i++) {
		const char *chp_tmp_id = m_cActionTable.Get(i, 0);
		const char *chp_tmp_url = m_cActionTable.Get(i, 1);
		if (strcmp(chp_id, chp_tmp_id) == 0 && strcmp(chp_url, chp_tmp_url) == 0) {
			m_cActionTable.Remove(i);
			Unlock();
			return;
		}
	}
	Unlock();
}

//! ANVǉ
/*!
 * ANVe[uɌfIDƃx[XURLǉ
 * łɓID/URL݂ꍇ͒ǉs킸FALSEԂ
 * \param chp_id 
 * \param chp_url 
 * \return int TRUE: ǉ FALSE: dŒǉs
 */
BOOL Cq2chwmBbsManager::addAction(
	const char *chp_id,
	const char *chp_url)
{
	Lock();
	for (int i = 0; i < m_cActionTable.Rows(); i++) {
		const char *chp_tmp_id = m_cActionTable.Get(i, 0);
		const char *chp_tmp_url = m_cActionTable.Get(i, 1);
		if (strcmp(chp_id, chp_tmp_id) == 0 && strcmp(chp_url, chp_tmp_url) == 0) {
			Unlock();
			return FALSE;
		}
	}
	m_cActionTable.Add(chp_id, chp_url, NULL);
	Unlock();
	return TRUE;
}

//! ANV擾
/*!
 * 
 * \return int 
 */
int Cq2chwmBbsManager::GetActionCount()
{
	Lock();
	int in_ret = m_cActionTable.Rows();
	Unlock();
	return in_ret;
}

BOOL Cq2chwmBbsManager::IsAction(
	const char *chp_id,
	const char *chp_url)
{
	Lock();
	for (int i = 0; i < m_cActionTable.Rows(); i++) {
		const char *chp_tmp_id = m_cActionTable.Get(i, 0);
		const char *chp_tmp_url = m_cActionTable.Get(i, 1);
		if (strcmp(chp_id, chp_tmp_id) == 0 && strcmp(chp_url, chp_tmp_url) == 0) {
			Unlock();
			return TRUE;
		}
	}
	Unlock();
	return FALSE;
}
