// q2chwmImageView.cpp : t@C
//

#include "stdafx.h"
#include "YoHttpClient.h"
#include "q2chwm.h"
#include "MainFrm.h"
#include "q2chwmCommon.h"
#include "q2chwmBoardFile.h"
#include "q2chwmConfig.h"
#include "q2chwmImageView.h"

#define SETERRORMESSAGE(fmt, ...) setErrorMessage(__FUNCTION__, __LINE__, ::GetLastError(), fmt, __VA_ARGS__)

// Cq2chwmImageView

IMPLEMENT_DYNCREATE(Cq2chwmImageView, CScrollView)

Cq2chwmImageView::Cq2chwmImageView()
{
	m_bo_fit = TRUE;
}

Cq2chwmImageView::~Cq2chwmImageView()
{
}


BEGIN_MESSAGE_MAP(Cq2chwmImageView, CScrollView)
	ON_WM_KEYDOWN()
	ON_WM_SIZE()
	ON_COMMAND(ID_RELOAD, &Cq2chwmImageView::OnReload)
	ON_COMMAND(ID_DELETE, &Cq2chwmImageView::OnDelete)
	ON_UPDATE_COMMAND_UI(ID_DELETE, &Cq2chwmImageView::OnUpdateDelete)
END_MESSAGE_MAP()


// Cq2chwmImageView `

void Cq2chwmImageView::OnInitialUpdate()
{
	CScrollView::OnInitialUpdate();

	// TODO: ̃r[̃TCY̍vvZ܂B
	// IMEIt
	SipOff(m_hWnd);
}

void Cq2chwmImageView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
	// TODO: `R[hɒǉĂB
	RECT rcView;
	GetClientRect(&rcView);
	if (m_cImage.GetBitmap() != NULL) {
		// DC쐬
		CDC cMemoryDC;
		cMemoryDC.CreateCompatibleDC(pDC);
		HGDIOBJ hOldBitmap = cMemoryDC.SelectObject(m_cImage.GetBitmap());
		if (m_bo_fit == TRUE) {
			CRect cAdjustRect = getAdjustRect(m_cImage.GetSize(), CSize(rcView.right - rcView.left, rcView.bottom - rcView.top));
			::SetStretchBltMode(pDC->GetSafeHdc(), COLORONCOLOR);
			pDC->StretchBlt(cAdjustRect.left, cAdjustRect.top, cAdjustRect.right, cAdjustRect.bottom, &cMemoryDC, 0, 0, m_cImage.GetWidth(), m_cImage.GetHeight(), SRCCOPY);
		} else {
			int hx = 0;
			int hy = 0;
			CSize sizeView = getViewSize();
			if (sizeView.cx > m_cImage.GetWidth()) hx = (sizeView.cx - m_cImage.GetWidth()) / 2;
			if (sizeView.cy > m_cImage.GetHeight()) hy = (sizeView.cy - m_cImage.GetHeight()) / 2;
#ifdef _WIN32_WCE
			CPoint pt = GetScrollPosition();
			pDC->BitBlt(hx, hy, m_cImage.GetWidth(), m_cImage.GetHeight(), &cMemoryDC, pt.x, pt.y, SRCCOPY);
#else
			pDC->BitBlt(hx, hy, m_cImage.GetWidth(), m_cImage.GetHeight(), &cMemoryDC, 0, 0, SRCCOPY);
#endif
		}
		cMemoryDC.SelectObject(hOldBitmap);
		cMemoryDC.DeleteDC();
	}

	if (m_cstr_error.GetLength() > 0) {
		pDC->DrawText(m_cstr_error, -1, &rcView, DT_LEFT | DT_WORDBREAK | DT_NOPREFIX | DT_NOCLIP);
	}
}


// Cq2chwmImageView ff

#ifdef _DEBUG
void Cq2chwmImageView::AssertValid() const
{
	CScrollView::AssertValid();
}

#ifndef _WIN32_WCE
void Cq2chwmImageView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}
#endif
#endif //_DEBUG

/*!
 * \brief
 * Cq2chwmImageView::ThreadHttpGetProcXbhɓnNX.
 * 
 * CEBhEAthis|C^AURLi[.
 */
class Cq2chwmThreadInfo
{
private:
	CWnd *m_pMainFrame;
	Cq2chwmImageView *m_pThis;
	CYoString m_str_url;

public:
	Cq2chwmThreadInfo(CWnd *pMainFrame, Cq2chwmImageView *pThis, const char *chp_url)
	{
		m_pMainFrame = pMainFrame;
		m_pThis = pThis;
		m_str_url = chp_url;
	}
	inline CWnd *GetMainWnd(){ return m_pMainFrame; }
	inline Cq2chwmImageView *GetView(){ return m_pThis; }
	inline const char* GetUrl(){ return m_str_url; }
};

/*!
 * \brief
 * URLǉ.
 * 
 * \param chp_url
 * _E[hJnURL.
 * 
 * _E[hJnURLnbV}bvɒǉ
 * ʃXbhĂ΂邽߃~[ebNXŕی.
 * 
 */
void Cq2chwmImageView::addUrl(
	const char *chp_url)
{
	m_cMutex.Lock();
	CString cstr_url;
	cstr_url = chp_url;
	m_cMapUrl.SetAt(cstr_url, (void*)0);
	m_cMutex.Unlock();
}

/*!
 * \brief
 * URL폜.
 * 
 * \param chp_url
 * _E[hIURL.
 * 
 * _E[hI珈URLnbV}bvURL폜邽߂ɌĂ΂
 * ʃXbhĂ΂邽߃~[ebNXŕی.
 * 
 */
void Cq2chwmImageView::removeUrl(
	const char *chp_url)
{
	m_cMutex.Lock();
	CString cstr_url;
	cstr_url = chp_url;
	m_cMapUrl.RemoveKey(cstr_url);
	m_cMutex.Unlock();
}

/*!
 * \brief
 * URLǂԂ.
 * 
 * \param chp_url
 * _E[hǂ𒲍URL.
 * 
 * _E[hȂ_E[hsȂ悤ɂ邽߂̃\bh.
 */
BOOL Cq2chwmImageView::existsUrl(
	const char *chp_url)
{
	m_cMutex.Lock();
	CString cstr_url;
	cstr_url = chp_url;
	void *vop_value;
	if (m_cMapUrl.Lookup(cstr_url, vop_value) == FALSE) {
		m_cMutex.Unlock();
		return FALSE;
	}
	m_cMutex.Unlock();
	return TRUE;
}

/*!
 * \brief
 * 摜_E[h.
 * 
 * \param chp_url
 * 摜URL.
 * 
 * \param bo_force
 * t@C݂ĂIɃ_E[hȂTRUE.
 * 
 * \returns
 * 摜_E[hXbhɊJnłTRUEAɏXbh̊JnɎsFALSE.
 * 
 * }`Xbhŉ摜̃_E[hs
 * 摜̃_E[hI烁CEBhEWM_USER_GETIMAGEbZ[WM.
 */
BOOL Cq2chwmImageView::HttpGet(
	const char *chp_url,
	BOOL bo_force)
{
	// URLnbV}bvɓĂ珈Ȃ
	if (existsUrl(chp_url) == TRUE) {
		return FALSE;
	}
	CYoString str_filename = UrlToImagePath(chp_url);
	if(ExistFile(str_filename) == FALSE || bo_force == TRUE){
		if (bo_force == TRUE || Cq2chwmConfig::GetInstance()->GetOnline() == TRUE ||
			::MessageBox(m_hWnd, _T("t@C݂܂BT[o擾܂H"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_YESNO|MB_ICONQUESTION) == IDYES)
		{
			AfxBeginThread(Cq2chwmImageView::ThreadHttpGetProc, (LPVOID)new Cq2chwmThreadInfo(AfxGetMainWnd(), this, chp_url), THREAD_PRIORITY_BELOW_NORMAL);
		} else {
			return FALSE;
		}
	}

	return TRUE;
}

/*!
 * \brief
 * r[ɕ\摜ǂݍ.
 * 
 * \param chp_url
 * 摜URL.
 * 
 * \returns
 * ȂFALSEAȊOȂTRUE.
 * 
 * 摜̓ǂݍ݂ɎsĂTRUEԂ(̏ꍇ̓r[ɃG[bZ[W\).
 */
BOOL Cq2chwmImageView::CreateImage(
	const char *chp_url)
{
	if (chp_url == NULL) return FALSE;
	// URLnbV}bvɓĂ珈Ȃ
	if (existsUrl(chp_url) == TRUE) {
		return FALSE;
	}
	m_cImage.Destroy();
	m_cstr_error = "";
	m_str_filename = UrlToImagePath(chp_url);
	m_str_url = chp_url;
	CString cstr_filename;
	cstr_filename = m_str_filename;
	HRESULT hr;
	hr = m_cImage.Create(cstr_filename);
	if (hr != S_OK) {
		// 摜傫ăG[Ȃr[ƓTCỸTlC摜̕\
		CString cstr_message;
		cstr_message.Format(_T("IWiTCYŕ\o܂Bkĕ\܂(%d)"), hr);
		MessageBox(cstr_message, _T(APP_NAME)_T("/")_T(APP_VERSION), MB_OK|MB_ICONINFORMATION);
		CSize sizeView = getViewSize();
		hr = m_cImage.Create(cstr_filename, sizeView.cx, sizeView.cy);
		if (hr != S_OK) {
			SETERRORMESSAGE(_T("Cq2chwmImage::Create error: %d(%d)"), hr, ::GetLastError());
		}
	} else if (hr != S_OK) {
		SETERRORMESSAGE(_T("Cq2chwmImage::Create error: %d(%d)"), hr, ::GetLastError());
	}
	setSize();
	return TRUE;
}

/*!
 * \brief
 * 摜_E[hXbh֐
 * 
 * \param vop_user
 * Cq2chwmThreadInfõ|C^.
 * 
 * \returns
 * Xbh֐̖߂l͏0.
 * 
 * 摜̃_E[hIWM_USER_GETIMAGEMA<BR>
 * LPARAMCq2chwmGetImageInfoZbg<BR>
 * G[R[hAURLAG[bZ[WCq2chwmGetImageInfo擾\.
 */
UINT __cdecl Cq2chwmImageView::ThreadHttpGetProc(
	LPVOID vop_user)
{
	// 擾
	Cq2chwmThreadInfo *pInfo = (Cq2chwmThreadInfo*)vop_user;
	CWnd *pMainWnd = pInfo->GetMainWnd();
	Cq2chwmImageView *pThis = pInfo->GetView();
	const char *chp_url = pInfo->GetUrl();

	// nbV}bvURLo^
	pThis->addUrl(chp_url);

	// t@CpX擾
	CString cstr_filename;
	CYoString str_filename = UrlToImagePath(chp_url);
	cstr_filename = str_filename;

	// G[bZ[Wi[
	CYoString str_message;

	// Xe[^Xo[\
	pMainWnd->SendMessage(WM_USER_SHOWSTATUSBAR, 0, (LPARAM)TRUE);

	// HTTPJn
	int in_ret = ERR_NONE;
	CYoHttpClient cHttp(chp_url);
	cHttp.SetUserAgent(Cq2chwmConfig::GetInstance()->GetUserAgent());
	if (Cq2chwmConfig::GetInstance()->GetProxyUse() == TRUE) {
		cHttp.SetProxy(Cq2chwmConfig::GetInstance()->GetProxyHost(), Cq2chwmConfig::GetInstance()->GetProxyPort());
		cHttp.SetProxyAuth(Cq2chwmConfig::GetInstance()->GetProxyId(), Cq2chwmConfig::GetInstance()->GetProxyPass());
	}
	cHttp.SetCallbackProc(CMainFrame::CallbackProc, pMainWnd);

	if (cHttp.Connect(TIMEOUT) == FALSE) {
		in_ret = ERR_HTTP_CONNECT;
		goto end;
	}

	if (cHttp.Get() == FALSE) {
		in_ret = ERR_HTTP_GET;
		goto end;
	}

	if (cHttp.GetResultCode() < 200 || cHttp.GetResultCode() >= 300) {
		CYoString str_header = cHttp.GetResponseHeader();
		str_header.Remove(str_header.Find("\r\n"));
		str_message = str_header;
		in_ret = ERR_HTTP_GET;
		goto end;
	}

	// 摜t@Cɕۑ
	{
		// fBNg쐬
		CYoString str_dir = GetBaseName(str_filename);
		MakeDirectory(str_dir);

		CFile cFileTmp;
		if (cFileTmp.Open(cstr_filename, CFile::modeCreate|CFile::modeWrite) == FALSE) {
			in_ret = ERR_FILE_OPEN;
			goto end;
		}

		CYoString str_length = cHttp.GetResponseHeader("Content-Length");
		int in_length = str_length.Atoi();
		int in_recv = 0;

		char cha_buff[RECV_BUFF];
		int in_ret;
		while ((in_ret = cHttp.Recv(cha_buff, sizeof(cha_buff) - 1)) > 0) {
			cFileTmp.Write(cha_buff, in_ret);
			in_recv += in_ret;
			pMainWnd->SendMessage(WM_USER_SETPROGRESS, cHttp.GetRecvSize(), in_length);
		}
		cFileTmp.Close();
		if (in_ret == 0 && ((CMainFrame*)pMainWnd)->Canceled() == TRUE) {
			RemoveFile(str_filename);
			return ERR_CANCELED;
		}
		if( in_ret == SOCKET_ERROR ){
			RemoveFile(str_filename);
			in_ret = ERR_HTTP_RECV;
			goto end;
		}
	}

end:
	pThis->removeUrl(chp_url);
	Cq2chwmGetImageInfo cInfo(in_ret, chp_url, str_message);
	pMainWnd->SendMessage(WM_USER_GETIMAGE, 0, (LPARAM)&cInfo);
	pMainWnd->SendMessage(WM_USER_SHOWSTATUSBAR, 0, (LPARAM)FALSE);
	delete pInfo;
	return ERR_NONE;
}

// Cq2chwmImageView bZ[W nh
void Cq2chwmImageView::OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B
	TRACE(_T("Cq2chwmImageView::OnKeyDown: %02x(%d)\n"), nChar, nChar);
	if (Cq2chwmConfig::GetInstance()->IsKeyViewBack(nChar)) {
		GetParent()->SendMessage(WM_USER_VIEWBACK, 0, 0);
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyReload(nChar)) {
		OnReload();
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyDelete(nChar)) {
		OnDelete();
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyMenu(nChar)) {
		AfxGetMainWnd()->SendMessage(WM_USER_POPUPMENU);
		return;
	} else if (Cq2chwmConfig::GetInstance()->IsKeyChangeView(nChar)) {
		((Cq2chwmApp*)AfxGetApp())->PopupViewMenu();
		return;
	} else if (nChar == VK_RETURN) {
		m_bo_fit = !m_bo_fit;
		setSize();
		Invalidate();
		return;
	} else if(nChar == VK_LEFT ||
		nChar == VK_RIGHT ||
		nChar == VK_UP ||
		nChar == VK_DOWN)
	{
		PRINTLOG("Cq2chwmImageView::OnKeyDown: %02x(%d)",nChar,nChar);
		if (m_bo_fit == TRUE) {
			return;
		}

		CSize sizeView = getViewSize();
		CPoint pt = GetScrollPosition();
		if (nChar == VK_LEFT) {
			if (m_cImage.GetWidth() <= sizeView.cx) return;
			pt.x -= sizeView.cx / 5;
			if (pt.x < 0) pt.x = 0;
		} else if (nChar == VK_UP) {
			if (m_cImage.GetHeight() <= sizeView.cy) return;
			pt.y -= sizeView.cy / 5;
			if (pt.y < 0) pt.y = 0;
		} else if (nChar == VK_RIGHT) {
			if (m_cImage.GetWidth() <= sizeView.cx) return;
			pt.x += sizeView.cx / 5;
			if (pt.x > m_cImage.GetWidth() - sizeView.cx) pt.x = m_cImage.GetWidth() - sizeView.cx;
		} else if (nChar == VK_DOWN) {
			if (m_cImage.GetHeight() <= sizeView.cy) return;
			pt.y += sizeView.cy / 5;
			if (pt.y > m_cImage.GetHeight() - sizeView.cy) pt.y = m_cImage.GetHeight() - sizeView.cy;
		}
		ScrollToPosition(pt);
		return;
	}

	CScrollView::OnKeyDown(nChar, nRepCnt, nFlags);
}

void Cq2chwmImageView::OnReload()
{
	// TODO: ɃR}h nh R[hǉ܂B
	HttpGet(m_str_url, TRUE);
	CreateImage(m_str_url);
	InvalidateRect(NULL);
}

BOOL Cq2chwmImageView::setSize()
{
	if (m_bo_fit == TRUE) {
		// RecTCY = r[TCY
		CSize sizeView = getViewSize();
		SetScrollSizes(MM_TEXT, sizeView);
	} else {
		// RecTCY = 摜TCY
		SetScrollSizes(MM_TEXT, m_cImage.GetSize());
	}
	return TRUE;
}

CRect Cq2chwmImageView::getAdjustRect(
	const CSize sizeImage,		// 摜IWiTCY
	const CSize sizeHint)		// qgTCY(̃TCY̒Ɏ܂CRectԂ)
{
	double w1 = sizeHint.cx;
	double h1 = sizeHint.cy;
	double w2 = sizeImage.cx;
	double h2 = sizeImage.cy;
	double ww = w1 / w2;
	double hh = h1 / h2;
	int x = 0;
	int y = 0;
	if (ww < hh) {
		x = (int)(w2 * ww);
		y = (int)(h2 * ww);
	} else {
		x = (int)(w2 * hh);
		y = (int)(h2 * hh);
	}
	int hx = (int)((w1 - x) / 2);
	int hy = (int)((h1 - y) / 2);
	return CRect(hx, hy, x, y);
}

void Cq2chwmImageView::setErrorMessage(
	const char *chp_func,
	DWORD dwLine,
	DWORD dwError,
	LPCTSTR lpszFormat, ...)
{
	va_list va_argp;
	va_start(va_argp, lpszFormat);
	CString strMessage;
	strMessage.FormatV(lpszFormat, va_argp);
	va_end(va_argp);

    LPTSTR lpBuffer;
    FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER|FORMAT_MESSAGE_FROM_SYSTEM, NULL, dwError,
        LANG_USER_DEFAULT, (LPTSTR)&lpBuffer, 0, NULL);
	m_cstr_error = lpBuffer;
	m_cstr_error += strMessage;
    LocalFree(lpBuffer);
}

CSize Cq2chwmImageView::getViewSize()
{
	RECT rcView;
	GetParent()->GetClientRect(&rcView);
	return CSize(rcView.right - rcView.left, rcView.bottom - rcView.top);
}

void Cq2chwmImageView::OnDelete()
{
	// TODO: ɃR}h nh R[hǉ܂B
	if (::MessageBox(m_hWnd, _T("폜܂H"), _T(APP_NAME)_T("/")_T(APP_VERSION), MB_YESNO|MB_ICONQUESTION) == IDYES) {
		m_cImage.Destroy();
		RemoveFile(m_str_filename);
		GetParent()->SendMessage(WM_USER_VIEWBACK, 0, 0);
		GetParent()->SendMessage(WM_USER_DELETEIMAGEFILE, 0, (LPARAM)(const char*)m_str_filename);
	}
}

void Cq2chwmImageView::OnUpdateDelete(CCmdUI *pCmdUI)
{
	// TODO: ɃR}hXV UI nh R[hǉ܂B
	pCmdUI->Enable(m_str_filename.Length() > 0);
}
