#pragma once

#include "q2chwmListItem.h"

// Cq2chwmListView r[

class Cq2chwmListView : public CListView
{
//	DECLARE_DYNCREATE(Cq2chwmListView)
private:
	CImageList *m_pImage;
	CFont *m_pFont;
	int m_in_sortcol;
	BOOL m_bo_sortasc;

	BOOL m_bFullRowSel;
	BOOL m_bClientWidthSel;
	int m_cxClient;
	int m_cxStateImageOffset;
	COLORREF m_clrText;
	COLORREF m_clrTextBk;
	COLORREF m_clrBkgnd;
	COLORREF m_clrActiveText;
	COLORREF m_clrActiveTextBk;

	static LPCTSTR MakeShortString(CDC* pDC, LPCTSTR lpszLong, int nColumnLen, int nOffset);
	void RepaintSelectedItems();

protected:
	afx_msg LRESULT OnSetImageList(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnSetTextColor(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnSetTextBkColor(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnSetBkColor(WPARAM wParam, LPARAM lParam);
	afx_msg LRESULT OnSetFont(WPARAM wParam, LPARAM lParam);

protected:
	Cq2chwmListView();           // IŎgp protected RXgN^
	virtual ~Cq2chwmListView();

	// 
	afx_msg void OnCustomDraw(NMHDR* pNMHDR, LRESULT* pResult);

	// {
	void SetFont(const char *chp_name, int in_size, BOOL bo_bold);
	void GoTop();
	void GoBottom();

	// oϐANZX
	inline int GetSortColumn(){ return m_in_sortcol; }
	inline BOOL GetSortAsc(){ return m_bo_sortasc; }
	inline void SetSortColumn(int in_col){ m_in_sortcol = in_col; }
	inline void SetSortAsc(BOOL bo_asc){ m_bo_sortasc = bo_asc; }

	// ׂ
	virtual void SortItems(int in_col, BOOL bo_asc) = 0;
	virtual void OnListClicked() = 0;
	virtual BOOL GetItemText(LPTSTR wchp_text, int in_size, int in_row, int in_col) = 0;
	virtual Cq2chwmListItem *GetSelectedItem() = 0;
	virtual Cq2chwmListItem *GetItem(int iRow) = 0;

	COLORREF GetForeColor(int iRow);
	COLORREF GetBackColor(int iRow);
	int GetState(int iRow);

public:
	BOOL SetFullRowSel(BOOL bFillRowSel);
	BOOL GetFullRowSel();
	virtual void CopyInformation();
	void ResetSearchState();

#ifdef _DEBUG
	virtual void AssertValid() const;
#ifndef _WIN32_WCE
	virtual void Dump(CDumpContext& dc) const;
#endif
#endif

protected:
	virtual void DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct);
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnPaint();
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnKillFocus(CWnd* pNewWnd);

protected:
	DECLARE_MESSAGE_MAP()
protected:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
public:
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
public:
	afx_msg void OnNMReturn(NMHDR *pNMHDR, LRESULT *pResult);
public:
	afx_msg void OnNMClick(NMHDR *pNMHDR, LRESULT *pResult);
public:
	afx_msg void OnKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags);
public:
	afx_msg void OnGobottom();
public:
	afx_msg void OnGotop();
public:
	afx_msg void OnLvnColumnclick(NMHDR *pNMHDR, LRESULT *pResult);
public:
	afx_msg void OnLvnGetdispinfo(NMHDR *pNMHDR, LRESULT *pResult);
public:
	afx_msg void OnChar(UINT nChar, UINT nRepCnt, UINT nFlags);
	afx_msg void MeasureItem ( LPMEASUREITEMSTRUCT lpMeasureItemStruct );
};


