#include "StdAfx.h"
#include "q2chwmCacheItem.h"
#include "q2chwmDatFile.h"
#include "q2chwmCommon.h"
#include "q2chwmBookmarkFile.h"

Cq2chwmCacheItem::Cq2chwmCacheItem(
	int in_index,
	const char *chp_aname,
	const char *chp_aid,
	const char *chp_bname,
	const char *chp_bid,
	const char *chp_burl,
	const char *chp_date,
	BOOL bo_html_to_text) : Cq2chwmListItem(in_index, chp_aname, chp_aid, chp_bname, chp_bid, chp_burl, bo_html_to_text)
{
	m_str_date = chp_date;
	m_bo_selected = FALSE;
}

Cq2chwmCacheItem::~Cq2chwmCacheItem()
{
}

int Cq2chwmCacheItem::GetState()
{
	int in_selected = (m_bo_selected == TRUE ? Cq2chwmListItem::STATE_SELECTED : 0);
	if (Cq2chwmBookmarkFile::GetInstance()->Search(GetArticleUrl()) >= 0) {
		return Cq2chwmListItem::STATE_BOOKMARK|in_selected;
	}
	return Cq2chwmListItem::STATE_NORMAL|in_selected;
}
