#include "StdAfx.h"
#include "YoFile.h"
#include "YoRegex.h"
#include "YoTime.h"
#include "q2chwm.h"
#include "MainFrm.h"
#include "q2chwmSubjectFile.h"
#include "q2chwmBoardFile.h"
#include "q2chwmConfig.h"
#include "q2chwmCommon.h"
#include "q2chwmBoardView.h"
#include "q2chwmBbsSubject.h"
#include "q2chwmDatFile.h"
#include "q2chwmInfoFile.h"

Cq2chwmSubjectFile::Cq2chwmSubjectFile(void) : CYoPtrArray(1024)
{
}

Cq2chwmSubjectFile::~Cq2chwmSubjectFile(void)
{
	RemoveAll();
}

void Cq2chwmSubjectFile::RemoveAll()
{
	for (int i = 0; i < Count(); i++) {
		Cq2chwmSubjectItem *pItem = (Cq2chwmSubjectItem*)Get(i);
		delete pItem;
	}
	CYoPtrArray::RemoveAll();
	m_cTree.RemoveAll();
}

int Cq2chwmSubjectFile::CreateFromFile(
	const char *chp_filename)
{
	// t@CURL擾
	CYoString str_burl;
	CYoString str_bname;
	CYoString str_bid;
	CYoString str_dir;
	{
		static CYoRegex cRegex("^(.+\\\\([^\\\\]+)\\\\)subject\\.txt$", CYoRegex::SJIS);
		if (cRegex.Match(chp_filename) >= 0) {
			str_dir = cRegex.Get(1);
			CYoString str_tmp = str_dir;
			str_tmp.Remove(0, strlen(Cq2chwmConfig::GetInstance()->GetRootDirectory()));
			str_tmp.Replace("\\", "/");
			str_burl.Format("http:/%s", (const char*)str_tmp);
			str_bid = cRegex.Get(2);
			Cq2chwmBoardView *pView = ((Cq2chwmApp*)AfxGetApp())->GetBoardView();
			int in_find = pView->SearchFromUrl(str_burl);
			if (in_find >= 0) {
				str_bname = pView->GetBoardName(in_find);
			}
		}
	}
	m_str_burl = str_burl;

	CYoTextFile cFile(chp_filename, CYoFile::READ);
	if (cFile.Open() == FALSE) {
		return ERR_FILE_OPEN;
	}

	RemoveAll();
	CYoString str_line;
	int in_index = 0;
	char cha_buff[8192];
	CYoTime cTime;
	Cq2chwmBbsSubjectManager cBbsSubjectManager(str_burl);
	Cq2chwmBbsSubject *pBbsSubject = cBbsSubjectManager.GetBbsSubject();
	while (cFile.Eof() == FALSE) {
		cFile.ReadLine(cha_buff, sizeof(cha_buff));
		if (*cha_buff == 0x00) continue;
		in_index++;
		if (cBbsSubjectManager.GetBbsSubject()->Parse(cha_buff) == FALSE) {
			//return ERR_FILE_FORMAT;
			continue;
		}
		Cq2chwmSubjectItem *pItem;
		if (cBbsSubjectManager.GetBbsSubject()->GetBoardName() == NULL) {
			pItem = new Cq2chwmSubjectItem(in_index, pBbsSubject->GetArticleName(),
				pBbsSubject->GetArticleId(), str_bname, str_burl, str_bid, pBbsSubject->GetCount());
			Add(pItem);
		} else {
			pItem = new Cq2chwmSubjectItem(in_index, pBbsSubject->GetArticleName(),
				pBbsSubject->GetArticleId(), pBbsSubject->GetBoardName(),
				pBbsSubject->GetBoardUrl(), pBbsSubject->GetBoardId(), pBbsSubject->GetCount());
			Add(pItem);
		}
		m_cTree.Add(pBbsSubject->GetArticleId(), (long)pItem);

	}
	cFile.Close();
	PRINTLOG("%d(msec)", cTime.Elapsed());

#if 0
	// datXfBNgzɂdatt@CT
	WIN32_FIND_DATA st_find;
	CString cstr_path;
	cstr_path = W(str_dir);
	cstr_path += _T("*");
	HANDLE hFind = ::FindFirstFile(cstr_path, &st_find);
	if (hFind != INVALID_HANDLE_VALUE) {
		do {
			if (wcscmp(st_find.cFileName, _T(".")) == 0 || wcscmp(st_find.cFileName, _T("..")) == 0) continue;
			if (st_find.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) {
				// fBNg͖
				;
			} else if (wcscmp(st_find.cFileName + _tcslen(st_find.cFileName) - 4, _T(".dat")) == 0) {
				// datt@C
				CYoString str_filename = A(st_find.cFileName);
				CYoString str_aid = str_filename.Left(str_filename.Length() - 4);
				if (GetItem((const char*)str_aid) == NULL) {
					// subject.txtɑ݂Ȃ(datX)
					in_index++;
					CYoString str_name;
					CYoString str_filepath = str_dir + str_filename;
					if (Cq2chwmDatFile::GetName(str_name, str_filepath) == TRUE) {
						Cq2chwmInfoFile cInfo;
						cInfo.Create(str_burl, str_aid);
						CYoString str_count = cInfo.GetCount();
						Cq2chwmSubjectItem *pItem = new Cq2chwmSubjectItem(in_index, str_name,
							str_aid, str_bname, str_burl, str_bid, str_count);
						Add(pItem);
						m_cTree.Add(pBbsSubject->GetArticleId(), (long)pItem);
					}
				}
			}
		} while (FindNextFile(hFind, &st_find));
		::FindClose(hFind);
	}
	PRINTLOG("find %d(msec)", cTime.Elapsed());
#endif

	return ERR_NONE;
}

int Cq2chwmSubjectFile::CreateFromHttp(
	const char *chp_filename,
	const char *chp_burl)
{
	m_str_burl = chp_burl;

	// fBNg쐬
	CYoString str_dir = GetBaseName(chp_filename);
	MakeDirectory(str_dir);

	// subject.txt̃pX擾
	CYoString str_filename = UrlToPath(chp_burl);
	CString cstr_filename;
	cstr_filename = str_filename;

	// HTTPIuWFNg쐬
	CYoHttpClient cHttp(chp_burl);
	cHttp.SetUserAgent(Cq2chwmConfig::GetInstance()->GetUserAgent());
	if (Cq2chwmConfig::GetInstance()->GetProxyUse() == TRUE) {
		cHttp.SetProxy(Cq2chwmConfig::GetInstance()->GetProxyHost(), Cq2chwmConfig::GetInstance()->GetProxyPort());
		cHttp.SetProxyAuth(Cq2chwmConfig::GetInstance()->GetProxyId(), Cq2chwmConfig::GetInstance()->GetProxyPass());
	}
	cHttp.SetCallbackProc(CMainFrame::CallbackProc, AfxGetMainWnd());

	// ŏIXV擾
	{
		FILETIME st_modify;
		ULONGLONG ul_length;
		if (ExistFile(str_filename, &ul_length, &st_modify) == TRUE && ul_length > 0) {
			CYoString str_time = ConvertGmtTime(&st_modify);
			cHttp.AddRequestHeader("If-Modified-Since", str_time);
		}
	}

	if( cHttp.Connect( TIMEOUT ) == FALSE ){
		return ERR_HTTP_CONNECT;
	}

	if( cHttp.Get() == FALSE ){
		return ERR_HTTP_GET;
	}

	if( cHttp.GetResultCode() == 304 ){
		return ERR_HTTP_NOTMODIFIED;
	}

	if( cHttp.GetResultCode() < 200 || cHttp.GetResultCode() >= 300 ){
		return ERR_HTTP_GET;
	}

	// t@Cɏ
	CFile cFile;
	if (cFile.Open(cstr_filename, CFile::modeCreate|CFile::modeWrite) == FALSE) {
		return ERR_FILE_OPEN;
	}

	// Rec̒
	CYoString str_length = cHttp.GetResponseHeader("Content-Length");
	int in_length = str_length.Atoi();

	char cha_buff[RECV_BUFF];
	int in_ret;
	while ((in_ret = cHttp.Recv(cha_buff, sizeof(cha_buff) - 1)) > 0) {
		cFile.Write(cha_buff, in_ret);
		AfxGetMainWnd()->SendMessage(WM_USER_SETPROGRESS, cHttp.GetRecvSize(), in_length);
	}
	cFile.Close();
	if( in_ret == 0 && ((CMainFrame*)AfxGetMainWnd())->Canceled() == TRUE) {
		return ERR_CANCELED;
	}
	if( in_ret == SOCKET_ERROR ){
		return ERR_HTTP_RECV;
	}

	return CreateFromFile(chp_filename);
}

int Cq2chwmSubjectFile::CreateFromFindUrl(
	const char *chp_filename,
	const char *chp_url)
{
	if (chp_filename == NULL || chp_url == NULL) {
		return ERR_PARAM;
	}

	CYoString str_dir = GetBaseName(chp_filename);
	MakeDirectory(str_dir);

	// subject.txtI[v
	CString cstr_filename;
	cstr_filename = chp_filename;
	CFile cFile;
	if (cFile.Open(cstr_filename, CFile::modeCreate|CFile::modeWrite) == FALSE) {
		return ERR_FILE_OPEN;
	}

	// subject.txt.init@C
	CYoString str_conf = CYoString(chp_filename) + ".ini";
	CYoConfig cConfig(str_conf);

	int in_count = 0;
	int in_count_all = -1;
	int in_ret;
	int in_offset = 0;
	do {
		CYoString str_url = chp_url;
		str_url.FormatAdd("&OFFSET=%d", in_offset);
		in_offset += 50;

		CYoHttpClient cHttp(str_url);
		// P[^CUAZbgĂƃp[XɎŝŃftHgUAZbg
		cHttp.SetUserAgent(USERAGENT);
		if (Cq2chwmConfig::GetInstance()->GetProxyUse() == TRUE) {
			cHttp.SetProxy(Cq2chwmConfig::GetInstance()->GetProxyHost(), Cq2chwmConfig::GetInstance()->GetProxyPort());
			cHttp.SetProxyAuth(Cq2chwmConfig::GetInstance()->GetProxyId(), Cq2chwmConfig::GetInstance()->GetProxyPass());
		}
		cHttp.SetCallbackProc(CMainFrame::CallbackProc, AfxGetMainWnd());
		cHttp.SetKeepAlive(TRUE);
		if (cHttp.Connect(TIMEOUT) == FALSE) {
			in_ret = ERR_HTTP_CONNECT;
			break;
		}

		if (cHttp.Get() == FALSE) {
			in_ret = ERR_HTTP_GET;
			break;
		}

		if (cHttp.GetResultCode() < 200 || cHttp.GetResultCode() >= 300) {
			in_ret = ERR_HTTP_GET;
			break;
		}

		cConfig.WriteString("Url", chp_url);
		cConfig.WriteString("CountAll", "-");
		cConfig.WriteInt("Count", 0);

		// T[rXʔƃNGXg擾
		CYoRegex cRegex("STR=(.+)&COUNT=([0-9]+)");
		if (cRegex.Match(chp_url) >= 0) {
			CYoString str_key = cRegex.Get(1);
			str_key.UrlDecode();
			cConfig.WriteString("Key", str_key);
		}

		CYoString str_tmp;
		char cha_buff[RECV_BUFF];
		while ((in_ret = cHttp.Recv(cha_buff, sizeof(cha_buff) - 1)) > 0) {
			int in_match = 0;
			cha_buff[in_ret] = 0x00;
			str_tmp += (const char*)cha_buff;
			int in_len = str_tmp.Length();

			// find.2ch.net
			if (in_count_all == -1) {
				CYoString str_pat = "([0-9]+)X 1`([0-9]+)X";
				str_pat.ConvertKCodeEx(CYoString::SJISTOEUC);
				CYoRegex cRegexCount(str_pat, CYoRegex::EUC, TRUE);
				in_match = cRegexCount.Match(str_tmp);
				if (in_match >= 0) {
					in_count_all = atoi(cRegexCount.Get(1));
					str_tmp.Remove(0, in_match + strlen(cRegexCount.Get(0)));
				}
			}

			CYoString str_pat = "<dt><a href=\".+?/([0-9]+)/[0-9]+-[0-9]+\">(.+?)</a> \\(([0-9]+)\\).+?<a href=([^>]+)>([^<]+?)</a>";
			str_pat.ConvertKCodeEx(CYoString::SJISTOEUC);
			static CYoRegex cRegexData(str_pat, CYoRegex::EUC, TRUE);
			while ((in_match = cRegexData.Match(str_tmp)) >= 0) {
				CYoString str_url = cRegexData.Get(4);
				CYoString str_bname = cRegexData.Get(5);
				CYoString str_id = cRegexData.Get(1);
				CYoString str_aname = cRegexData.Get(2);
				CYoString str_count = cRegexData.Get(3);
				HtmlToText(str_aname);
				HtmlToText(str_bname);

				// Q˂錟subject.txt̃tH[}bg [XbhID].dat<>[Xbh] ([X])<>[URL]<>[]
				CYoString str_line;
				str_line.FormatAdd("%s.dat<>%s (%d)<>%s<>%s\n", (const char*)str_id, (const char*)str_aname, str_count.Atoi(),
								   (const char*)str_url, (const char*)str_bname);
				str_line.ConvertKCodeEx(CYoString::EUCTOSJIS);
				cFile.Write(str_line, str_line.Length());
				in_count++;
				str_tmp.Remove(0, in_match + strlen(cRegexData.Get(0)));
			}

			// Content-LengthȂ猏ŃvOXo[\
			AfxGetMainWnd()->SendMessage(WM_USER_SETPROGRESS, in_count, in_count_all);
		}
	} while (in_count < in_count_all);

	cConfig.WriteInt("Count", in_count);
	cConfig.WriteInt("CountAll", in_count_all);

	cFile.Close();

	// MG[`FbN
	if (((CMainFrame*)AfxGetMainWnd())->Canceled() == FALSE && in_ret != ERR_NONE) {
		return in_ret;
	}

	return CreateFromFile(chp_filename);
}

int Cq2chwmSubjectFile::CreateFromSearchEngine(
	const char *chp_filename,
	const char *chp_url)
{
	if (chp_filename == NULL || chp_url == NULL) {
		return ERR_PARAM;
	}

	CYoString str_dir = GetBaseName(chp_filename);
	MakeDirectory(str_dir);

	// subject.txtI[v
	CString cstr_filename;
	cstr_filename = chp_filename;
	CFile cFile;
	if (cFile.Open(cstr_filename, CFile::modeCreate|CFile::modeWrite) == FALSE) {
		return ERR_FILE_OPEN;
	}

	// subject.txt.init@C
	CYoString str_conf = CYoString(chp_filename) + ".ini";
	CYoConfig cConfig(str_conf);

	int in_count = 0;
	int in_count_all = -1;
	int in_ret;
	int in_offset = 0;
	CYoTree cTree;
	do {
		CYoString str_url = chp_url;
		str_url.FormatAdd("&start=%d", in_offset);
		in_offset += 100;

		CYoHttpClient cHttp(str_url);
		cHttp.SetUserAgent(Cq2chwmConfig::GetInstance()->GetUserAgent());
		if (Cq2chwmConfig::GetInstance()->GetProxyUse() == TRUE) {
			cHttp.SetProxy(Cq2chwmConfig::GetInstance()->GetProxyHost(), Cq2chwmConfig::GetInstance()->GetProxyPort());
			cHttp.SetProxyAuth(Cq2chwmConfig::GetInstance()->GetProxyId(), Cq2chwmConfig::GetInstance()->GetProxyPass());
		}
		cHttp.SetCallbackProc(CMainFrame::CallbackProc, AfxGetMainWnd());
		cHttp.SetKeepAlive(TRUE);
		if (cHttp.Connect(TIMEOUT) == FALSE) {
			in_ret = ERR_HTTP_CONNECT;
			break;
		}

		if (cHttp.Get() == FALSE) {
			in_ret = ERR_HTTP_GET;
			break;
		}

		if (cHttp.GetResultCode() < 200 || cHttp.GetResultCode() >= 300) {
			in_ret = ERR_HTTP_GET;
			break;
		}

		cConfig.WriteString("Url", chp_url);
		cConfig.WriteString("CountAll", "-");
		cConfig.WriteInt("Count", 0);

		// T[rXʔƃNGXg擾
		CYoRegex cRegex("q=site%3A2ch.net%20([^&]+)&");
		if (cRegex.Match(chp_url) >= 0) {
			CYoString str_key = cRegex.Get(1);
			str_key.UrlDecode();
			cConfig.WriteString("Key", str_key);
		}

		CYoString str_tmp;
		char cha_buff[RECV_BUFF];
		while ((in_ret = cHttp.Recv(cha_buff, sizeof(cha_buff) - 1)) > 0) {
			int in_match = 0;
			cha_buff[in_ret] = 0x00;
			str_tmp += (const char*)cha_buff;
			int in_len = str_tmp.Length();

			// www.google.co.jp
			{
				//CYoString str_pat = "ʂ̂ <b>2ch.net</b> <b>{</b>̃y[W <b>([0-9,]+)</b> ";
				CYoString str_pat = " <b>[0-9]+</b> - <b>([0-9]+)</b> ";
				CYoRegex cRegexCount(str_pat, CYoRegex::SJIS, TRUE);
				in_match = cRegexCount.Match(str_tmp);
				if (in_match >= 0) {
					CYoString str_count = cRegexCount.Get(1);
					in_count_all = max(atoi((const char*)str_count), in_count_all);
					str_tmp.Remove(0, in_match + strlen(cRegexCount.Get(0)));
				}
			}

			{
				CYoString str_pat = "start=([0-9]+)";
				CYoRegex cRegexCount(str_pat, CYoRegex::SJIS, TRUE);
				in_match = cRegexCount.MatchR(str_tmp);
				if (in_match >= 0) {
					CYoString str_count = cRegexCount.Get(1);
					in_count_all = max(atoi((const char*)str_count) + 100, in_count_all);
				}
			}

			CYoString str_pat = "<a href=\"(http://[^/]+/)test/read.cgi/([^/]+)/([0-9]+)/[^>]+>(.+?)</a>";
			static CYoRegex cRegexData(str_pat, CYoRegex::SJIS, TRUE);
			while ((in_match = cRegexData.Match(str_tmp)) >= 0) {
				CYoString str_url = cRegexData.Get(1);
				CYoString str_bid = cRegexData.Get(2);
				str_url += str_bid + "/";
				CYoString str_bname;
				Cq2chwmBoardView *pView = ((Cq2chwmApp*)AfxGetApp())->GetBoardView();
				int in_find = pView->SearchFromId(str_bid);
				if (in_find >= 0) {
					str_bname = pView->GetBoardName(in_find);
				}
				CYoString str_id = cRegexData.Get(3);
				CYoString str_aname = cRegexData.Get(4);
				CYoString str_count;

				// &gt; <em>L[[h</em> &lt;݂ȊȂ̂<em>邽߂HTMLGR[h
				// < L[[h >ɂĂHTMLfR[h
				HtmlToText(str_aname);
				HtmlToText(str_bname);
				TextToHtml(str_aname);
				TextToHtml(str_bname);

				// d`FbN
				if (cTree.Get(str_id) == FALSE) {
					cTree.Add(str_id, 1);

					// Q˂錟subject.txt̃tH[}bg [XbhID].dat<>[Xbh] ([X])<>[URL]<>[]
					CYoString str_line;
					str_line.FormatAdd("%s.dat<>%s (%d)<>%s<>%s\n", (const char*)str_id, (const char*)str_aname, str_count.Atoi(),
									   (const char*)str_url, (const char*)str_bname);
					cFile.Write(str_line, str_line.Length());
				}

				in_count++;
				str_tmp.Remove(0, in_match + strlen(cRegexData.Get(0)));
			}

			// Content-LengthȂ猏ŃvOXo[\
			AfxGetMainWnd()->SendMessage(WM_USER_SETPROGRESS, in_count, in_count_all);
		}

		// ւΏI
		if (str_tmp.Find("<b></b>") == -1) break;

	} while (in_count < in_count_all);

	cConfig.WriteInt("Count", in_count);
	cConfig.WriteInt("CountAll", in_count_all);

	cFile.Close();

	// MG[`FbN
	if (((CMainFrame*)AfxGetMainWnd())->Canceled() == FALSE && in_ret != ERR_NONE) {
		return in_ret;
	}

	return CreateFromFile(chp_filename);
}

void Cq2chwmSubjectFile::Sort(
	int in_col,
	BOOL bo_asc)
{
	if (bo_asc == TRUE) {
		CYoPtrArray::Sort(Cq2chwmSubjectFile::compAsc, (const void*)in_col);
	} else {
		CYoPtrArray::Sort(Cq2chwmSubjectFile::compDesc, (const void*)in_col);
	}
}

int Cq2chwmSubjectFile::compAsc(
	const void *vop_user,
	const void *a,
	const void *b)
{
	int in_col = (int)vop_user;
	Cq2chwmSubjectItem *aa;
	Cq2chwmSubjectItem *bb;
	memcpy(&aa, (const void*)a, sizeof(Cq2chwmSubjectItem*));
	memcpy(&bb, (const void*)b, sizeof(Cq2chwmSubjectItem*));
	switch (in_col) {
	case IDX_INDEX:
		return aa->GetIndex() > bb->GetIndex() ? 1 : -1;
	case IDX_COUNT:
		return aa->GetCount() > bb->GetCount() ? 1 : -1;
	case IDX_ANAME:
		return strcmp(aa->GetArticleName(), bb->GetArticleName());
	case IDX_AID:
		return atoi(aa->GetArticleId()) > atoi(bb->GetArticleId()) ? 1 : -1;
	case IDX_NEW:
	{
		// V, VANoŃ\[g
		return MAKESORTINT(bb->GetNew() * 10 + bb->GetNewThread(), bb->GetCountNew(), -bb->GetIndex()) >
			MAKESORTINT(aa->GetNew() * 10 + aa->GetNewThread(), aa->GetCountNew(), -aa->GetIndex()) ? 1 : -1;
	}
	case IDX_SEARCH:
	{
		// tO, NoŃ\[g
		return MAKESORTINT(bb->GetSearch(), -bb->GetIndex(), 0) >
			MAKESORTINT(aa->GetSearch(), -aa->GetIndex(), 0) ? 1 : -1;
	}
	case IDX_CACHE:
	{
		// LbVL, XbhIDŃ\[g
		return MAKESORTINT(bb->GetCache(), -bb->GetIndex(), 0) >
			MAKESORTINT(aa->GetCache(), -aa->GetIndex(), 0) ? 1 : -1;
	}
	case IDX_BNAME:
		return strcmp(aa->GetBoardName(), bb->GetBoardName());
	case IDX_COUNTPERDAY:
		return aa->GetCountPerDay() > bb->GetCountPerDay() ? 1 : -1;
	}
	return 0;
}

int Cq2chwmSubjectFile::compDesc(
	const void *vop_user,
	const void *a,
	const void *b)
{
	int in_col = (int)vop_user;
	Cq2chwmSubjectItem *aa;
	Cq2chwmSubjectItem *bb;
	memcpy(&aa, (const void*)a, sizeof(Cq2chwmSubjectItem*));
	memcpy(&bb, (const void*)b, sizeof(Cq2chwmSubjectItem*));
	switch (in_col) {
	case IDX_INDEX:
		return aa->GetIndex() < bb->GetIndex() ? 1 : -1;
	case IDX_COUNT:
		return aa->GetCount() < bb->GetCount() ? 1 : -1;
	case IDX_ANAME:
		return strcmp(bb->GetArticleName(), aa->GetArticleName());
	case IDX_AID:
		return atoi(aa->GetArticleId()) < atoi(bb->GetArticleId()) ? 1 : -1;
	case IDX_BNAME:
		return strcmp(bb->GetBoardName(), aa->GetBoardName());
	case IDX_COUNTPERDAY:
		return aa->GetCountPerDay() < bb->GetCountPerDay() ? 1 : -1;
	}
	return 0;
}
