﻿// M.J. Kilgardの材質カラーサンプル

#pragma once

#include <stdio.h>

#include "Material.h"


namespace lgr
{


namespace MaterialSamples
{

enum MaterialSampleType
{
	MAT_NONE           , //!< 未定値
	MAT_EMERALD        , //<! emerald (エメラルド)
	MAT_JADE           , //<! jade (翡翠)
	MAT_OBSIDIAN       , //<! obsidian (黒曜石)
	MAT_PEARL          , //<! pearl (真珠)
	MAT_RUBY           , //<! ruby (ルビー)
	MAT_TURQUOISE      , //<! turquoise (トルコ石)
	MAT_BRASS          , //<! brass (真鍮)
	MAT_BRONZE         , //<! bronze (青銅)
	MAT_CHROME         , //<! chrome (クローム)
	MAT_COPPER         , //<! copper (銅)
	MAT_GOLD           , //<! gold (金)
	MAT_SILVER         , //<! silver (銀)
	MAT_BLACK_PLASTIC  , //<! プラスチック (黒)
	MAT_CYAN_PLASTIC   , //<! プラスチック (シアン)
	MAT_GREEN_PLASTIC  , //<! プラスチック (緑)
	MAT_RED_PLASTIC    , //<! プラスチック (赤)
	MAT_WHITE_PLASTIC  , //<! プラスチック (白)
	MAT_YELLOW_PLASTIC , //<! プラスチック (黄)
	MAT_BLACK_RUBBER   , //<! ゴム(黒)
	MAT_CYAN_RUBBER    , //<! ゴム(シアン)
	MAT_GREEN_RUBBER   , //<! ゴム(緑)
	MAT_RED_RUBBER     , //<! ゴム(赤)
	MAT_WHITE_RUBBER   , //<! ゴム(白)
	MAT_YELLOW_RUBBER  , //<! ゴム(黄)
};

}


namespace MaterialSamples
{

// emerald (エメラルド)  
const float emerald_ambient   [] = { 0.02150f , 0.174500f , 0.02150f , 1.0f },
            emerald_diffuse   [] = { 0.07568f , 0.614240f , 0.07568f , 1.0f },
            emerald_specular  [] = { 0.63300f , 0.727811f , 0.63300f , 1.0f },
            emerald_shininess [] = { 76.8f };
// jade (翡翠)  
const float jade_ambient   [] = { 0.135000f , 0.222500f , 0.157500f , 1.0f },
            jade_diffuse   [] = { 0.540000f , 0.890000f , 0.630000f , 1.0f },
            jade_specular  [] = { 0.316228f , 0.316228f , 0.316228f , 1.0f },
            jade_shininess [] = { 12.8f };
// obsidian (黒曜石)  
const float obsidian_ambient   [] = { 0.053750f , 0.050000f , 0.066250f , 1.0f },
            obsidian_diffuse   [] = { 0.182750f , 0.170000f , 0.225250f , 1.0f },
            obsidian_specular  [] = { 0.332741f , 0.328634f , 0.346435f , 1.0f },
            obsidian_shininess [] = { 38.4f };
// pearl (真珠)  
const float pearl_ambient   [] = { 0.250000f , 0.207250f , 0.207250f , 1.0f },
            pearl_diffuse   [] = { 1.000000f , 0.829000f , 0.829000f , 1.0f },
            pearl_specular  [] = { 0.296648f , 0.296648f , 0.296648f , 1.0f },
            pearl_shininess [] = { 10.24f };
// ruby (ルビー)  
const float ruby_ambient   [] = { 0.174500f , 0.011750f , 0.011750f , 1.0f },
            ruby_diffuse   [] = { 0.614240f , 0.041360f , 0.041360f , 1.0f },
            ruby_specular  [] = { 0.727811f , 0.626959f , 0.626959f , 1.0f },
            ruby_shininess [] = { 76.8f };
// turquoise (トルコ石)  
const float turquoise_ambient   [] = { 0.100000f , 0.18725f , 0.174500f , 1.0f },
            turquoise_diffuse   [] = { 0.396000f , 0.74151f , 0.691020f , 1.0f },
            turquoise_specular  [] = { 0.297254f , 0.30829f , 0.306678f , 1.0f },
            turquoise_shininess [] = { 12.8f };
// brass (真鍮)  
const float brass_ambient   [] = { 0.329412f ,  0.223529f , 0.027451f , 1.0f },
            brass_diffuse   [] = { 0.780392f ,  0.568627f , 0.113725f , 1.0f },
            brass_specular  [] = { 0.992157f ,  0.941176f , 0.807843f , 1.0f },
            brass_shininess [] = { 27.89743616f };
// bronze (青銅)  
const float bronze_ambient   [] = { 0.212500f , 0.127500f , 0.054000f , 1.0f },
            bronze_diffuse   [] = { 0.714000f , 0.428400f , 0.181440f , 1.0f },
            bronze_specular  [] = { 0.393548f , 0.271906f , 0.166721f , 1.0f },
            bronze_shininess [] = { 25.6f };
// chrome (クローム)  
const float chrome_ambient   [] = { 0.250000f , 0.250000f , 0.250000f , 1.0f },
            chrome_diffuse   [] = { 0.400000f , 0.400000f , 0.400000f , 1.0f },
            chrome_specular  [] = { 0.774597f , 0.774597f , 0.774597f , 1.0f },
            chrome_shininess [] = { 76.8f };
// copper (銅)  
const float copper_ambient   [] = { 0.191250f , 0.073500f , 0.022500f ,1.0f },
            copper_diffuse   [] = { 0.703800f , 0.270480f , 0.082800f ,1.0f },
            copper_specular  [] = { 0.256777f , 0.137622f , 0.086014f ,1.0f },
            copper_shininess [] = { 12.8f };
// gold (金)  
const float gold_ambient   [] = { 0.247250f , 0.199500f , 0.074500f , 1.0f },
            gold_diffuse   [] = { 0.751640f , 0.606480f , 0.226480f , 1.0f },
            gold_specular  [] = { 0.628281f , 0.555802f , 0.366065f , 1.0f },
            gold_shininess [] = { 51.2f };
// silver (銀)  
const float silver_ambient   [] = { 0.192250f , 0.192250f , 0.192250f , 1.0f },
            silver_diffuse   [] = { 0.507540f , 0.507540f , 0.507540f , 1.0f },
            silver_specular  [] = { 0.508273f , 0.508273f , 0.508273f , 1.0f },
            silver_shininess [] = { 51.2f };
// プラスチック (黒)  
const float black_plastic_ambient   [] = { 0.00f , 0.00f , 0.00f , 1.0f },
            black_plastic_diffuse   [] = { 0.01f , 0.01f , 0.01f , 1.0f },
            black_plastic_specular  [] = { 0.50f , 0.50f , 0.50f , 1.0f },
            black_plastic_shininess [] = { 32.0f };
// プラスチック (シアン)  
const float cyan_plastic_ambient   [] = { 0.00000000f , 0.10000000f , 0.06000000f , 1.0f },
            cyan_plastic_diffuse   [] = { 0.00000000f , 0.50980392f , 0.50980392f , 1.0f },
            cyan_plastic_specular  [] = { 0.50196078f , 0.50196078f , 0.50196078f , 1.0f },
            cyan_plastic_shininess [] = { 32.0f };
// プラスチック (緑)  
const float green_plastic_ambient   [] = { 0.00f , 0.00f , 0.00f , 1.0f },
            green_plastic_diffuse   [] = { 0.10f , 0.35f , 0.10f , 1.0f },
            green_plastic_specular  [] = { 0.45f , 0.55f , 0.45f , 1.0f },
            green_plastic_shininess [] = { 32.0f };
// プラスチック (赤)  
const float red_plastic_ambient   [] = { 0.0f , 0.0f , 0.0f , 1.0f },
            red_plastic_diffuse   [] = { 0.5f , 0.0f , 0.0f , 1.0f },
            red_plastic_specular  [] = { 0.7f , 0.6f , 0.6f , 1.0f },
            red_plastic_shininess [] = { 32.0f };
// プラスチック (白)  
const float white_plastic_ambient   [] = { 0.00f , 0.00f , 0.00f , 1.0f },
            white_plastic_diffuse   [] = { 0.55f , 0.55f , 0.55f , 1.0f },
            white_plastic_specular  [] = { 0.70f , 0.70f , 0.70f , 1.0f },
            white_plastic_shininess [] = { 32.0f };
// プラスチック (黄)  
const float yellow_plastic_ambient   [] = { 0.00f , 0.00f , 0.00f , 1.0f },
            yellow_plastic_diffuse   [] = { 0.50f , 0.50f , 0.00f , 1.0f },
            yellow_plastic_specular  [] = { 0.60f , 0.60f , 0.50f , 1.0f },
            yellow_plastic_shininess [] = { 32.0f };
// ゴム(黒)  
const float black_rubber_ambient   [] = { 0.02f , 0.02f , 0.02f , 1.0f },
            black_rubber_diffuse   [] = { 0.01f , 0.01f , 0.01f , 1.0f },
            black_rubber_specular  [] = { 0.40f , 0.40f , 0.40f , 1.0f },
            black_rubber_shininess [] = { 10.0f };
// ゴム(シアン)  
const float cyan_rubber_ambient   [] = { 0.00f , 0.05f , 0.05f , 1.0f },
            cyan_rubber_diffuse   [] = { 0.40f , 0.50f , 0.50f , 1.0f },
            cyan_rubber_specular  [] = { 0.04f , 0.70f , 0.70f , 1.0f },
            cyan_rubber_shininess [] = { 10.0f };
// ゴム(緑)  
const float green_rubber_ambient   [] = { 0.00f , 0.05f , 0.00f , 1.0f },
            green_rubber_diffuse   [] = { 0.40f , 0.50f , 0.40f , 1.0f },
            green_rubber_specular  [] = { 0.04f , 0.70f , 0.04f , 1.0f },
            green_rubber_shininess [] = { 10.0f };
// ゴム(赤)  
const float red_rubber_ambient   [] = { 0.05f , 0.00f , 0.00f ,  1.0f },
            red_rubber_diffuse   [] = { 0.50f , 0.40f , 0.40f ,  1.0f },
            red_rubber_specular  [] = { 0.70f , 0.04f , 0.04f , 1.0f },
            red_rubber_shininess [] = { 10.0f };
// ゴム(白)  
const float white_rubber_ambient   [] = { 0.05f , 0.05f , 0.05f , 1.0f },
            white_rubber_diffuse   [] = { 0.50f , 0.50f , 0.50f , 1.0f },
            white_rubber_specular  [] = { 0.70f , 0.70f , 0.70f , 1.0f },
            white_rubber_shininess [] = { 10.0f };
// ゴム(黄)  
const float yellow_rubber_ambient   [] = { 0.05f , 0.05f , 0.00f , 1.0f },
            yellow_rubber_diffuse   [] = { 0.50f , 0.50f , 0.40f , 1.0f },
            yellow_rubber_specular  [] = { 0.70f , 0.70f , 0.04f , 1.0f },
            yellow_rubber_shininess [] = { 10.0f };
}


namespace MaterialSamples
{

inline const float* GetAmbient(MaterialSampleType mat_type)
{
	switch(mat_type)
	{
	case MAT_EMERALD        : return emerald_ambient        ;
	case MAT_JADE           : return jade_ambient           ;
	case MAT_OBSIDIAN       : return obsidian_ambient       ;
	case MAT_PEARL          : return pearl_ambient          ;
	case MAT_RUBY           : return ruby_ambient           ;
	case MAT_TURQUOISE      : return turquoise_ambient      ;
	case MAT_BRASS          : return brass_ambient          ;
	case MAT_BRONZE         : return bronze_ambient         ;
	case MAT_CHROME         : return chrome_ambient         ;
	case MAT_COPPER         : return copper_ambient         ;
	case MAT_GOLD           : return gold_ambient           ;
	case MAT_SILVER         : return silver_ambient         ;
	case MAT_BLACK_PLASTIC  : return black_plastic_ambient  ;
	case MAT_CYAN_PLASTIC   : return cyan_plastic_ambient   ;
	case MAT_GREEN_PLASTIC  : return green_plastic_ambient  ;
	case MAT_RED_PLASTIC    : return red_plastic_ambient    ;
	case MAT_WHITE_PLASTIC  : return white_plastic_ambient  ;
	case MAT_YELLOW_PLASTIC : return yellow_plastic_ambient ;
	case MAT_BLACK_RUBBER   : return black_rubber_ambient   ;
	case MAT_CYAN_RUBBER    : return cyan_rubber_ambient    ;
	case MAT_GREEN_RUBBER   : return green_rubber_ambient   ;
	case MAT_RED_RUBBER     : return red_rubber_ambient     ;
	case MAT_WHITE_RUBBER   : return white_rubber_ambient   ;
	case MAT_YELLOW_RUBBER  : return yellow_rubber_ambient  ;
	default:
		return NULL;
	}
}

inline const float* GetDiffuse(MaterialSampleType mat_type)
{
	switch(mat_type)
	{
	case MAT_EMERALD        : return emerald_diffuse        ;
	case MAT_JADE           : return jade_diffuse           ;
	case MAT_OBSIDIAN       : return obsidian_diffuse       ;
	case MAT_PEARL          : return pearl_diffuse          ;
	case MAT_RUBY           : return ruby_diffuse           ;
	case MAT_TURQUOISE      : return turquoise_diffuse      ;
	case MAT_BRASS          : return brass_diffuse          ;
	case MAT_BRONZE         : return bronze_diffuse         ;
	case MAT_CHROME         : return chrome_diffuse         ;
	case MAT_COPPER         : return copper_diffuse         ;
	case MAT_GOLD           : return gold_diffuse           ;
	case MAT_SILVER         : return silver_diffuse         ;
	case MAT_BLACK_PLASTIC  : return black_plastic_diffuse  ;
	case MAT_CYAN_PLASTIC   : return cyan_plastic_diffuse   ;
	case MAT_GREEN_PLASTIC  : return green_plastic_diffuse  ;
	case MAT_RED_PLASTIC    : return red_plastic_diffuse    ;
	case MAT_WHITE_PLASTIC  : return white_plastic_diffuse  ;
	case MAT_YELLOW_PLASTIC : return yellow_plastic_diffuse ;
	case MAT_BLACK_RUBBER   : return black_rubber_diffuse   ;
	case MAT_CYAN_RUBBER    : return cyan_rubber_diffuse    ;
	case MAT_GREEN_RUBBER   : return green_rubber_diffuse   ;
	case MAT_RED_RUBBER     : return red_rubber_diffuse     ;
	case MAT_WHITE_RUBBER   : return white_rubber_diffuse   ;
	case MAT_YELLOW_RUBBER  : return yellow_rubber_diffuse  ;
	default:
		return NULL;
	}
}

inline const float* GetSpecular(MaterialSampleType mat_type)
{
	switch(mat_type)
	{
	case MAT_EMERALD        : return emerald_specular        ;
	case MAT_JADE           : return jade_specular           ;
	case MAT_OBSIDIAN       : return obsidian_specular       ;
	case MAT_PEARL          : return pearl_specular          ;
	case MAT_RUBY           : return ruby_specular           ;
	case MAT_TURQUOISE      : return turquoise_specular      ;
	case MAT_BRASS          : return brass_specular          ;
	case MAT_BRONZE         : return bronze_specular         ;
	case MAT_CHROME         : return chrome_specular         ;
	case MAT_COPPER         : return copper_specular         ;
	case MAT_GOLD           : return gold_specular           ;
	case MAT_SILVER         : return silver_specular         ;
	case MAT_BLACK_PLASTIC  : return black_plastic_specular  ;
	case MAT_CYAN_PLASTIC   : return cyan_plastic_specular   ;
	case MAT_GREEN_PLASTIC  : return green_plastic_specular  ;
	case MAT_RED_PLASTIC    : return red_plastic_specular    ;
	case MAT_WHITE_PLASTIC  : return white_plastic_specular  ;
	case MAT_YELLOW_PLASTIC : return yellow_plastic_specular ;
	case MAT_BLACK_RUBBER   : return black_rubber_specular   ;
	case MAT_CYAN_RUBBER    : return cyan_rubber_specular    ;
	case MAT_GREEN_RUBBER   : return green_rubber_specular   ;
	case MAT_RED_RUBBER     : return red_rubber_specular     ;
	case MAT_WHITE_RUBBER   : return white_rubber_specular   ;
	case MAT_YELLOW_RUBBER  : return yellow_rubber_specular  ;
	default:
		return NULL;
	}
}

inline const float* GetShininess(MaterialSampleType mat_type)
{
	switch(mat_type)
	{
	case MAT_EMERALD        : return emerald_shininess        ;
	case MAT_JADE           : return jade_shininess           ;
	case MAT_OBSIDIAN       : return obsidian_shininess       ;
	case MAT_PEARL          : return pearl_shininess          ;
	case MAT_RUBY           : return ruby_shininess           ;
	case MAT_TURQUOISE      : return turquoise_shininess      ;
	case MAT_BRASS          : return brass_shininess          ;
	case MAT_BRONZE         : return bronze_shininess         ;
	case MAT_CHROME         : return chrome_shininess         ;
	case MAT_COPPER         : return copper_shininess         ;
	case MAT_GOLD           : return gold_shininess           ;
	case MAT_SILVER         : return silver_shininess         ;
	case MAT_BLACK_PLASTIC  : return black_plastic_shininess  ;
	case MAT_CYAN_PLASTIC   : return cyan_plastic_shininess   ;
	case MAT_GREEN_PLASTIC  : return green_plastic_shininess  ;
	case MAT_RED_PLASTIC    : return red_plastic_shininess    ;
	case MAT_WHITE_PLASTIC  : return white_plastic_shininess  ;
	case MAT_YELLOW_PLASTIC : return yellow_plastic_shininess ;
	case MAT_BLACK_RUBBER   : return black_rubber_shininess   ;
	case MAT_CYAN_RUBBER    : return cyan_rubber_shininess    ;
	case MAT_GREEN_RUBBER   : return green_rubber_shininess   ;
	case MAT_RED_RUBBER     : return red_rubber_shininess     ;
	case MAT_WHITE_RUBBER   : return white_rubber_shininess   ;
	case MAT_YELLOW_RUBBER  : return yellow_rubber_shininess  ;
	default:
		return NULL;
	}
}

}


namespace MaterialSamples
{

inline Material GetMaterial(MaterialSampleType mat_type)
{
	return Material( GetAmbient(mat_type) , GetDiffuse(mat_type) , GetSpecular(mat_type) , GetShininess(mat_type)[0] );
}

inline Material GetEmerald        () { return GetMaterial( MAT_EMERALD        ); }
inline Material GetJade           () { return GetMaterial( MAT_JADE           ); }
inline Material GetObsidian       () { return GetMaterial( MAT_OBSIDIAN       ); }
inline Material GetPearl          () { return GetMaterial( MAT_PEARL          ); }
inline Material GetRuby           () { return GetMaterial( MAT_RUBY           ); }
inline Material GetTurquoise      () { return GetMaterial( MAT_TURQUOISE      ); }
inline Material GetBrass          () { return GetMaterial( MAT_BRASS          ); }
inline Material GetBronze         () { return GetMaterial( MAT_BRONZE         ); }
inline Material GetChrome         () { return GetMaterial( MAT_CHROME         ); }
inline Material GetCopper         () { return GetMaterial( MAT_COPPER         ); }
inline Material GetGold           () { return GetMaterial( MAT_GOLD           ); }
inline Material GetSilver         () { return GetMaterial( MAT_SILVER         ); }
inline Material GetPlastic_Black  () { return GetMaterial( MAT_BLACK_PLASTIC  ); }
inline Material GetPlastic_Cyan   () { return GetMaterial( MAT_CYAN_PLASTIC   ); }
inline Material GetPlastic_Green  () { return GetMaterial( MAT_GREEN_PLASTIC  ); }
inline Material GetPlastic_Red    () { return GetMaterial( MAT_RED_PLASTIC    ); }
inline Material GetPlastic_White  () { return GetMaterial( MAT_WHITE_PLASTIC  ); }
inline Material GetPlastic_Yellow () { return GetMaterial( MAT_YELLOW_PLASTIC ); }
inline Material GetRubber_Black   () { return GetMaterial( MAT_BLACK_RUBBER   ); }
inline Material GetRubber_Cyan    () { return GetMaterial( MAT_CYAN_RUBBER    ); }
inline Material GetRubber_Green   () { return GetMaterial( MAT_GREEN_RUBBER   ); }
inline Material GetRubber_Red     () { return GetMaterial( MAT_RED_RUBBER     ); }
inline Material GetRubber_White   () { return GetMaterial( MAT_WHITE_RUBBER   ); }
inline Material GetRubber_Yellow  () { return GetMaterial( MAT_YELLOW_RUBBER  ); }


}
}
