#pragma once

#include <vector>

#include <C2/lm/vector3.h>

#include "Mesh/BaseMesh.h"
#include "Shape.h"

#include "CrossSectionUnit.h"
#include "CSCache.h"



namespace lib_geo
{


class CrossSection
{
public:
	enum CrossSectionMode
	{
		CS_EACH_GROUP,
		CS_WHOLE,
	};

public:
	void Clear(void);

	void CreateCrossSection(const BaseMesh& mesh, const Plane& cut_plane, CrossSectionMode mode = CS_EACH_GROUP);

	void CreateCrossSectionWhole(const BaseMesh& mesh, const Plane& cut_plane);
	void CreateCrossSectionEachGroup(const BaseMesh& mesh, const Plane& cut_plane);

private:
	void VisitFace(const BaseMesh& mesh, std::vector<bool>& IsVisited, int fid);
	void VisitEdge(const BaseMesh& mesh, std::vector<bool>& IsVisited, int eid);
	void VisitVert(const BaseMesh& mesh, std::vector<bool>& IsVisited, int vid);

	void VistNextOnTouchToEdge(CSCache& cc, const BaseMesh& mesh, CSFace& cf, std::vector<bool>& IsVisited);
	void VistNextOnTouchToVert(CSCache& cc, const BaseMesh& mesh, CSFace& cf, std::vector<bool>& IsVisited);
	void VistNextOnIntersectStd(CSCache& cc, const BaseMesh& mesh, CSFace& cf, std::vector<bool>& IsVisited);

public:
	Plane m_CutPlane;
	std::vector<CrossSectionUnit> m_Sections;
};


}
