#include "stdafx.h"
#include "DbgTimer.h"

#include <sstream>
using namespace std;



DbgTimer::DbgTimer(const char* TimerName) :
	Active(false)
{
	ResetTime();
}

DbgTimer::~DbgTimer(void)
{
	Report("End : ");
}

void DbgTimer::TerminateReport(const char* msg)
{
	Report(msg);
	Active = false;
}

void DbgTimer::Report(const char* msg, bool ResetTime)
{
	if (!Active)
		return;

	DWORD t = GetTickCount();

	ostringstream s;

	s << "[" << Name << "] (" << msg << ") " << t - LastTime << endl;
	OutputDebugStringA(s.str().c_str());

	if (ResetTime)
		LastTime = t;
}

void DbgTimer::ResetTime(void)
{
	Active = true;
	LastTime = GetTickCount();
}
