#ifndef __LIB_TEST_DEBUG_STREAM_A_H__
#define __LIB_TEST_DEBUG_STREAM_A_H__


#include <windows.h>

#include <iostream>
#include <vector>

#include <tchar.h>


namespace LibTest
{


class DebugStreambufA : public std::streambuf 
{
public:
	virtual int_type overflow( int_type i_char = EOF )
	{
		if( m_buf.empty() )
			m_buf.push_back( char(i_char) );
		else
			m_buf.back() = char(i_char);

		m_buf.push_back( char('\0') );

		return i_char;
	}

	virtual int sync(void)
	{
		if( !m_buf.empty() )
		{
			OutputDebugStringA( &m_buf[0] );
			m_buf.clear();
		}
		return 0;
	}

private:
	std::vector<char> m_buf;
};


class DebugStreamA : public std::ostream
{
public:
	DebugStreamA(void) : std::ostream( &m_buf )
	{}

private:
	DebugStreambufA m_buf;
};


class DebugStreamAdapterA
{
public:
	template<typename T>
	std::ostream& operator<<(T& t)
	{
		return ( GetDebugStream() << t ); 
	}

	template<typename T>
	std::ostream& operator<<(const T& t)
	{
		return ( GetDebugStream() << t );
	}

	operator std::ostream&()
	{
		return GetDebugStream(); 
	}
	
	std::ostream& operator<<( std::ostream& (__cdecl *_func_ptr)( std::ostream& ) )
	{
		return _func_ptr( GetDebugStream() );
	}

	DebugStreamA* operator&(void)
	{
		return &GetDebugStream(); 
	}

	void flush(void)
	{
		GetDebugStream().flush();
	}


private:
	static DebugStreamA& GetDebugStream(void)
	{
		static DebugStreamA debug_stream;
		return debug_stream;
	}
};


}


#endif
