#include "stdafx.h"
#include "SeqTrans.h"



namespace geom
{


bool SeqTrans::HasKey(void) const
{
	if (!m_Rotate.empty())
		return true;
	if (!m_Scale.empty())
		return true;
	if (!m_Translate.empty())
		return true;
	return false;
}

int SeqTrans::GetNumframes(void) const
{
	int st = (int)m_Translate.size();
	int ss = (int)m_Rotate.size();
	int sr = (int)m_Scale.size();
	return (lm::max)(st, ss, sr);
}

lm::matrix4f SeqTrans::GetTransform(int frame) const
{
	int max_kf = GetNumframes();
	int fn = (lm::clamp)(0, frame, max_kf - 1);

	lm::matrix4f mt = lm::matrix4f::get_identity();

	if (!m_Scale.empty())
	{
		const lm::vec3f& s = m_Scale[fn];
		mt *= lm::matrix4f::get_scale(s.x, s.y, s.z);
	}

	if (!m_Rotate.empty())
	{
		float vel;
		lm::vec3f ax;
		m_Rotate[fn].get_rotate_params(ax, vel);
		mt *= lm::matrix4f::get_rotate(ax, vel);
	}

	if (!m_Translate.empty())
	{
		lm::vec3f d = m_Translate[fn];
		mt *= lm::matrix4f::get_translate(d);
	}

	return mt;
}

void SeqTrans::Clear(void)
{
	m_Translate.clear();
	m_Rotate.clear();
	m_Scale.clear();

	m_KeyIdxOffset = 0;
}


}
