#pragma once

#include "../PostProcBuffer.h"



class PostprocContext
{
public:
	PostprocContext(MultPathRenderBuf* buffer) :
		m_Buffer(buffer),
		m_Width(0),
		m_Height(0),
		m_LookDepth(0.0f),
		m_DOFPintPos(0.5f),
		m_DOFRange(5.0f)
	{
	}

public:
	MultPathRenderBuf* m_Buffer;

	int m_Width;
	int m_Height;

	float m_LookDepth;

	float m_DOFPintPos;
	float m_DOFRange;
};


class PostprocInterface
{
public:
	PostprocInterface(PostprocContext* context) :
		m_Context(context)
	{
	}

	virtual const char* GetPostProcName(void) = 0;

	virtual void BeginRender(void) = 0;
	virtual void EndRender(void) = 0;

	//! PostprocessɕKvȃpX
	virtual size_t NumPath(void)
	{
		return 1;
	}

	//! epX̃r[|[gTCYύX
	virtual double GetImageSizeRatio(size_t path)
	{
		return 1.0;
	}

protected:
	void SetStandardSiinglePathPPTextureConfig(lib_gl::GlslProgram& shader);

protected:
	PostprocContext* m_Context;
};
