## Borland C++ Compiler 5.5 generic make
## Mc.N (kfb02545@nifty.ne.jp)
##
## 00.05.30 : first making 
##

##################################################
## generic make setting...
## If you change default .mak setting, BEGIN-END flag override.
## note : * is default setting
##################################################

### <--- BEGIN BEGIN BEGIN ---> ###

## TARGET = CONSOLE  # *CONSOLE, WIN32GUI, WIN32DLL, ... and more

TARGET = WIN32GUI

## MT     = 0        # *0(single thread), 1(multi thread)
## ALIGN  = 8        # 1(BYTE), 2(WORD), 4(DWORD), *8(QWORD).
## CPUOPT = 3        # *3(i386), 4(i486), 5(Pentium), 6(PentiumPro)

CPUOPT = 5

## DEBUG  = 0        # *0(release), 1(debug)

DEBUG  = 1

##                   # (note) BCB is not make debug symbol ;-(... You don't have debug.
## OPTIMIZE = 1      # 0(No optimize), *1(size), 2(speed), 3(size&speed, and more). debug mode is 0.

OPTIMIZE = 2

## PRECOMPILE = 1    # *0(No use), 1(Use pre-compiled header)

PRECOMPILE = 1

## NOPATCHS  = 0     # 1 is no need patchs. default is 0 (under patch included)
## WINVER    = 0x400 # (patch) Why? BCC5.5 is default 0x500. You need only W2K program?
## IE_VER    = 0x300 # (patch) Why? BCC5.5 is default 0x501. I think no need IE function.
## WINNT_VER = 0x400 # (patch)

## BCBMAKEPATH = C:\Borland\Bcc55\bin
##   If you cannot use default BCB make.exe, you must set Borland bin path.

## ENABLEDIRECTX = 0 # 1 is include directx setting. default is 0
## DIRECTXPATH = C:\mssdk
##   If you cannot use default BCB include and lib, you must set directx path.
##   (note) If you installed Platform SDK too, maybe you have meny error... I don't know ;-(.

### <--- END END END ---> ###

!ifndef BCBMAKEPATH
BCBMAKEPATH = $(MAKEDIR)
!endif
INCLUDEPATH = $(BCBMAKEPATH)\..\include;$(INCLUDEPATH)
LIBRARYPATH = $(BCBMAKEPATH)\..\lib;$(BCBMAKEPATH)\..\lib\PSDK;$(LIBRARYPATH)

!ifndef ENABLEDIRECTX
ENABLEDIRECTX = 0
!endif
!if $(ENABLEDIRECTX) != 0
MT = 1
!ifdef DIRECTXPATH
INCLUDEPATH = $(DIRECTXPATH)\include;$(INCLUDEPATH)
LIBRARYPATH = $(DIRECTXPATH)\lib\Borland;$(LIBRARYPATH)
!else
  !error [WIN32B55.MAK] You must set DirectX SDK path (DIRECTXPATH)! BCB lib is good for nothing.
!endif
!endif

TGTFLG  =
LIBSUF  =
TARGSUF =
LINKSUF =
LINKSTARTUP =

## multi thread support?
!ifndef MT
  MT = 0
!endif
!if $(MT) == 0
  TGTFLG = $(TGTFLG) -WM-
  LIBSUF =
!else
  !message [WIN32B55.MAK] Multi thread library used
  TGTFLG = $(TGTFLG) -WM
  LIBSUF = mt
!endif

## build target
!ifndef TARGET
  !message [WIN32B55.MAK] default target build is CONSOLE...
  TARGET = CONSOLE
!endif
!if $(TARGET) == CONSOLE
  TGTFLG  = $(TGTFLG) -WC
  LIBSUF  = $(LIBSUF)
  TARGSUF =
  LINKSUF = -Tpe -ap
  LINKSTARTUP = c0x32.obj
!elif $(TARGET) == WIN32GUI
  TGTFLG  = $(TGTFLG) -W
  LIBSUF  = $(LIBSUF)
  TARGSUF =
  LINKSUF = -Tpe -aa
  LINKSTARTUP = c0w32.obj
!elif $(TARGET) == WIN32DLL
  TGTFLG = $(TGTFLG) -WD
  TARGSUF=R
  LIBSUF=$(LIBSUF)i
  LINKSUF = -Tpd -aa
  LINKSTARTUP = c0d32.obj
!else
  !error 
!endif

## Alignment settting ---> DWORD
!ifndef ALIGN
  ALIGN = 8
!endif
!if !($(ALIGN)==1|| $(ALIGN)==2|| $(ALIGN)==4|| $(ALIGN)==8)
  !error [WIN32B55.MAK] error found ALIGN.
!endif

## CPU Optimize ---> i386
!ifndef CPUOPT
  CPUOPT = 3
!endif
!if $(CPUOPT) < 3 || $(CPUOPT) > 6
  !error [WIN32B55.MAK] error found CPUOPT.
!endif

## debug option
!if $(DEBUG) != 0
  !message [WIN32B55.MAK] debug build version
  DEBFLG = -v
  CDEBUG = -N
!else
  !message [WIN32B55.MAK] release build version
!endif

## Optimize compile
!ifndef OPTIMIZE
  OPTIMIZE = 1
!endif
!if $(OPTIMIZE) == 0 || $(DEBUG) != 0
  CFLAGS  = $(CFLAGS) -Od
!elif $(OPTIMIZE) == 1
  CFLAGS  = $(CFLAGS) -O1
!elif $(OPTIMIZE) == 2
  CFLAGS  = $(CFLAGS) -O2
!elif $(OPTIMIZE) == 3
  CFLAGS  = $(CFLAGS) -O1 -O2 -Oi -Oc
!else
  !error [WIN32B55.MAK] error found OPTIMIZE.
!endif

## pre-compiled header
!ifndef PRECOMPILE
  PRECOMPILE = 0
!endif
!if $(PRECOMPILE) == 1
  CFLAGS  = $(CFLAGS) -H -Hs
!endif

## patchs
!ifndef NOPATCHS
  NOPATCHS = 0
!endif
!if $(NOPATCHS) == 0
!ifndef WINVER
  WINVER = 0x400
  !message [WIN32B55.MAK] default WINVER = 0x400.
!endif

!ifndef IE_VER
  IE_VER = 0x300
  !message [WIN32B55.MAK] default IE version = 0x300.
!endif

!ifndef WINNT_VER
  WINNT_VER = 0x400
  !message [WIN32B55.MAK] default WINNT version = 0x400.
!endif

PATCHDEF = $(PATCHDEF) -DWINVER=$(WINVER) -D_WIN32_IE=$(IE_VER) -D_WIN32_WINNT=$(WINNT_VER)

!endif # NOPATCHS

##
## FLAGS
##
CFLAGS      = -c $(DEBFLG) $(CDEBUG) $(CFLAGS) -$(CPUOPT) -a$(ALIGN) $(TGTFLG) -I"$(INCLUDEPATH)" -L"$(LIBRARYPATH)" $(PATCHDEF)
LINKFLAGS   = $(LINKSUF) $(DEBFLG) -c -x -L"$(LIBRARYPATH)"
LINKLIBS    = import32.lib cw32$(LIBSUF).lib
RCFLAGS     = -r -i"$(INCLUDEPATH)"


!if $(ENABLEDIRECTX) != 0
CFLAGS = -Vd $(CFLAGS)
CFLAGS = $(CFLAGS) -Dsinf=(FLOAT)sin
CFLAGS = $(CFLAGS) -Dcosf=(FLOAT)cos
CFLAGS = $(CFLAGS) -Dasinf=(FLOAT)asin
CFLAGS = $(CFLAGS) -Dacosf=(FLOAT)acos
CFLAGS = $(CFLAGS) -Dsqrtf=(FLOAT)sqrt
CFLAGS = $(CFLAGS) -Dexpf=(FLOAT)exp
LINKLIBS = $(LINKLIBS) ole2w32.lib
LINKLIBS = $(LINKLIBS) d3dim.lib d3drm.lib d3dxof.lib ddraw.lib dplayx.lib dsetup.lib dsound.lib dxguid.lib
## LINKLIBS = $(LINKLIBS) dinput.lib
## d3dframe=..\..\lib\borland\d3dframe.lib
!endif


##
## standard rules
##

CC   = bcc32
RC   = brc32
AS   = tasm32
CXX  = bcc32 -P
CPP  = bcc32 -P
CPP32 = cpp32
LINKER = ilink32
LINK   = ilink32
LIBRARIAN = tlib /P128

.asm.obj:
  $(AS) $(AFLAGS) -n$(OUT) $&.asm

.c.obj:
  $(CC) $(CFLAGS) -n$(OUT) $&.c

.cpp.obj:
  $(CC) $(CFLAGS) -n$(OUT) $&.cpp

.rc.res:
  $(RC) $(RCFLAGS) $&.rc  -fo$(OUT)$&

