//@STATE=쐬
//@DESCRIPTION ---------------------------------------------------------------
// DispositionControl.cpp: DispositionControl NX̃Cve[V
//	F
// $Log: DispositionControl.cpp,v $
// Revision 1.1  2001/10/28 21:40:35  fujiwara
// DLLɕ
//
// Revision 1.7  2001/07/01 21:30:33  fujiwara
// [N`FbN
//
// Revision 1.6  2001/07/01 01:03:43  fujiwara
// const ̌
// zuGfB^͓ro
//
// Revision 1.5  2001/05/17 12:34:10  fujiwara
// nGTv쐬
//
// Revision 1.4  2001/05/12 12:48:28  fujiwara
// zuGfB^쐬ɔύXEǉ
//
// Revision 1.3  2001/05/12 00:57:59  fujiwara
// (none)
//
//@DESCRIPTION_END -----------------------------------------------------------
//@AUTHOR=S.F.
// Copyright (C) 2000 Satoshi Fujiwara. All Rights Reserved.
///////////////////////////////////////////////////////////////////////////////
#pragma warning( disable : 4786 )	//STĽxO

// SYSTEM INCLUDES //
// [[Nop

#include "sfdebug.h"

#include <string>
#include <stack>
#include <list>
#include <iostream>
#include <fstream>
#include <vector>
#include <map>


// PROJECT INCLUDES //

#include "exception.h"
#include "system.h"
#include "sound.h"
#include "console.h"
#include "Obj.h"
#include "Obj2D.h"
#include "ObjRectangle.h"
#include "ObjQuadrangle.h"
#include "Obj3DL.h"
#include "Background.h"
#include "input.h"
#include "Scene.h"
#include "main.h"
#include "AbstractScene.h"
#include "character.h"
#include "Hit.h"
#include "MyShip.h"
#include "Game.h"
#include "Enemys.h"
#include "Armys.h"
#include "ZK01.h"
#include "DispositionControl.h"
#include "DispositionEditor.h"

#ifdef _DEBUG
#ifndef _BORLAND
#define new DEBUG_NEW
#endif
#endif


//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////


using namespace sf::application::disposition;
using namespace sf;
using namespace sf::application::disposition::command;

// R}h //
const std::string ControllerImpl::mCommand[command::MAX] = {
	"Reset",
	"SetScrollSpeed",
	"SetRestartPosition",
	"SetEnemy",
	"SetArmy"
};

const ControllerImpl::CreateFuncPtr ControllerImpl::mpCreateFunc[command::MAX] 
= {	&command::Reset::create,
	&command::SetScrollSpeed::create,
	&command::SetRestartPosition::create,
	&command::SetEnemy::create,
	&command::SetArmy::create
};

// RXgN^ |||||||||||||||||||||||||||||
ControllerImpl::ControllerImpl(){
}

// fXgN^ ||||||||||||||||||||||||||||||
ControllerImpl::~ControllerImpl(){
	for(CommandList::iterator it = mData.begin();it != mData.end();++it)
	{
		delete (*it).second;
	}
	mData.clear();
}

// f[^̃A[h ||||||||||||||||
void ControllerImpl::unload(void)
{
	for(CommandList::iterator it = mData.begin();it != mData.end();++it)
	{
		delete (*it).second;
	}
	mData.clear();

	// GeNX`̃A[h
	sf::application::enemy::Enemys::instance()->unload();
}// unload()

// zuf[^̃[h |||||||||||||||||||||||||||
void ControllerImpl::load(const char * const pFileName)
{
	mSerialNo = 0;
	unload();
	char err_loadstr[] = "ControllerImpl:load() Error!";
	
	std::fstream file(pFileName,std::ios::in);
	
	if(!file.is_open()){
		std::string  tmp;
		
		tmp += "File Open Error! ";
		tmp += "Disposition File ";
		tmp += pFileName;
		tmp += " Not Found!!";

		throw FatalErrorException(tmp,__FILE__,__LINE__);
	}
	
	mFileName = pFileName;
	
	int position,command_id;
	std::string command_str;

	while(!file.eof()){

			
		file >> position;
		
		if(file.fail())
			break;

		file >> command_str;
		command_id = findCommand(command_str);
		command_id--;
		
		command::Interface *pinterface = create((command::TYPE)command_id);
		pinterface->load(file);

		if(file.fail())
			throw FatalErrorException(err_loadstr,__FILE__,__LINE__);
		
		pinterface->game(game());
		insertCommand(position,pinterface);
	}
	mDataIter = mData.begin();
}//load()

// R}hT[`ÃCfbNXԂ |||||||||||||||
const int ControllerImpl::findCommand(const std::string &s)
{
	for(int i = 0;i < command::MAX;i++){
		if(s == mCommand[i]){
			i++;
			return i;
		}
	}
	throw FatalErrorException("ControllerImpl::findCommand() Command Parse Error!!",__FILE__,__LINE__);
	return 0;
}// findCommand()

// IuWFNg ||||||||||||||||||||||||||||
//command::Interface * ControllerImpl::create(command::TYPE command_id)
//{
//	return (mpCreateFunc[command_id])();
//}// create

// X^[gʒuɃR}h킹 |||||||||||||||||||
void ControllerImpl::restart(const float position){
	mDataIter = mData.begin();
	
	if(mDataIter == mData.end()) return;

	while(mDataIter != mData.end() && mDataIter->first < position)
	{
		mDataIter++;
	};
}//restart();


// f[^̃Z[u ||||||||||||||||||||||||||
void ControllerImpl::save(const char * const pMapFileName)
{
	std::string  err_savestr = "ControllerImpl:save() Error!";
	char *pfile_name;

	// t@Cl[NULL̏ꍇA[h̃t@Cl[gp
	if(pMapFileName == NULL){
		if(mFileName.c_str() == NULL){
			throw FatalErrorException(err_savestr,__FILE__,__LINE__);
		} else {
			pfile_name = const_cast<char*>(mFileName.c_str());
		}
	} else {
		pfile_name = const_cast<char*>(pMapFileName);
	}

	std::fstream file(pfile_name,std::ios::out);
	
	if(!file.is_open()){
		std::string tmp ="";
		tmp += "File Open Error! ";
		tmp += "Disposition File ";
		tmp += pMapFileName;
		tmp += " Not Found!!";
		throw FatalErrorException(tmp,__FILE__,__LINE__);
	}

	bool bflag = false;
	
	for(CommandList::iterator it = mData.begin();
			it != mData.end(); it++)
	{
		if(bflag)
			file << std::endl;

		file << it->first << " ";
		file << mCommand[it->second->id()];
		
		it->second->save(file);
		
		bflag = true;
		if(file.fail())
			throw FatalErrorException(err_savestr,__FILE__,__LINE__);
	}
}// save()

// R}h̎s |||||||||||||||||||||||||||||
void ControllerImpl::exec(const float position){
	
	if(mDataIter->first > position || mDataIter == mData.end())
		return;

	while(mDataIter->first <= position && mDataIter != mData.end()){
		mDataIter->second->exec(position);
		mDataIter++;
	}

}// exec()

// G̍폜 ||||||||||||||||||||||||||||||||
void ControllerImpl::deleteCommand(const float x,const float y,const float position,command::TYPE type)
{
	std::pair< CommandList::iterator, CommandList::iterator > it_pair
        = mData.equal_range( position );

	CommandList::iterator it = it_pair.first;
	
	command::SetEnemy *pe = NULL;
	command::SetArmy *pe1 = NULL;

	const int range = 6.0f;
	float tx,ty;

	while(it != it_pair.second){
		if(it->second->id() == type){
			switch(type){
			case SET_ENEMY:
				pe = dynamic_cast<command::SetEnemy *>(it->second);
				tx = pe->x() + game()->background()->startOffsetX();
				ty = pe->y() + game()->background()->startOffsetY();
				if(x > (tx - range) && x < (tx + range) && y > (ty - range) && y < (ty + range)){
					mData.erase(it);
					return;
				}
				break;
			case SET_ARMY:
				pe1 = dynamic_cast<command::SetArmy *>(it->second);
				tx = pe1->x() + game()->background()->startOffsetX();
				ty = pe1->y() + game()->background()->startOffsetY();
				if(x > (tx - range) && x < (tx + range) && y > (ty - range) && y < (ty + range)){
					mData.erase(it);
					return;
				}
				break;
			default:
				tx = sf::system::console::viewport::X + game()->background()->startOffsetX();
				ty = game()->background()->startOffsetY();
				if(x > (tx - range) && x < (tx + range) && y > (ty - range) && y < (ty + range)){
					mData.erase(it);
					return;
				}
				return;
			}
		}
		++it;
	}
}// deleteCommand()

// |||||||||||||||||||||||||||||||||||||
// Abstract 
// |||||||||||||||||||||||||||||||||||||

void Abstract::draw(sf::application::scene::DispositionEditor *pEditor,float position,bool bMouse)
{
	if(sprite() == NULL)
		return;

	if(bMouse){
		pEditor->x(pEditor->mouseX());
		pEditor->y(pEditor->mouseY());
	} else {
		pEditor->x(sf::system::console::viewport::X + sf::system::console::viewport::WIDTH / 2.0f + game()->background()->startOffsetX());
		pEditor->y(game()->background()->startOffsetY()
			+ (game()->scrollY() - position));
	}

	if(position == game()->scrollY() && !bMouse)
		pEditor->specular(0x00208020);
	else
		pEditor->specular(0);
	
	pEditor->drawMode(sf::system::console::DRAW_TRANS);
	pEditor->color(0xffffffff);

	sprite()->draw(pEditor);
}// Abstract::draw()

// |||||||||||||||||||||||||||||||||||||
// SetScrollSpeed 
// |||||||||||||||||||||||||||||||||||||

sf::system::console::sprite::PSprite SetScrollSpeed::mspSprite;

const sf::system::console::sprite::Info SetScrollSpeed::msSpriteInfo = 
{
	"media\\SetScrollSpeed.png",0.0f,0.0f,0.0f,0.0f,0xff000000,sf::system::console::sprite::SPRITE2D
};

// \[X̃[h ||||||||||||||||||||||||||||
void SetScrollSpeed::loadResource(void){
	using namespace sf::system::console::sprite;
	if(!mspSprite.get()){
		PSprite ptemp(sf::system::instance()->console()->createSprite(&msSpriteInfo)); 
		mspSprite = ptemp;
	}
}// SetScrollSpeed::loadResource()

// \[X̃A[h ||||||||||||||||||||||||||
void SetScrollSpeed::unloadResource(void){
	using namespace sf::system::console::sprite;
	PSprite ptmp(NULL);
	mspSprite = ptmp;
}// SetScrollSpeed::unloadResource()


// |||||||||||||||||||||||||||||||||||||
// SetRestartPosition 
// |||||||||||||||||||||||||||||||||||||
sf::system::console::sprite::PSprite SetRestartPosition::mspSprite;

const sf::system::console::sprite::Info SetRestartPosition::msSpriteInfo = 
{
	"media\\Restart.png",0.0f,0.0f,0.0f,0.0f,0xff000000,sf::system::console::sprite::SPRITE2D
};

// \[X̃[h ||||||||||||||||||||||||||||
void SetRestartPosition::loadResource(void){
	using namespace sf::system::console::sprite;
	if(!mspSprite.get()){
		PSprite ptemp(sf::system::instance()->console()->createSprite(&msSpriteInfo)); 
		mspSprite = ptemp;
	}
}// SetRestartPosition::loadResource()

// \[X̃A[h ||||||||||||||||||||||||||
void SetRestartPosition::unloadResource(void){
	using namespace sf::system::console::sprite;
	PSprite ptmp(NULL);
	mspSprite = ptmp;
}// SetRestartPosition::unloadResource()


// |||||||||||||||||||||||||||||||||||||
// SetEnemy 
// |||||||||||||||||||||||||||||||||||||

sf::system::console::sprite::PSprite SetEnemy::mspSprites[sf::application::enemy::MAX_TYPE];
const sf::system::console::sprite::Info SetEnemy::msSpriteInfos[sf::application::enemy::MAX_TYPE] =
{
	{"media\\zk01.png",0.0f,0.0f,64.0f,64.0f,0xff000000,sf::system::console::sprite::SPRITE2D},
	{"media\\zk02.png",0.0f,0.0f,64.0f,64.0f,0xff000000,sf::system::console::sprite::SPRITE2D}
};


// Iy[^I[o[Ch ||||||||||||||||||||||||
std::ostream & operator <<
                ( std::ostream &rOStrm    // cStrStrm
                , const sf::application::scene::Game::DIFFICULTY &rDifficulty )    // cInt
{
	int temp = (int)rDifficulty;
    return rOStrm << temp;    // ̊֐Ăяo܂B
}

std::istream& operator >> ( std::istream& rIStrm, sf::application::scene::Game::DIFFICULTY &rDifficulty )
{
	int temp;
	rIStrm >> temp;
	rDifficulty = (sf::application::scene::Game::DIFFICULTY)temp;
	return rIStrm;
}


// RXgN^ |||||||||||||||||||||||||||||
SetEnemy::SetEnemy()
{	mX = mY = mZ = 0.0f;
	mEnemyNo = 0;
	mDifficulty = sf::application::scene::Game::EASY;
};

// fXgN^ ||||||||||||||||||||||||||||||
SetEnemy::~SetEnemy(){;};

// ő吔Ԃ |||||||||||||||||||||||||||||
const int SetEnemy::max(void) const
{
	return sf::application::enemy::MAX_TYPE;
}

// R}h̎s |||||||||||||||||||||||||||||
void SetEnemy::exec(const float position)
{
	if(mDifficulty <= game()->difficulty()){
		sf::application::enemy::Enemys::instance()->create(
			(sf::application::enemy::Enemys::TYPE)mEnemyNo,
			mX,mY,mZ,game()
			);
	}
};

// R}h̃[h ||||||||||||||||||||||||||||
void SetEnemy::load(std::istream &is){

	is >> mDifficulty;
	is >> mEnemyNo;
	is >> mX;
	is >> mY;
	is >> mZ;
	
	sf::application::enemy::Enemys::instance()->load(mEnemyNo);
};// load()

// R}h̃Z[u ||||||||||||||||||||||||||||
void SetEnemy::save(std::ostream &os){
	os << " " << mDifficulty;
	os << " " << mEnemyNo;
	os << " " << mX ;
	os << " " << mY;
	os << " " << mZ;
};// save();

// \[X̃[h ||||||||||||||||||||||||||||
void SetEnemy::loadResource(void){
	using namespace sf::system::console::sprite;
	for(int i = 0;i < sf::application::enemy::MAX_TYPE;i++){
		if(!mspSprites[i].get()){
			PSprite ptemp(sf::system::instance()->console()->createSprite(&msSpriteInfos[i])); 
			mspSprites[i] = ptemp;
		}
	}
}// SetEnemy::loadResource()

// \[X̃A[h ||||||||||||||||||||||||||
void SetEnemy::unloadResource(void){
	using namespace sf::system::console::sprite;
	for(int i = 0;i < sf::application::enemy::MAX_TYPE;i++){
		if(mspSprites[i].get()){
			PSprite ptmp(NULL);
			mspSprites[i] = ptmp;
		}
	}
}// SetEnemy::unloadResource()

// G}[J[̕` ||||||||||||||||||||||||||||
void SetEnemy::draw(sf::application::scene::DispositionEditor * const pEditor
					,const float position,const bool bMouse)
{
	using namespace sf::application::scene;
	// }EXJ[\ɒǏ]邩
	if(bMouse){
		pEditor->x(pEditor->mouseX());
		pEditor->y(pEditor->mouseY());
	} else {
		pEditor->x(x() + game()->background()->startOffsetX());
		pEditor->y(y() + game()->background()->startOffsetY()
			+ (game()->scrollY() - position));
	}

	if(position == game()->scrollY() && !bMouse)
		pEditor->specular(DispositionEditor::CURRENT_SPECULAR);
	else
		pEditor->specular(DispositionEditor::NORMAL_SPECULAR);
	
	pEditor->drawMode(sf::system::console::DRAW_TRANS);
	pEditor->color(0xffffffff);

	mspSprites[mEnemyNo]->draw(pEditor);

}// SetEnemy::draw()

// L[̏ ||||||||||||||||||||||||||||
void SetEnemy::keyDown(const DWORD keyCode,const DWORD extKeyCode)
{
	switch((char)keyCode)
	{
	case '1':
		if(mEnemyNo > 0)
			mEnemyNo--;
		break;
	case '2':
		if(mEnemyNo < max() - 1)
			mEnemyNo++;
		break;
	}
}//keyDown();

// |||||||||||||||||||||||||||||||||||||
// SetArmy 
// |||||||||||||||||||||||||||||||||||||

sf::system::console::sprite::PSprite SetArmy::mspSprites[sf::application::enemy::MAX_ARMYS_TYPE];
const sf::system::console::sprite::Info SetArmy::msSpriteInfos[sf::application::enemy::MAX_ARMYS_TYPE] =
{
	{"media\\ea01.png",0.0f,0.0f,64.0f,64.0f,0xff000000,sf::system::console::sprite::SPRITE2D}
};

// RXgN^ |||||||||||||||||||||||||||||
SetArmy::SetArmy()
{	mX = mY = mZ = 0.0f;
	mEnemyNo = 0;
	mDifficulty = sf::application::scene::Game::EASY;
};

// fXgN^ ||||||||||||||||||||||||||||||
SetArmy::~SetArmy(){;};

// ő吔Ԃ |||||||||||||||||||||||||||||
const int SetArmy::max(void) const
{
	return sf::application::enemy::MAX_ARMYS_TYPE;
}

// R}h̎s |||||||||||||||||||||||||||||
void SetArmy::exec(const float position)
{
	if(mDifficulty <= game()->difficulty()){
		sf::application::enemy::Armys::instance()->create(
			(sf::application::enemy::Armys::TYPE)mEnemyNo,
			mX,mY,mZ,game()
			);
	}
};

// R}h̃[h ||||||||||||||||||||||||||||
void SetArmy::load(std::istream &is){
	
	is >> mDifficulty;
	is >> mEnemyNo;
	is >> mX;
	is >> mY;
	is >> mZ;

	sf::application::enemy::Armys::instance()->load(mEnemyNo);

};// load()

// R}h̃Z[u ||||||||||||||||||||||||||||
void SetArmy::save(std::ostream &os){
	os << " " << mDifficulty;
	os << " " << mEnemyNo;
	os << " " << mX ;
	os << " " << mY;
	os << " " << mZ;
};// save();

// \[X̃[h ||||||||||||||||||||||||||||
void SetArmy::loadResource(void){
	using namespace sf::system::console::sprite;
	for(int i = 0;i < sf::application::enemy::MAX_TYPE;i++){
		if(!mspSprites[i].get()){
			PSprite ptemp(sf::system::instance()->console()->createSprite(&msSpriteInfos[i])); 
			mspSprites[i] = ptemp;
		}
	}
}// SetArmy::loadResource()

// \[X̃A[h ||||||||||||||||||||||||||
void SetArmy::unloadResource(void){
	using namespace sf::system::console::sprite;
	for(int i = 0;i < sf::application::enemy::MAX_TYPE;i++){
		if(mspSprites[i].get()){
			PSprite ptmp(NULL);
			mspSprites[i] = ptmp;
		}
	}
}// SetArmy::unloadResource()

// zu}bvɕ` |||||||||||||||||||||||||||
void SetArmy::draw(sf::application::scene::DispositionEditor * const pEditor,const float position,const bool bMouse)
{
	if(bMouse){
		pEditor->x(pEditor->mouseX());
		pEditor->y(pEditor->mouseY());
	} else {
		pEditor->x(game()->background()->startOffsetX());
		pEditor->y(game()->background()->startOffsetY()
			+ (game()->scrollY() - position));
	}

	if(position == game()->scrollY() && !bMouse)
		pEditor->specular(0x00208020);
	else
		pEditor->specular(0);
	
	pEditor->drawMode(sf::system::console::DRAW_TRANS);
	pEditor->color(0xffffffff);

	mspSprites[mEnemyNo]->draw(pEditor);
}// SetArmy::draw()

// L[̏ ||||||||||||||||||||||||||||
void SetArmy::keyDown(const DWORD keyCode,const DWORD extKeyCode)
{
	switch((char)keyCode)
	{
	case '1':
		if(mEnemyNo > 0)
			mEnemyNo--;
		break;
	case '2':
		if(mEnemyNo < max() - 1)
			mEnemyNo++;
		break;
	}
}//keyDown();
