//@STATE=쐬
//@DESCRIPTION ---------------------------------------------------------------
// Ship.cpp: Ship NX̃Cve[V
//	F
// $Log: MyShip.cpp,v $
// Revision 1.1  2001/10/28 21:40:36  fujiwara
// DLLɕ
//
// Revision 1.8  2001/07/09 20:30:09  fujiwara
// Ȏgݍ
//
// Revision 1.7  2001/07/01 21:30:34  fujiwara
// [N`FbN
//
// Revision 1.6  2001/07/01 01:03:44  fujiwara
// const ̌
// zuGfB^͓ro
//
// Revision 1.5  2001/06/10 21:17:01  fujiwara
// ^[Qbgǉinpj
//
// Revision 1.4  2001/05/29 01:12:35  fujiwara
// GL(sj̍쐬BzuGfB^̃oOC
//
// Revision 1.3  2001/05/12 00:49:34  fujiwara
// bur𓱓AO\ǉ
//
//   2001/5/4 e֘A̎ǉ
//@DESCRIPTION_END -----------------------------------------------------------
//@AUTHOR=S.F.
// Copyright (C) 2000 Satoshi Fujiwara. All Rights Reserved.
///////////////////////////////////////////////////////////////////////////////
#pragma warning( disable : 4786 )	//STĽxO

// [[Nop
#include "sfdebug.h"

#include <string>
#include <vector>
#include <memory>
#include <stack>
#include <list>
#include <iostream>
#include <fstream>
#include <map>

#include "stdio.h"
#include "math.h"

#include "exception.h"
#include "singleton.h"
#include "system.h"
#include "console.h"
#include "input.h"
#include "sound.h"

#include "Obj.h"
#include "Obj2D.h"
#include "Obj3D.h"
#include "Obj3DL.h"
#include "ObjRectangle.h"
#include "ObjQuadrangle.h"

#include "Background.h"
#include "Scene.h"
#include "main.h"

#include "character.h"
#include "Hit.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#include "DispositionControl.h"
#include "Game.h"
#include "MyShip.h"
#include "Enemys.h"
#include "Armys.h"
#include "AbstractCharacter.h"
#include "MyBullets.h"
#include "Effects.h"
#include "Explosion.h"
#include "Target.h"

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

using namespace sf::application;
using namespace sf::application::player;
using namespace sf::system::console;

const float Ship::INIT_X = (float)(viewport::X + viewport::WIDTH / 2);
const float Ship::INIT_Y = (float)(viewport::Y + viewport::HEIGHT * 2 / 3);
const float Ship::INIT_Z = 0.2f;

const float Ship::BODY_HEIGHT = 64.0f;
const float Ship::BODY_WIDTH = 64.0f;
const float Ship::INIT_SPEED = 8.0f;
const int Ship::INIT_LIFE = 3;

const int Ship::PATTERN_MAX = 7;
const int Ship::PATTERN_MIDDLE = 3;

const console::sprite::Info Ship::INFO_BODY =
{ "media\\myship.png",0.0f,0.0f,64.0f,64.0f,0xff000000,console::sprite::SPRITE2D};

const int OBJ_BODY_NO = 2;

// RXgN^ |||||||||||||||||||||||||||||
Ship::Ship(scene::Game *pGame){
	mpGame = NULL;
	mBody.x(INIT_X);
	mBody.y(INIT_Y);
	mBody.z(INIT_Z);

	mpConsole = NULL;
	mpSystem = NULL;
	mpSound = NULL;
	mpInput = NULL;
	mpSpriteShip = NULL;
	mpGame = pGame;
	mpTarget = NULL;
}

Ship::Ship()
{
	mpGame = NULL;
	mBody.x(INIT_X);
	mBody.y(INIT_Y);
	mBody.z(INIT_Z);

	mpConsole = NULL;
	mpSystem = NULL;
	mpSound = NULL;
	mpInput = NULL;
	mpSpriteShip = NULL;
	mpTarget = NULL;
	
}

// fXgN^ ||||||||||||||||||||||||||||||
Ship::~Ship()
{
	if(mpSpriteShip)
		delete mpSpriteShip;
	if(mpTarget)
		delete mpTarget;

}// ~Ship()

// @̓ |||||||||||||||||||||||||||||||
void Ship::move(void)
{
	using namespace sf::system::console;
	bool bmove = false;
	

	switch (mState)
	{
	case MOVE:

		
		if(mpInput->left() && x() > (viewport::X + BODY_WIDTH / 2.0f)){
			x(x() - speed());
			if(mBody.index() > 0){
				mBody.index(mBody.index() - 1);
			}
			bmove = true;
		}

		if(mpInput->right() && x() < (viewport::X + viewport::WIDTH - BODY_WIDTH / 2.0f))
		{
			x(x() + speed());
			if(mBody.index() < PATTERN_MAX){
				mBody.index(mBody.index() + 1);
			}
			bmove = true;
		}

		if(!bmove){
			if(mBody.index() < PATTERN_MIDDLE){
				mBody.index(mBody.index() + 1);
			} else {
				if(mBody.index() > PATTERN_MIDDLE){
					mBody.index(mBody.index() - 1);
				}
			}

		}
		if(mpInput->up() && y() > (viewport::Y + BODY_HEIGHT / 2.0f))
			y(y() - speed());

		if(mpInput->down() && y() < (viewport::Y + viewport::HEIGHT - BODY_HEIGHT / 2.0f))
			y(y() + speed());
		
		mBody.x(x());
		mBody.y(y());
		mpTarget->move();

		// e
		if(mpInput->buttonA(true))
			bullet::Bullets::instance()->create(bullet::Bullets::NORMAL,mBody.x(),mBody.y(),mBody.z(),mpGame);
		break;
	case DEAD:
		mCounter--;
		
		if(mCounter == 60){
			mBody.visibility(false);
			delete mpTarget;
			mpTarget = NULL;
		}
		
		if(mCounter == 0){
			life(life() - 1);
			if(life() == 0){
				mpGame->state(scene::Game::OVER);
			} else {
				mpGame->state(scene::Game::RESTART);
			}
		}

	}


}// move()

//  |||||||||||||||||||||||||||||||||
void Ship::initialize()
{
	x(INIT_X);
	y(INIT_Y);
	z(INIT_Z);

	mBody.x(INIT_X);
	mBody.y(INIT_Y);
	mBody.z(INIT_Z);
	mBody.index(PATTERN_MIDDLE);
	mBody.color(0xffffffff);
	mBody.drawMode(DRAW_TRANS);
	
	mShipHitArea.characterPtr(this);
	mShipHitArea.offsetBottom(20.0f);
	mShipHitArea.offsetTop(-20.0f);
	mShipHitArea.offsetLeft(-10.0f);
	mShipHitArea.offsetRight(10.0f);
	mShipHitArea.isChecking(true);

/*
	mBody.scalingX(0.5f);
	mBody.scalingY(0.5f);
	mBody.scalingZ(0.5f);
*/
//	mBody.angleZ(PI);
//	mBody.angleX(PI/2.0f);
	
	mpSystem = system::instance();
	mpConsole = mpSystem->console();
	mpSound = mpSystem->sound();
	mpInput = mpSystem->input();
	if(!mpSpriteShip)
		mpSpriteShip = mpConsole->createSprite(&INFO_BODY);
	
	mBody.sprite(mpSpriteShip );
	mTimer = 0;
	mBody.visibility(true);
	speed(INIT_SPEED * sf::system::instance()->deltaTime());
	mState =MOVE;
	Target::load();
	if(!mpTarget)
		mpTarget = new Target(mpGame);
	mpTarget->initialize();
}// initialize()

// 菈 ||||||||||||||||||||||||||||||||
void Ship::hit(Character * const pDest){
	mShipHitArea.isChecking(false);
	mState = DEAD;
	mCounter = 66;
	effect::Explosion *pExp = (effect::Explosion*)effect::Effects::instance()->create(effect::Effects::EXPLOSION,x(),y(),0.1f,mpGame,this);
	if(pExp){
			pExp->scaling(2.0f);
	}
}// hit();

// X^[g |||||||||||||||||||||||||||||||
void Ship::restart(void){
//	mBody.visibility(true);
	mShipHitArea.isChecking(true);
	mState =MOVE;
}// restart();


