//@STATE=쐬
//@DESCRIPTION ---------------------------------------------------------------
// BGEditorImpl.cpp: BGEditorImpl NX̃Cve[V
// <<  >>
//   CX^X쐬͕KABGEditor̃p[^ĂB
//	F
// $Log: BGEditorImpl.cpp,v $
// Revision 1.1.1.1  2001/11/06 21:29:04  fujiwara
// no message
//
// Revision 1.1  2001/10/28 21:40:35  fujiwara
// DLLɕ
//
// Revision 1.5  2001/07/09 20:30:07  fujiwara
// Ȏgݍ
//
// Revision 1.4  2001/07/01 21:30:33  fujiwara
// [N`FbN
//
// Revision 1.3  2001/07/01 01:03:43  fujiwara
// const ̌
// zuGfB^͓ro
//
// Revision 1.2  2001/05/12 00:48:13  fujiwara
// bur𓱓AO\ǉ
//
//@DESCRIPTION_END -----------------------------------------------------------
//@AUTHOR=S.F.
// Copyright (C) 2000 Satoshi Fujiwara. All Rights Reserved.
///////////////////////////////////////////////////////////////////////////////

#pragma warning( disable : 4786 )	//STĽxO
// [[Nop
#include "sfdebug.h"


// SYSTEM INCLUDES

#include <stack>
#include <list>
#include <vector>
#include <map>
#include <fstream>

// PROJECT INCLUDES

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#include "exception.h"
#include "singleton.h"
#include "system.h"
#include "console.h"
#include "input.h"
#include "Scene.h"
#include "main.h"
#include "Obj.h"
#include "Obj2D.h"
#include "Obj3D.h"
#include "Obj3DL.h"
#include "ObjQuadrangle.h"
#include "ObjRectangle.h"
#include "Background.h"
#include "AbstractScene.h"
#include "character.h"
#include "Game.h"
#include "hit.h"
#include "MySHip.h"
#include "Enemys.h"
#include "Armys.h"
#include "DispositionControl.h"
#include "BGEditor.h"
#include "BGEditorImpl.h"

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

using namespace sf::application::scene;
using namespace sf;
using namespace sf::system::console;

const float BGEditorImpl::CellSelector::WIDTH = Background::Map::CELL_SIZE * Background::Map::CELL_TEX_COUNT_W;
const float BGEditorImpl::CellSelector::HEIGHT = Background::Map::CELL_SIZE * Background::Map::CELL_TEX_COUNT_H;

const float BGEditorImpl::CellSelector::X_MIN = viewport::X + BGEditorImpl::CellSelector::WIDTH / 2.0f;
const float BGEditorImpl::CellSelector::X_MAX = viewport::X + viewport::WIDTH - BGEditorImpl::CellSelector::WIDTH / 2.0f;
const float BGEditorImpl::CellSelector::Y_MIN = viewport::Y + BGEditorImpl::CellSelector::HEIGHT / 2.0f;
const float BGEditorImpl::CellSelector::Y_MAX = viewport::Y + viewport::HEIGHT - BGEditorImpl::CellSelector::HEIGHT / 2.0f;			


BGEditorImpl::BGEditorImpl() : AbstractScene()
{
	mbCallBack = false;
	mbListening = false;
	mpCellSelector = NULL;
	mSelectedMapData = 0x0;
	mpGame = NULL;
	mState = INITIALIZE;
}

BGEditorImpl::~BGEditorImpl()
{
	mbCallBack = false;

	if(mpInput){
		mpInput->removeMouseListener(this);
		mpInput->removeKeyboardListener(this);
		mpInput->hideMouseCursor();
	}

	if(mpCellSelector)
		delete mpCellSelector;
}


void BGEditorImpl::move(void)
{
	switch(mState)
	{
	case INITIALIZE:
		initialize();
		return;
	case MAIN:
		// dwhsL[ꂽH
		if(mpInput->exit(true)) {
			exitKeyPressed(this);
		}
		return;
	}

}

//  |||||||||||||||||||||||||||||||||
bool BGEditorImpl::initialize()
{
//	if(!mBackground.load("test.map"))
//		return false;

//	mBackground.offsetY(0.0f);
//	mBackground.visibility(true);
	mpInput->addMouseListener(this);
	mpInput->addKeyboardListener(this);

	mpInput->showMouseCursor();
	mState = MAIN;
	mbCallBack = true;
	mbListening = true;
	return true;
}

//BGEditorImpl Scene ̏I ---------------------------------------------------------
void BGEditorImpl::endOfScene(Scene *pScene)
{
	CellSelector *pcs;

	switch(pScene->type())
	{
	case CELLSELECTOR:
		mbCallBack = true;
		pcs = dynamic_cast<CellSelector*>(pScene);
		selectedData( (pcs->selectedTextureNo() << 16) | (0x7fff & pcs->selectedIndex() + 1));
		break;
	default:
		callSceneEvent(&sf::application::scene::Listener::endOfScene);
		delete this;
	}

} //endOfScene()

// exit key ꂽI ------------------------------------------------------
void BGEditorImpl::exitKeyPressed(Scene *pScene)
{
	callSceneEvent(&sf::application::scene::Listener::exitKeyPressed);
	delete this;
} //endOfScene()

// }EXzC[ |||||||||||||||||||||||||
void BGEditorImpl::mouseWheel(const int screenX,const int screenY,const DWORD mkey)
{
	using namespace sf::system::input::mouse;
	int wheel = (int)(mkey & 0xffff0000) / 65536;
	
	float speed = 8.0f;

	if(MKEY_SHIFT & mkey)
		speed = 64.0f;

	if(MKEY_CONTROL & mkey)
		speed = 64.0f * 8.0f;
	
	if(wheel > 0){
		mpGame->scrollY(mpGame->scrollY() + speed);
	} else {
		mpGame->scrollY(mpGame->scrollY() - speed);
	}

}// mouseWheel()

// L[{[hꂽI
void BGEditorImpl::keyDown(DWORD keyCode,DWORD extKeyCode)
{
	switch((char)keyCode)
	{
	case 'G':
		endOfScene(this);
		break;
	case 'S':
		mpGame->background()->save(NULL);
		break;
	}
}// keyDown()

// ENbN  ||||||||||||||||||||||||||||||
void BGEditorImpl::rightButtonDown(const int screenX,const int screenY,const DWORD mkey)
{
	mbCallBack = false;

	CellSelector *pcsel = new CellSelector(mpGame->background()->textureList());
	Container::instance()->add(pcsel);
	pcsel->addListener(this);
	pcsel->selectedIndex(selectedData() & 0xffff);
	pcsel->selectedTextureNo((selectedData() & 0xffff0000) >> 16);
	
	pcsel->selectorX((float)screenX);
	pcsel->selectorY((float)screenY);
	pcsel->z((float)0.0001);

	mMouseX = (float)screenX;
	mMouseY = (float)screenY;
	
}// rightButtonDown

// |||||||||||||||||||||||||||||||||||||
//
//  CellSelector Class
//
// |||||||||||||||||||||||||||||||||||||

BGEditorImpl::CellSelector::CellSelector(sf::system::console::Background::TextureList* pTextureList)
{
	mpTextureList = pTextureList;
	visibility(false);
	sprite(NULL);
	mState = INITIALIZE;
	mbMouseListening = false;
}// CellSelector()

// fXgN^ ||||||||||||||||||||||||||||||
BGEditorImpl::CellSelector::~CellSelector()
{
	if(mpInput)
		mpInput->removeMouseListener(this);
//	Obj::List::deleteObj(this);

}// ~CellSelector()

// Lq ||||||||||||||||||||||||||||||||
void BGEditorImpl::CellSelector::move(void)
{
	switch(mState)
	{
	case INITIALIZE:
		initialize();
		return;
	case MAIN:
//		return main();
		break;
	}

}// move()

//  ||||||||||||||||||||||||||||||||||
bool BGEditorImpl::CellSelector::initialize()
{
	if(mSelectorX > X_MAX)
		mSelectorX = X_MAX;
	
	if(mSelectorX< X_MIN)
		mSelectorX = X_MIN;
	
	if(mSelectorY > Y_MAX)
		mSelectorY = Y_MAX;

	if(mSelectorY < Y_MIN)
		mSelectorY = Y_MIN;
	mpInput->addMouseListener(this);
	mbMouseListening = true;
	visibility(true);
	mState = MAIN;
	return true;
}// move()

// ZN^̕` |||||||||||||||||||||||||||||
void BGEditorImpl::CellSelector::draw()
{
	if(!visibility())
		return;
	
	float start_y = mSelectorY - (Background::Map::CELL_TEX_COUNT_H / 2.0f 
					*  Background::Map::CELL_SIZE - Background::Map::CELL_SIZE / 2.0f);
	float end_y = mSelectorY + (Background::Map::CELL_TEX_COUNT_H / 2.0f 
					*  Background::Map::CELL_SIZE - Background::Map::CELL_SIZE / 2.0f);
	
	float start_x = mSelectorX - (Background::Map::CELL_TEX_COUNT_W / 2.0f 
					*  Background::Map::CELL_SIZE - Background::Map::CELL_SIZE / 2.0f);
	
	float end_x = mSelectorX + (Background::Map::CELL_TEX_COUNT_W / 2.0f 
					*  Background::Map::CELL_SIZE - Background::Map::CELL_SIZE / 2.0f);

	int t_index = 0;

	for(float iy = start_y ; iy <= end_y;iy += Background::Map::CELL_SIZE)
	{
		for(float ix = start_x ; ix <= end_x ; ix += Background::Map::CELL_SIZE){
			index(t_index);
			x(ix);
			y(iy);

			if(	mMouseX > (ix - Background::Map::CELL_SIZE / 2.0f) && 
				mMouseX < (ix + Background::Map::CELL_SIZE / 2.0f) && 
				mMouseY > (iy - Background::Map::CELL_SIZE / 2.0f) && 
				mMouseY < (iy + Background::Map::CELL_SIZE / 2.0f))
			{	
				color(0xffff0000);
			}
			else
				color(0xffffffff);

			(*mpTextureList)[selectedTextureNo()]->draw(this);
			t_index++;
		}
	}

}

// NbNꂽ ||||||||||||||||||||||||||
void BGEditorImpl::CellSelector::leftButtonDown(const int screenX,const int screenY,const DWORD mkey)
{

	if(!visibility())
	return;
	
	float start_y = mSelectorY - (Background::Map::CELL_TEX_COUNT_H / 2.0f 
					*  Background::Map::CELL_SIZE - Background::Map::CELL_SIZE / 2.0f);
	float end_y = mSelectorY + (Background::Map::CELL_TEX_COUNT_H / 2.0f 
					*  Background::Map::CELL_SIZE - Background::Map::CELL_SIZE / 2.0f);
	
	float start_x = mSelectorX - (Background::Map::CELL_TEX_COUNT_W / 2.0f 
					*  Background::Map::CELL_SIZE - Background::Map::CELL_SIZE / 2.0f);
	
	float end_x = mSelectorX + (Background::Map::CELL_TEX_COUNT_W / 2.0f 
					*  Background::Map::CELL_SIZE - Background::Map::CELL_SIZE / 2.0f);

	int t_index = 0;

	for(float iy = start_y ; iy <= end_y;iy += Background::Map::CELL_SIZE)
	{
		for(float ix = start_x ; ix <= end_x ; ix += Background::Map::CELL_SIZE){
			if(	mMouseX > (ix - Background::Map::CELL_SIZE / 2.0f) && 
				mMouseX < (ix + Background::Map::CELL_SIZE / 2.0f) && 
				mMouseY > (iy - Background::Map::CELL_SIZE / 2.0f) && 
				mMouseY < (iy + Background::Map::CELL_SIZE / 2.0f))
			{	
				selectedIndex(t_index);
				callSceneEvent(&sf::application::scene::Listener::endOfScene);
				delete this;
				return;
			}
			t_index++;
		}
	}
	callSceneEvent(&sf::application::scene::Listener::endOfScene);
	delete this;
}// leftButtonDown()

// }EXzC[ |||||||||||||||||||||||||
void BGEditorImpl::CellSelector::mouseWheel(const int screenX,const int screenY,const DWORD mkey)
{
	using namespace sf::system::input::mouse;
	int wheel = (int)(mkey & 0xffff0000) / 65536;
	if(wheel > 0){
		if(selectedTextureNo() == (mpTextureList->size() - 1))
			return;
		else
			selectedTextureNo(selectedTextureNo() + 1);
	} else {
		if(selectedTextureNo() == 0)
			return;
		else
			selectedTextureNo(selectedTextureNo() - 1);
	}
		


}// mouseWheel()

