/**
 * @file Console.h
 * @brief ʕ`iXvCgEwi摜j̃C^[tF[XE萔`s.
 * ʊ֘A̒萔`
 * ۂ̏́AOSˑ̋ۃNXɔC܂B
 * 2000/02/18 Ղ[񂳂̃CuQlɂRcǉ
 *
 * @author S.F.
 * @version $Id:
 *
 * Copyright (C) 2000-2002 Satoshi Fujiwara. All Rights Reserved.
 */
 
/// dCN[hh~}N
#if !defined(AFX_IConsole_H__DB7BCF98_4A51_43E3_B919_9A26C58E6A90__INCLUDED_)
#define AFX_IConsole_H__DB7BCF98_4A51_43E3_B919_9A26C58E6A90__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
#include <memory>

#include "sf.h"

extern "C" {
namespace sf{
	namespace system {
		/// ʊ֘ÃNXE萔
		/*! ʊ֘ÃNXE萔ׂ͂Ă̖̂OԂɊ܂܂܂B */
		namespace console {
			/// J[^̒`
			typedef unsigned long COLOR;
			
/** R,G,B,ÅeFA32bit̒l𓾂 
 * Red,Green,Blue,AlphåeF(8bit)ƂɁA32bitlongl𐶐܂ 
 * @param a ALPHA
 * @param r RED
 * @param g GREEN
 * @param b BLUE */
#define COLOR(a,r,g,b) ((COLOR)((((a) & 0xff) << 24 )) | (((r) & 0xff) << 16) | (((g) & 0xff) << 8) | ((b) & 0xff)))

			/** RGBJ[𐧌䂷NX. 
			 * 32bitJ[̒lAeFoAeFƗđ삷邽߂ɍ쐬ꂽNXłA܂gĂ܂B
			*/
			class Color {
			public:
				Color() { mColor.value32 = 0;};
				/** RXgN^̂Q *
				 * @param xolor COLOR ^̒l */
				Color(COLOR color){mColor.value32 = color;};
				/** COLOR̒lo.
				 * @return COLOR^̒l */
				COLOR value(void) const {return mColor.value32;};
				/** COLORZbg 
				 * @param color COLOR^̒l */
				void value(COLOR color){mColor.value32 = color;};

				/** Ԃ̐擾 
				 * @return Ԑ(0-255) */
				unsigned char red(void) const { return mColor.value.red;};
				/** Ԃ̐Zbg 
				 * @param value Ԑ(0-255) */
				void red(unsigned char value) { mColor.value.red = value;};

				/** ̐擾 
				 * @return (0-255) */
				unsigned char blue(void) const { return mColor.value.blue;};
				/** ̐Zbg 
				 * @param value (0-255) */
				void blue(unsigned char value) { mColor.value.blue = value;};
				
				/** ΂̐擾 
				 * @return ΐ(0-255) */
				unsigned char green(void) const { return mColor.value.green;};
				/** ΂̐Zbg 
				 * @param value ΐ(0-255) */
				void green(unsigned char value){mColor.value.green = value;};
				
				/** ALPHA̐擾 
				 * @return ALPHA(0-255) */
				unsigned char alpha(void) const { return mColor.value.alpha;};
				/** ALPHA̐Zbg 
				 * @param value ALPHA(0-255) */
				void alpha(unsigned char value){mColor.value.alpha = value;};

			private:
				///@p
				union {
					COLOR value32;///< ARGB̒l(32bit)
					/// \
					struct {
						unsigned char blue 	:	8;///< 
						unsigned char green :	8;///< ΐ
						unsigned char red	:	8;///< Ԑ
						unsigned char alpha	:	8;///< ALPHA
					} value;
					
				} mColor;
			};

			/// XN[֘A
			namespace screen {
				const int WIDTH  = 640;///< XN[̕
				const int HEIGHT = 480;///< XN[̍
			};
			
			/// r[|[g֘A 
			namespace viewport {
				const int X = 120;	///< r[|[g[ X
				const int Y = 0;	///< r[|[g[ Y
				const float Z_MIN = 0.0f;///< r[|[gyŏ
				const float Z_MAX = 1.0f;///< r[|[győ	
				const int WIDTH = 400;///< r[|[g̕
				const int HEIGHT = 480;///< r[|[g̍
			};
			
			const int TEXTURE_COUNT_MIN = 0;///< eNX`[̍ŏl
			const int TEXTURE_COUNT_MAX = 1024;///< eNX`[̍ől

			// XvCg

			class ObjQuadrangle;
			class ObjRectangle;
			class Obj3DL;


			/// XvCg֘A
			namespace sprite {
				const int MIN = 0;	///< XvCgŏlH
				const int MAX = 1024; ///< XvCgől
	
				/// XvCg̃^Cv
				enum TYPE
				{
					SPRITE2D,///< 2DXvCgł(W2D)
					SPRITE3D,///< 3DXvCgł(W3D)
					MESH ///< bVł(Xt@C)
				};

				/** XvCg`\.
				* XvCg`邽߂̍\̂łB
				* XvCg̐́AConsole C^[tF[XConsole::createSprite()̈ƂĂ̍\̂ns܂B*/
				struct Info {
					char fileName[_MAX_PATH];///< rbg}bvt@Cl[
					float centerX;///< SXW
					float centerY;///< SYW
					float cellWidth;///< 
					float cellHeight;///< 
					COLOR transparentColor;///< ߐF
					TYPE type;///< XvCg̃^Cv
				};

			
				/** XvCg̕`搧s. 
				 * ۂ̃XvCg`sC^[tF[XłB
				 * ObjRectangleȂǂ̍WێNXɉʂɎgێĂrbg}bvʂɕ`悵܂B
				 * @Section SpriteC^[tF[XObjC^[tF[X̊֌Wɂ.
				 * @para ObjC^[tF[XSpriteC^[tF[X̊֌W
				 * console::SpritéAeNX`̃rbg}bvAuvWێAconsole::ObǰpNXɉconsole::Sprite::draw()\bh܂B<br>
 				 * console::Obj́Aconsole::Spriteʏǂ̂悤ɕ\̂w肷邽߂̃C^[tF[Xł*/
				class Sprite
				{
				public:
					/// fXgN^
					virtual ~Sprite(){;};
					/** ObjRectangle ɃXvCg`悵܂. 
					 * @param pObj ObjRectangleNXւ̃|C^ */
					virtual void draw(const sf::system::console::ObjRectangle * const pObj) = 0;
					/** ObjQuadrangle ɃXvCg`悵܂. 
					 * @param pObj ObjQuadrangleNXւ̃|C^ */
					virtual void draw(const sf::system::console::ObjQuadrangle * const pObj) = 0;
					/** Obj3DL ɃXvCg`悵܂. 
					 * @param pObj Obj3DL NXւ̃|C^ */
					virtual void draw(const sf::system::console::Obj3DL * const pObj) = 0;
					/** XvCg̒SXW擾.
					 * @return XvCg̒SXW */
					virtual const float centerX(void) const = 0;
					/** XvCg̒SYW擾.
					 * @return XvCg̒SYW */
					virtual const float centerY(void) const  = 0;
					/** XvCg̕擾.
					 * @return XvCg̕ */
					virtual const float width(void) const = 0;
					/** XvCg̒S擾.
					 * @return XvCg̍ */
					virtual const float height(void) const = 0;
				};// Sprite
				
				/// SpritẽX}[g|C^ 
				typedef std::auto_ptr<Sprite> PSprite;

			};
			
			/**  tHg֘A 
			 *łtHǵAOS̂ł͂ȂAƎɃrbg}bvŕێĂ̂܂B*/
			namespace font {
				const int COUNT_MAX = 2;///< tHg̐
				const int TEXTURE_WIDTH = 128;///< tHgrbg}bv̕
				const int TEXTURE_HEIGHT = 64;///< tHgrbg}bv̍
				const int WIDTH = 8;///< tHg̕
				const int HEIGHT = 8;///< tHg̍
				/// tHgt@Cl[z 
				const char FILE_PATH[COUNT_MAX][MAX_PATH_] 
					= {	"media\\font1.png",
					"media\\font2.png"
				};
			}

			/// eLXg֘A
			namespace text {
				const int BUFFER_LENGTH = 1024;///< eLXgێobt@̃TCY
				const float COLUMN_PITCH = 8.0f;///< eLXg̃Jsb`
				const float LINE_PITCH = 10.0f;///< eLXg̍ssb`
			}

			/// JX^_tH[}bg
			struct Vertex {
				float		x,///< xW
							y,///< yW
							z,///< zW
							rhw;///< ???
				DWORD	diffuse,///< fBt[Y
						specular;///< XyL[
				float   tu,///< eNX`u
						tv;///< eNX`v
			};


			/// ʂ̕`搧s
			/*! ʂ̕`搧sC^[tF[XłB 
			 * @note ConsoleNX́AOSŗL̉ʕ`̎𒊏ۉړI܂B<br>ۉsۂɂ́AOSɈˑȂʉtŋLqׂłA
			 * ҂DirectXmȂ߁AщOSŗL̕\\܂B*/
			class Console 
			{
				// LIFECYCLE //
			public:
				/// fXgN^
				virtual ~Console(){;};

				// OPERATORS //
				// OPERATIONS //
				/** ConsoleC^[tF[X̏s 
				 * Console C^[tF[X̎NX̏s߂̉z֐ŁAʏAvP[VĂяo邱Ƃ͂܂B
				 */
				virtual void initialize(void) = 0;

				/** ʏs.
				 * XN[܂B
				 * @param value hԂF */
				virtual void clearScreen(COLOR value = 0x00000000) = 0;

				/** ʏs.
				 * XN[wFœhԂ܂B
				 * @param value hԂF */
				virtual void fillScreen(COLOR value = 0x00000000) = 0;

				/** ʍXVs. 
				 * ʍXVs܂B
				 * Windowsł́AobNobt@vC}T[tF[Xւ̓]s܂B
				 * ܂AXvCg̕`AeLXgobt@ɒ~ςꂽ̕`킹čs܂B
				 */
				virtual void update(void) = 0;
				
				/// obNobt@Asciiw肵eNX`[ԍŕ\B
				/*! @param textureNo tHgpeNX`̔ԍ @ref sf::system::console::font::FILE_PATH Q
				 *	@param x \JnXW
				 *	@param y \JnYW
				 *	@param angleRad \pxWAŎw
				 *	@param scale gk
				 *	@param color \F
				 *  @param format printf̃tH[}bg
				 *  @param ... \ϐ */  
				virtual void print(const int textureNo,const float x,const float y,const float angleRad,const float scale,const COLOR color,
					const char *format,...) = 0;

				/**  XvCgf[^[h. 
				 * sprite::Infȍɏ]ăXvCgf[^[hASpriteC^[tF[X̃|C^Ԃ܂B
				 * @param pInfo sprite::Info \̂̃|C^ 
				 * @return SpriteC^[tF[Xւ̃|C^ */
				virtual sprite::Sprite * const createSprite(const sprite::Info* const pInfo) = 0;
				// ACCESS //
				
				// INQUIRY //
				/// R\[gpۂԂ
				/*! @retval true gp 
				 *  @retval false gps */
				virtual const bool isEnabled(void) const = 0;
			};// Console()
			
			/** XvCg`^Cv 
			 *
			 * XvCg̓ߏǂ̃^Cvōsw肵܂B */
			enum DrawMode {
				DRAW_TRANS,///< ʏ̓ߏ
				DRAW_ADD,///< Z
				DRAW_ADD1,///< Z1
				DRAW_SHADOW,///< Y܂
				DRAW_INV,///< ]
				DRAW_MUL///< Z
			};// DrawMode

		}// namespace console
	}// namespace system
}//namespace sf
}
#endif // !defined(AFX_IConsole_H__DB7BCF98_4A51_43E3_B919_9A26C58E6A90__INCLUDED_)
