/**
 * @file Obj.h
 * @brief XvCg̕\(WʒuAetc)ȂǂێĂC^[tF[XA萔̒`sB
 * 
 * @author S.F.
 * @version $Id:
 *
 * Copyright (C) 2000-2002 Satoshi Fujiwara. All Rights Reserved.
 */

/// dCN[hh~}N
#if !defined(AFX_OBJ_H__848EAA84_F65D_4C04_982A_EC1A7484C2E7__INCLUDED_)
#define AFX_OBJ_H__848EAA84_F65D_4C04_982A_EC1A7484C2E7__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "sf.h"
extern "C" {
namespace sf {
	namespace system {
		namespace console {

typedef	int OBJNO;///< OBJNO^̒`

/** XvCg\C^[tF[X.
 * ObjC^[tF[X́AXvCg̕\ێ܂B
 * ObjgAXg̃m[hƂȂĂāAObj::Listɓo^܂B*/
class SFDLL Obj
{
public:
	/// RXgN^
	Obj();
	/// fXgN^
	virtual ~Obj();

	/// IuWF`悷
	virtual void draw() = 0;

	// ACCESS //

	/** SpriteC^[tF[X̃AhX擾 
	 * @return SpriteC^[tF[X̃|C^ */
	virtual sprite::Sprite * const sprite() const = 0;
	
	/** SpriteC^[tF[X̃AhXݒ肷 
	 * @param value SpriteC^[tF[X̃|C^*/
	virtual void sprite(sprite::Sprite* const value) = 0;

	/** XvCgCfbNXQƂ. 
	 * CfbNX́ASpriterbg}bv̒̉Ԗڂ\邩܂B
	 * @return CfbNX */
	virtual const int index() const = 0;
	
	/** XvCgCfbNXݒ肷 
	 * @param value XvCgCfbNX */
	virtual void index(const int value) = 0;

	/** \E\QƂ 
	 * @retval true \
	 * @retval false \ */
	virtual const bool visibility() const = 0;

	/** \E\ݒ肷 
	 * @retval true \
	 * @retval false \ */
	virtual void visibility(const bool value) = 0;

	/** Õm[h̃|C^擾 
	 @return ObjC^[tF[X̃|C^B
	 null̏ꍇ͂ȏOɃf[^͂Ȃ	*/
	virtual Obj * const previous() const  = 0;

	/** Õm[h̃|C^ݒ肷 
	 @param value ObjC^[tF[X̃|C^*/
	virtual void previous(Obj * const value) = 0;
	
	/** ̃m[h̃|C^擾 
	 @return ObjC^[tF[X̃|C^B
	 null̏ꍇ͂ȏɃf[^͂Ȃ	*/
	virtual Obj * const next() const  = 0;

	/** ̃m[h̃|C^ݒ肷 
	 @param value ObjC^[tF[X̃|C^*/
	virtual void next(Obj * const value) = 0;

	/** zW擾 
	 * @return zW */
	virtual const float z() const  = 0;
	
	/** zWݒ肷 
	 * @param value zW */
	virtual void	z(const float value) = 0;

	/** `惂[hݒ肷 
	 * @param value DrawMode */
	virtual void drawMode(const DrawMode value) = 0;
	/** `惂[hQƂ 
	 * @return DrawMode */
	virtual const DrawMode drawMode() const  = 0;

	///oXgێNX 
	/*! Obj̃Xgێ܂B<br>
	ׂăX^eBbNoō\zĂ݂܂B*/
	class SFDLL List
	{
	public:
		/** Obj}.
		 * @param value Obj̃|C^ */
		static void insertObj(Obj *value);
		
		/** Obj폜.
		 * @param value Obj̃|C^ */
		static void deleteObj(Obj *value);

		/** 擪Ɉړ.
		 * @return Obj̃|C^ NULL̏ꍇ̓f[^Ȃ*/
		static Obj * moveTop();
		
		/** I[Ɉړ.
		 * @return value Obj̃|C^ NULL̏ꍇ̓f[^Ȃ*/
		static Obj * moveBottom();

		/** Ɉړ.
		 * @return value Obj̃|C^ NULL̏ꍇ̓f[^Ȃ*/
		static Obj * moveNext();

		/** OɈړ.
		 * @return value Obj̃|C^ NULL̏ꍇ̓f[^Ȃ*/
		static Obj * movePrevious();
		
	private:
		
		static Obj* mspCurrent;///< Jgm[h
		static Obj* mspTop;///< 擪m[h
		static Obj* mspBottom;///< I[m[h
		static int mCount;///< m[h̐
		
	};// List

};// Obj


		}
	}
}
}
#endif // !defined(AFX_OBJ_H__848EAA84_F65D_4C04_982A_EC1A7484C2E7__INCLUDED_)
