/**
 * @file
 * @brief 2DXvCg̒`s.
 * 
 * @author S.F.
 * @version $Id:
 *
 * Copyright (C) 2000-2002 Satoshi Fujiwara. All Rights Reserved.
 */

/// dCN[hh~p}N
#if !defined(OBJ2D)
#define OBJ2D

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
extern "C" {
namespace sf {
	namespace system {
		namespace console {

#include "sf.h"

/// 2DXvCg
class SFDLL Obj2D : public Obj
{
public:
	/// RXgN^
	Obj2D();
	/// fXgN^
	virtual ~Obj2D();

	/** XW擾 
	 * @return X W */
	virtual const float x() const { return mX;};
	
	/** XWݒ肷 
	 * @param value X W */
	virtual void	x(const float value) { mX = value;}; 
	
	/** YW擾 
	 * @return Y W */
	virtual const float	y()	const { return mY;};
	
	/** YWݒ肷 
	 * @param value Y W */
	virtual void	y(const float value) { mY = value;}; 
	
	/** ZW擾.
	 * OBJ2DłZl͕`D揇ʂƂȂ܂BZlɉXP[O͍s܂B
	 * @return Z W */
	virtual const float z() const { return mZ;};
	
	/** ZWݒ肷 
	 * @param value Z W */
	virtual void	z(const float value) { mZ = value;List::deleteObj(this); List::insertObj(this);};
	
	/** ]px擾 
	 * @param value ]px(WA) */
	virtual const float angle() const { return mAngle;};
	
	/** ]pxݒ肷 
	 * @return ]px(WA) */
	virtual void	angle(const float value) { mAngle = value;};
	
	/** X̊gk擾
	 * @return X̊g嗦k */
	virtual const float scalingX() const { return mScalingX;}; 
	
	/** X̊gkݒ肷
	 * @param value X̊gk */
	virtual void scalingX(const float value) { mScalingX = value;}; 
	
	/** Y̊gk擾
	 * @return Y̊gk */
	virtual const float scalingY() const { return mScalingY;}; 
	
	/** Y̊gkݒ肷
	 * @param value Y̊gk */
	virtual void scalingY(const float value) { mScalingY = value;}; 

	/** X]̏Ԃ擾 
	 * @retval true X]Ă 
	   @retval false X]ĂȂ@*/
	virtual const bool reverseX() const { return mbReverseX;};
	
	/** X]̏Ԃݒ肷
	 * @param value true X] false X]Ȃ*/
	virtual void reverseX(const bool value) { mbReverseX = value;}; 
	
	/** Y]̏Ԃ擾 
	 * @retval true Y]Ă 
	   @retval false Y]ĂȂ@*/
	virtual const bool reverseY() const { return mbReverseY;};
	
	/** Y]̏Ԃݒ肷
	 * @param value true Y] false Y]Ȃ*/
	virtual void reverseY(const bool value) { mbReverseY = value;}
	
	virtual void drawMode(const DrawMode value) { mDrawMode = value;};
	
	virtual const DrawMode drawMode() const  {return mDrawMode;}
	
	virtual sprite::Sprite * const sprite() const {return mpSprite;};
	virtual void sprite(sprite::Sprite* const value){ mpSprite = value;};

	virtual const int index() const { return mIndex;};
	virtual void index(const int value) { mIndex = value;};

	
	virtual const bool visibility() const {return mbVisibility;};
	virtual void visibility(const bool value){ mbVisibility = value;};
	
	virtual Obj * const previous()  const {return mpPrevious;};
	virtual void previous(Obj * const value){mpPrevious = value;};
	
	virtual Obj * const next() const {return mpNext;};
	virtual void next(Obj * const value){mpNext = value;};

private:

	float mX,///< XW
		  mY,///< YW
		  mZ,///< ZW(`D揇)
		  mRad,///< ]px(WAj
		  mAngle;///< ]px(WAj
	float mScalingX,///< X̊gk
		  mScalingY;///< Y̊gk
	bool mbVisibility;///< \邩Ȃ
	bool mbReverseX;///< X]邩Ȃ
	bool mbReverseY;///< Y]邩Ȃ
	
	sprite::Sprite *mpSprite;///< SpriteC^[tF[X̃|C^
	int mIndex;///< Sprite̒̃CfbNX

	DrawMode mDrawMode;///< DrawMode
	Obj* mpPrevious;///< OObj̃|C^
	Obj* mpNext;///< Obj̃|C^

};// Obj
		}
	}
}
}
#endif // !defined(AFX_OBJ_H__848EAA84_F65D_4C04_982A_EC1A7484C2E7__INCLUDED_)
