/**
 * @file
 * @brief 3DXvCg̒`s.
 * 
 * @author S.F.
 * @version $Id:
 *
 * Copyright (C) 2000-2002 Satoshi Fujiwara. All Rights Reserved.*/

/// dCN[hh~}N
#if !defined(AFX_OBJ3D_H__6F81DB0E_4F49_491D_9D09_E729679CE97A__INCLUDED_)
#define AFX_OBJ3D_H__6F81DB0E_4F49_491D_9D09_E729679CE97A__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
#include "sf.h"
#include "Obj.h"
extern "C" {
namespace sf{
	namespace system{
		namespace console {
/** 3DXvCgNX̒` */
class SFDLL Obj3D : public Obj  
{
	// LIFECYCLE //
public:
	/// RXgN^
	Obj3D();
	/// fXgN^
	virtual ~Obj3D();
	// OPERATORS //
	// OPERATIONS //
	
	// ACCESS //
	
	/** XN[XWݒ肷
	 * @param value XN[XW */
	void x(float value);
	
	/** ݐݒ肳ĂXN[XW擾
	 * @return value XN[XW */
	const float x(void) const {return mX;};
	
	/** ݐݒ肳Ă郏[hXW擾
	 * @return [hXW */
	const float spaceX(void) const {return mSpaceX;};
		
	/** XN[YWݒ肷
	 * @param value XN[YW */
	void y(const float value);
	
	/** ݐݒ肳ĂXN[YW擾
	 * @return value XN[YW */
	const float y(void) const { return mY;};
	
	/** ݐݒ肳Ă郏[hYW擾
	 * @return [hYW */
	const float spaceY(void) const {return mSpaceY;};

	/** XN[ZWݒ肷
	 * @param value XN[ZW */
	void  z(const float value);
	
	/** ݐݒ肳ĂXN[ZW擾
	 * @return value XN[ZW */
	const float  z(void) const {return mZ;};

	/** ݐݒ肳Ă郏[hZW擾
	 * @return [hZW */
	const float spaceZ(void) const { return mSpaceZ;};

	/** X]p(WA 0-2)擾 
	 * @return ]p 0-2 */
	const float angleX(void) const {return mAngleX;};
	/** X]p(WA 0-2)ݒ肷 
	 * @param value X]p */
	void  angleX(const float value);

	/** Y]p(WA 0-2)擾 
	 * @return ]p 0-2 */
	const float angleY(void) const {return mAngleY;};
	/** Y]p(WA 0-2)ݒ肷 
	 * @param value Y]p */
	void  angleY(const float value);

	/** Z]p(WA 0-2΁j擾 
	 @return ]p 0-2 */
	const float angleZ(void){return mAngleZ;};
	/** Z]p(WA 0-2΁jݒ肷 
	 @param value Z]p */
	void  angleZ(const float value);

	// 
	/** X]pCosl擾 
	* @return X]pCosl */
	const float rotXCos(void) const { return mRotXCos;};
	/** X]pSinl擾 
	* @return X]pSinl */
	const float rotXSin(void) const { return mRotXSin;};

	/** Y]pCosl擾 
	* @return Y]pCosl */
	const float rotYCos(void) const { return mRotYCos;};
	/** Y]pSinl擾 
	* @return Y]pSinl */
	const float rotYSin(void) const { return mRotYSin;};

	/** Z]pCosl擾 
	* @return Z]pCosl */
	const float rotZCos(void) const { return mRotZCos;};
	/** Z]pSinl擾 
	* @return Z]pSinl */
	const float rotZSin(void) const { return mRotZSin;};

	// XP[O

	/** Xgk 擾
	 * @return Xgk */
	const float scalingX(void) const {return mScalingX;};
	/** Xgk ݒ肷
	 * @param value  Xgk */
	void  scalingX(const float value){mScalingX = value;};

	/** Ygk擾 
	 * @return Ygk */
	const float scalingY(void) const {return mScalingY;};
	/** Ygk ݒ肷
	 * @param value  Ygk */
	void  scalingY(const float value){mScalingY = value;};

	// Z
	/** Zgk擾 
	 * @return Zgk */
	const float scalingZ(void) const {return mScalingZ;};
	/** Zgk ݒ肷
	 * @param value  Zgk */
	void  scalingZ(const float value){mScalingZ = value;};

	void drawMode(const DrawMode value) { mDrawMode = value;};
	const DrawMode drawMode() const {return mDrawMode;}
	
	// XvCg̃AhX //
	virtual sprite::Sprite * const sprite() const {return mpSprite;};
	virtual void sprite(sprite::Sprite* const value){ mpSprite = value;};

	virtual const int index() const { return mIndex;};
	virtual void index(const int value) { mIndex = value;};
	
	const bool visibility() const {return mbVisibility;};
	void visibility(const bool value){ mbVisibility = value;};
	
	Obj * const previous() const   {return mpPrevious;};
	void previous(Obj * const value){mpPrevious = value;};
	
	Obj * const next() const {return mpNext;};
	void next(Obj * const value){mpNext = value;};
	// INQUIRY //
private:
	// XN[W
	float mX;///< XN[WX
	float mY;///< XN[WY
	float mZ;///< XN[WZ

	// [hԍW
	float mSpaceX;///< [hԍWX
	float mSpaceY;///< [hԍWY
	float mSpaceZ;///< [hԍWZ
	
	float mAngleX;///< X]piWA 0-2΁j
	float mAngleY;///< Y]piWA 0-2΁j
	float mAngleZ;///< Z]piWA 0-2΁j

	float mRotXSin;///< X]pSinl
	float mRotYSin;///< X]pSinl
	float mRotZSin;///< X]pSinl
	float mRotXCos;///< X]pCosl
	float mRotYCos;///< X]pCosl
	float mRotZCos;///< X]pCosl
	
	float mScalingX;///< Xgk
	float mScalingY;///< Ygk
	float mScalingZ;///< Zgk
	
	bool mbVisibility;///< \邩Ȃ
	sprite::Sprite *mpSprite;///< sprite::SpriteC^[tF[X̃|C^
	int mIndex;///< \CfbNX
	DrawMode mDrawMode;///< DrawMode
	Obj* mpPrevious;///< OObjC^[tF[X
	Obj* mpNext;///< ObjC^[tF[X

};
		}
	}
}
}
#endif // !defined(AFX_OBJ3D_H__6F81DB0E_4F49_491D_9D09_E729679CE97A__INCLUDED_)
