/**
 * @file
 * @brief Sound֘A̎NXEɊւ萔`ȂǂsB
 * 
 * DirectSound DirectMusic gpĎĂ܂B
 * @author S.F.
 * @version $Id:
 *
 * Copyright (C) 2000-2002 Satoshi Fujiwara. All Rights Reserved.
 */

// [[Nop
#include "sfdebug.h"

// SYSTEM INCLUDES
//
#define WIN32_LEAN_AND_MEAN
#include "windows.h"
#include "windowsx.h"
//#include <dmusici.h>
#include "Xact3.h"
#include "dxerr8sf.h"
#include <string>

// PROJECT INCLUDES
//
#include "exception.h"
#include "System.h"
#include "Input.h"
#include "Sound.h"
#include "Console.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#include "SoundImpl.h"

// namespace 
using namespace sf::system::sound;

// ---------------------------------------------------------------------------
//
// SoundImpl NX
//
// ---------------------------------------------------------------------------

struct SoundImpl::impl 
{
	// LIFECYCLE
public:
	/// RXgN^
	impl()
	{
		mbEnabled = false;
		mpLoader = NULL;
		mpPerformance = NULL;
		mpDefaultAudioPath = NULL;

		for(int i = 0;i < OBJECT_MAX;i++)
		{
			mpSegment[i] = NULL;
			mpAudioPath[i] = NULL;
			mbSegInUse[i] = false;
			mFileName[i] = "";
		}
		
		mVolumeMax = volume::MAX;
		mMasterVolume = volume::MIN;

		initialize();

	};
	/// fXgN^
	~impl()
	{
		unload();
		
		if(mpDefaultAudioPath)
			mpDefaultAudioPath->Release();

		if(mpLoader){
			mpLoader->Release();
			mpLoader = NULL;
		}
		
		if(mpPerformance)
		{
			mpPerformance->CloseDown();
			mpPerformance->Release();
			mpPerformance = NULL;
			
		}
	};
	// OPERATORS //
	// OPERATIONS //
	void load(const int objNo,const char * const pFileName)
	{
		if(!isEnabled())
			return;

		if(objNo > OBJECT_MAX && objNo < 0){
			throw RecoverbleErrorException(L"Sound Buffer is full",__FILE__,__LINE__,sf::system::Exception::BUFFER_IS_FULL);
		}
		
		mpPerformance->Stop(NULL,NULL,0,0);
		
		if(mpSegment[objNo]){
			mpSegment[objNo]->Release();
		}
		
		// Load the segment from the file
		WCHAR wstrFileName[MAX_PATH];
		MultiByteToWideChar( CP_ACP, 0, pFileName, -1, 
			wstrFileName, MAX_PATH );
		
		if( FAILED( mpLoader->LoadObjectFromFile( CLSID_DirectMusicSegment,
			IID_IDirectMusicSegment8,
			wstrFileName,
			(LPVOID*) &mpSegment[objNo] ) ) )
		{
			throw FatalErrorException("Media not found",__FILE__,__LINE__);
		}
		
		IUnknown* pconfig = NULL;
	    
		if( SUCCEEDED( mpSegment[objNo]->GetAudioPathConfig( &pconfig ) ) )
		{
			mpPerformance->CreateAudioPath( pconfig, TRUE, &mpAudioPath[objNo] );
			pconfig->Release();
			mpSegment[objNo]->Download(mpAudioPath[objNo]);
		} else {
			mpSegment[objNo]->Download(mpPerformance);
		}

		char *pf = strupr(strdup(const_cast<char *>(pFileName)));
		mFileName[objNo] = pf;
		free(pf);
	};
	const int load(const char * const pFileName)
	{

		std::string tmp_str;
		char *pf = strupr(strdup(const_cast<char *>(pFileName)));
		tmp_str = pf;
		free(pf);
		int i;

		// t@C̃IuWFNgłɃ[hς݂
		// ΂̔ԍԂ 
		for(i = 0;i < OBJECT_MAX;i++){
			if(mFileName[i] == tmp_str){
				return i;
			}
		}

		// ΁A󂫂ă[h
		for(i = 0;i < OBJECT_MAX;i++){
			if(mpSegment[i] == NULL){
				load(i,pFileName);
				return i;
			}
		}

		return LOAD_ERROR;

	}
	void unload()
	{
		if(mpPerformance)
			mpPerformance->Stop(NULL,NULL,0,0);
		
		for(int i = 0;i < OBJECT_MAX;i++)
		{
			// ZOgNULLłȂȂ烊[X
			if(mpSegment[i]){
				// I[fBIpX̃[X
				if(mpAudioPath[i]){
					mpSegment[i]->Unload(mpAudioPath[i]);
					mpAudioPath[i]->Release();
					mpAudioPath[i] = NULL;
					mpSegment[i]->Release();
				} else {
					mpSegment[i]->Unload(mpPerformance);
					mpSegment[i]->Release();
				}
			}
			mpSegment[i] = NULL;
			mbSegInUse[i] = false;
		}
	}
	// TEh̍Đ
	void play(const int ObjNo,const DWORD Repeat,const bool bPrimary,const bool bSync)
	{
		if(isEnabled() && !mbSegInUse[ObjNo] && mpSegment[ObjNo])
		{
			if(mQueue.set(ObjNo,Repeat,bPrimary,bSync))
				mbSegInUse[ObjNo] = true;
		}
	}
	void stop(const int ObjNo = 0)
	{
		if(!isEnabled()) return;

		if(!ObjNo)
		{
			mQueue.clear();
			mpPerformance->Stop(NULL,NULL,0,0);
		} else {
			mpPerformance->Stop(mpSegment[ObjNo],NULL,0,0);
		}
	}
	void update()
	{
		if(!mQueue.isEmpty()){
			Queue::Data data;
			mQueue.get(data);

			if(!isEnabled())
				return;

			IDirectMusicAudioPath8* paudio_path = mpAudioPath[data.mObjNo];
			
			if(paudio_path == NULL)
				paudio_path = mpDefaultAudioPath;
			
			DWORD flags = NULL;

			if(!data.mbPrimary){
				flags |= DMUS_SEGF_SECONDARY;
	//			flags |= DMUS_SEGF_CONTROL;
			}

			if(data.mbSync){
				flags |= DMUS_SEGF_BEAT;
	//			flags &= !DMUS_SEGF_CONTROL;
			}

			if(!data.mRepeat)
				mpSegment[data.mObjNo]->SetRepeats(DMUS_SEG_REPEAT_INFINITE);
			else
				mpSegment[data.mObjNo]->SetRepeats(data.mRepeat - 1);

			

			if(mpSegment[data.mObjNo]){
				mpPerformance->PlaySegmentEx(
					mpSegment[data.mObjNo],  // ĐZOgB
					NULL,       // \OɎgpp[^BĂȂB
					NULL,       // gWVɊւp[^B 
					flags,		// tOB
					0,          // Jn^CB0 ͒ɊJnB
					NULL,       // ZOgԂ󂯎|C^B
					NULL,       // ~IuWFNgB
					paudio_path         // ftHgłȂꍇ̓I[fBIpXB
					);
				mbSegInUse[data.mObjNo] = false;
			}
		}
	
	}
	// ACCESS //
	void masterVolume(const int value)
	{
		if(!isEnabled())
			return;
		int tmp_value = value;

		if(tmp_value > mVolumeMax) tmp_value = mVolumeMax;
		if(tmp_value < volume::MIN) tmp_value = volume::MIN;

		mMasterVolume = tmp_value;
		mpDefaultAudioPath->SetVolume(value,0);
	}
	const int masterVolume() const {return mMasterVolume;}
	void volumeMax(const int value){mVolumeMax = value;};
	const int volumeMax() const {return mVolumeMax;};
	// INQUIRY //
	const bool isEnabled(void) const{return mbEnabled;};
	// 
	void initialize(void)
	{
		HRESULT hr = E_FAIL;
		std::string errTmp = "Sound Initialize Error:";

		CoCreateInstance(CLSID_DirectMusicLoader, NULL, 
			CLSCTX_INPROC, IID_IDirectMusicLoader8,
			(void**)&mpLoader);
		
		CoCreateInstance(CLSID_DirectMusicPerformance, NULL,
			CLSCTX_INPROC, IID_IDirectMusicPerformance8,
			(void**)&mpPerformance );
		
		// Initialize the performance with the standard audio path.
		// This initializes both DirectMusic and DirectSound and 
		// sets up the synthesizer. 
		hr = mpPerformance->InitAudio( NULL, NULL, NULL, 
			DMUS_APATH_SHARED_STEREOPLUSREVERB, 64,
			0, NULL );
		
		if(FAILED(hr)){
			errTmp += DXGetErrorString8(hr);
			throw FatalErrorException(errTmp,__FILE__,__LINE__);
		}
		
		char strPath[MAX_PATH] = ".\\media\\";
		
		// Tell DirectMusic where the default search path is
		WCHAR wstrSearchPath[MAX_PATH];
		MultiByteToWideChar( CP_ACP, 0, strPath, -1, 
			wstrSearchPath, MAX_PATH );
		
		hr = mpLoader->SetSearchDirectory( GUID_DirectMusicAllTypes, 
			wstrSearchPath, FALSE );
		
		if(FAILED(hr)){
			errTmp += DXGetErrorString8(hr);
			throw FatalErrorException(errTmp,__FILE__,__LINE__);
		}
		
		// ftHg̃I[fBIpX̐ݒ
		hr = mpPerformance->CreateStandardAudioPath(
			DMUS_APATH_DYNAMIC_STEREO  , 
			64, 
			TRUE,
			&mpDefaultAudioPath);
		
		if(FAILED(hr)){
			errTmp += DXGetErrorString8(hr);
			throw FatalErrorException(errTmp,__FILE__,__LINE__);
		}
		
		mpDefaultAudioPath->SetVolume(mMasterVolume,0);
 		mbEnabled = true;
	};

private:


	IDirectMusicLoader8*		mpLoader;///< [_[ 
	IDirectMusicPerformance8*	mpPerformance;///< ptH[}X
	IDirectMusicSegment8*		mpSegment[OBJECT_MAX];///< ZOgz
	IDirectMusicAudioPath8*		mpAudioPath[OBJECT_MAX];///< I[fBIpX
	IDirectMusicAudioPath8*		mpDefaultAudioPath;///< ̃I[fBIpX
	std::string					mFileName[OBJECT_MAX];///< TEhPATHz

	bool mbSegInUse[OBJECT_MAX];///< ݃ZOggpĂ邩ێĂz
	int mMasterVolume;///< }X^[{[
	int mVolumeMax;///< ĐɎgp鉹ʂ̒l

    /** QueueNX 
	 * TEh͍Đw莞ɂ̃L[ɈU~At[ɂPqueueoAupdate()ōĐ܂ */
	class SFDLL Queue {
	public:
		/// RXgN^
		Queue();
		/// fXgN^
		~Queue();
		/// Queuep[^\
		struct Data
		{
			int mObjNo;		///< ZOgԍ
			long mRepeat;	///< s[g 0 ͖
			bool mbPrimary;	///< vC}ǂ
			bool mbSync;	///<  vC}Ɣœ邩
		};
		// OPERATIONS//
		
		/** Queue擾Aobt@. 
		 * @param rData Data\̂̎Q*/
		void get(Data& rData);

		/** QueueɃf[^Zbg.
		 * @param ObjNo TEhԍ 
		 * @param Repeat s[g(0́) 
		 * @param bPrimary vC}obt@ōĐ邩ǂ 
		 * @param bSync vC}TEhƓ邩ǂ  */
		const bool set(const int ObjNo,const DWORD Repeat,const bool bPrimary,const bool bSync);
		
		/// L[NA 
		void clear();
		// INQUIRY //

		/** queue(@ref mBuffer)󂩂ǂ₢킹.
		 @retval true ł
		 @retval false łȂ */
		const bool isEmpty() const {return (mStart == mEnd);};
	private:
		Data mBuffer[Q_MAX];	///< Queueobt@z
		int mStart;			///< Oobt@Jnʒu
		int mEnd;			///< Oobt@Iʒu

	};// Queue
	
	Queue mQueue;	///< TEhpL[IuWFNg
	bool mbEnabled;	///< TEh͎gp\ǂێ
};

// RXgN^ -------------------------------------------------------------
SoundImpl::SoundImpl() : impl_(new SoundImpl::impl())
{
				
}// SoundImpl()

// fXgN^ ---------------------------------------------------------------
SoundImpl::~SoundImpl()
{
	

} // ~SoundImpl()

//  ---------------------------------------------------------------------
void SoundImpl::initialize(void)
{
	impl_->initialize();
	

}// initialize() 

// TEh̍Đ -----------------------------------------------
void SoundImpl::play(const int ObjNo,const DWORD Repeat,const bool bPrimary,const bool bSync)
{
	impl_->play(ObjNo,Repeat,bPrimary,bSync);

	
}// play

// L[TEhNooAĐ -----------------------
void SoundImpl::update()
{
	impl_->update();
}// update

// TEht@C̃[h ---------------------------------------
void SoundImpl::load(const int objNo,const char * const pFileName)
{
	impl_->load(objNo,pFileName);

}// load

//@TEhIuWFNg̃[h ||||||||||||||||||||||
const int SoundImpl::load(const char * const pFileName)
{
	impl_->load(pFileName);
}// load

// A[h -----------------------------------------------------
void SoundImpl::unload()
{
	impl_->unload();
}// unload

void SoundImpl::masterVolume(const int value)
{
	impl_->masterVolume(value);
}// masterVolume


// ---------------------------------------------------------------------------
//
// SoundImpl::Queue NX
//
// ---------------------------------------------------------------------------

// RXgN^ -------------------------------------------------
SoundImpl::impl::Queue::Queue()
{
	clear();
}// Queue

// fXgN^ ---------------------------------------------------
SoundImpl::impl::Queue::~Queue(){;};

// Oobt@ɃTEhԍZbg -------------------------
const bool SoundImpl::impl::Queue::set(const int ObjNo,const DWORD Repeat,const bool bPrimary,const bool bSync)
{
	if(mBuffer[mEnd].mObjNo == 0){
		mBuffer[mEnd].mObjNo = ObjNo + 1;
		mBuffer[mEnd].mRepeat = Repeat;
		mBuffer[mEnd].mbPrimary = bPrimary;
		mBuffer[mEnd].mbSync = bSync;
		mEnd = (mEnd + 1) & (Q_MAX - 1);
		return true;
	} else {
		return false;
	}
}// set

// Oobt@TEhf[^o -----------------------
void SoundImpl::impl::Queue::get(Data& rData)
{
	if(mStart == mEnd)
	{ rData.mObjNo =0;
		return;
	}
	
	rData = mBuffer[mStart];
	rData.mObjNo -= 1;
	mBuffer[mStart].mObjNo = 0;
	
	mStart = (mStart + 1) & (Q_MAX - 1);

}// get

// Oobt@NA -------------------------------------
void SoundImpl::impl::Queue::clear()
{
	mStart = mEnd = 0;
	ZeroMemory(mBuffer,sizeof(mBuffer));
}// clear

void SoundImpl::stop(int ObjNo)
{
	impl_->stop(ObjNo);
}
