/** 
 * @file
 * @brief System C^[tF[X̎NXNX
 *
 * @author S.F.
 * @version $Id:
 * 2001/3/13 Ղ[񂳂̃CuQlWindowsbZ[W@ύX
 * (QƁEp̋͂Ղ[񂳂(http://puyon.pns.to/)肢Ă܂B)
 * Copyright (C) 2000 Satoshi Fujiwara. All Rights Reserved.
 */

#if !defined(AFX_SystemImpl_H__64DBDEBB_81F1_4542_AAF7_B212CB9F4604__INCLUDED_)
/// dCN[hh~̂߂̒`
#define AFX_SystemImpl_H__64DBDEBB_81F1_4542_AAF7_B212CB9F4604__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
#include "sf.h" 

namespace sf {
	namespace system {
extern "C" {

	/** @ref System C^[tF[X̎NX. 
	 *
	 * VXeC^[tF[X̎NXłB
	 * VXe\[Xpۂ́ASystem C^[tF[Xgp܂Aۂ͉z֐̎dg݂ɂA̎NX̃\bhĂ΂܂B
	 * ́AOSɈˑ镔̃NXɉB邽߂ɍsĂ܂ */
	class SystemImpl : public System,sf::system::Win32
		{
			// Singleton͂邽߂̃}N
			DECLARE_SINGLETON(SystemImpl)
			// LIFECYCLE //
			/// RXgN^
			SystemImpl();
		public:
			/// EBhEbZ[Wi[
			typedef std::map<DWORD,WindowMessage * > WindowMessageMap;

			/// fXgN^
			virtual ~SystemImpl();
			// OPERATORS //
			// OPERATIONS //
			/** WinMain Ă΂郁\bh.
			 * WinMain()SystemImplCX^X𐶐Ã\bhĂяo܂B*/
			int winMain (const HINSTANCE hThisInstance, const HINSTANCE hPrevInstance,
				const LPSTR lpszCmdParam, const int nCmdShow);
			
			/** WindowsCxg p. */
			static LRESULT CALLBACK wndFunc(HWND hwnd, UINT message, WPARAM wParam,  LPARAM lParam);
			
			/** EBhEbZ[Wǉ.
			 * EBhEbZ[WŒǉ܂B
			 * ŒǉȂbZ[ẂAftHg̏Ă΂܂B
			 * @param value EBhEbZ[W
			 * @param pWindowMessage WindowMessagẽ|C^ */
			const bool addWindowMessage(const DWORD value,WindowMessage * pWindowMessage)
			{
				if(mWindowMessageMap[value] == NULL){
					mWindowMessageMap[value] = pWindowMessage;
					return true;
				} else {
					return false;
				}
			};

			virtual void wait(void);
			// G[\ďI
			virtual void errorTerminate(const wchar_t *errString);
			// G[\
			virtual void outputError(const wchar_t *errString);

			// ACCESS //
			virtual void  timerInterval(const unsigned long msValue){mTimerInterval = msValue;};	
			virtual const unsigned long timerInterval(void) const {return mTimerInterval;};
			virtual const DWORD time (void) const { return timeGetTime();};
			
			virtual console::Console * const console(void){ return mpConsole;};
			virtual sound::Sound * const sound(void){ return mpSound;};
			virtual input::Input * const input(void){ return mpInput;};
			
			virtual application::Main * const main(){return mpMain;}
			virtual void main(application::Main * const pMain ){mpMain = pMain;}

			// INQUIRY //
			virtual bool isActive(void) {return mIsWindowActive;};
			virtual const float deltaTime(void){return mFrameStep;};
			virtual const float framePerSec(void){return mFramePerSec;};
		private:
			/** I.
			 * JȂȂARelease()ȂĂ͂ȂCOMC^[tF[XȂǂ͂ŊJ܂B*/
			void uninitialize(void);

			/** ݃EBhEANeBuł邩ǂ₢킹.
			 * @param true ANeBuł
			 * @param false ANeBułȂ */
			const bool isWindowActive(void) const {return mIsWindowActive;};

			/** ݃EBhEANeBuł邩ǂݒ肷.
			 * @param true ANeBuł
			 * @param false ANeBułȂ */
			void windowActivate(const bool value){mIsWindowActive = value;};
			/** ^C}[ϐ */
			void initTimer(void);
			/** mWindowMessageMap ZbgAbv */
			void setupMessageMap(void);
			

			// Window Events
			/** WM_ABOUTbZ[W̏
			 * @param hwnd EBhEnh */
			LRESULT 	onAbout(const HWND hwnd);

			/** WM_COMMANDbZ[W̏
			 * @param hwnd EBhEnh 
			 * @param wParam WPARAM 
			 * @param lParam LPARAM */
			LRESULT 	onCommand(const HWND hwnd,const WPARAM wParam, const LPARAM lParam);

			/** WM_ACTIVATEbZ[W̏
			 * @param hwnd EBhEnh 
			 * @param wParam WPARAM 
			 * @param lParam LPARAM */
			LRESULT 	onActivate(const HWND hwnd,const WPARAM wParam,const LPARAM lParam);

			/** WM_MOVEbZ[W̏
			 * @param hwnd EBhEnh 
			 * @param wParam WPARAM 
			 * @param lParam LPARAM */
			LRESULT 	onMove(const HWND hwnd,const WPARAM wParam,const LPARAM lParam);

			/** WM_SIZEbZ[W̏
			 * @param hwnd EBhEnh 
			 * @param wParam WPARAM 
			 * @param lParam LPARAM */
			LRESULT 	onSize(const HWND hwnd,const WPARAM wParam,const LPARAM lParam);

			/** WM_PAINTbZ[W̏
			 * @param hwnd EBhEnh 
			 * @param wParam WPARAM 
			 * @param lParam LPARAM */
			LRESULT		onPaint(const HWND hwnd, const WPARAM wParam, const LPARAM lParam);

			/** WM_SYSCOMMANDbZ[W̏
			 * @param hwnd EBhEnh 
			 * @param wParam WPARAM 
			 * @param lParam LPARAM */
			LRESULT		onSysCommand(const HWND hwnd, const WPARAM wParam, const LPARAM lParam);
			
			HWND		mHWNDMain;///< CEBhEnh

			console::Console 	*mpConsole;///< console::ConsoleC^[tF[X̃|C^
			sound::Sound 		*mpSound;///< sound::SoundC^[tF[X̃|C^
			input::Input		*mpInput;///< input::InputC^[tF[X̃|C^

			::sf::application::Main 		*mpMain;///< ::sf::application::MainC^[tF[X̃|C^
			
						
			bool 		mIsWindowActive;///< ݃EBhEANeBuǂH
			bool		mbWindowed;///<EBhE[htXN[[hH
			
			DWORD		mTimerInterval;///< t[ێ^C}[̊Ԋu(ms)
			DWORD		mTimerValue;///< ݂̃^C}[̒l(ms)
			DWORD		mTimerBefore;///< 1t[Õ^C}[̒l(ms)
			DWORD		mTimerElapsed;///< 1t[̏X̏ɗv(ms)

			WindowMessageMap mWindowMessageMap;///< EBhEbZ[W}bv
			float		mFrameStep;///< 1t[̊{l
			float		mFramePerSec;///< FPSl
			static		SystemImpl *pSystemImpl;///< g̃|C^
			// constant
			static const wchar_t smAppName[];///< AvP[V
		};// SystemImpl
		}
	}// namespace system
} // namespace sf
#endif // !defined(AFX_SystemImpl_H__64DBDEBB_81F1_4542_AAF7_B212CB9F4604__INCLUDED_)
