import java.awt.Image;
import java.io.IOException;

import javax.imageio.ImageIO;

/* 
 *    Copyright 2013 Mimisuke
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

public class Toy extends Obj implements java.io.Serializable {
	static final long serialVersionUID = 1L;

	private static final int BALL = 0;
	private static final int SHADOW = 1;
	private static final int NUM_OF_BALL_IMG = 2;
	private static int toysize = 16;
	private static Image[] images = new Image[NUM_OF_BALL_IMG];
	
	public static void loadImages (ClassLoader loader) throws IOException {
		final String path = "images/toy/";

		images[BALL] = ImageIO.read(loader.getResourceAsStream(path+"ball.png"));
		images[SHADOW] = ImageIO.read(loader.getResourceAsStream(path+"shadow.png"));
		
		for (int i=0; i < NUM_OF_BALL_IMG; i++) {
			images[i] = images[i].getScaledInstance(toysize, toysize, Image.SCALE_AREA_AVERAGING);
		}
	}
	
	public Image getImage() {
		return (images[BALL]);
	}
	
	public Image getShadowImage() {
		return images[SHADOW];
	}
	
	public int getSize() {
		return toysize;
	}

	public static int getSizeS() {
		return toysize;
	}

	public Toy(int initX, int initY) {
		objType = Type.TOY;
		x = initX;
		y = initY;
		z = 0;
		removed = false;
	}
	
	public void kick() {
		kick(0, -8, -4);
	}	
}